/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime.wl;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

class SpinReadWriteLock
implements ReadWriteLock {
    private final int numThreads;
    private final AtomicInteger lock;

    public SpinReadWriteLock(int numThreads) {
        this.numThreads = numThreads;
        this.lock = new AtomicInteger();
    }

    @Override
    public Lock readLock() {
        return new ReadLock();
    }

    @Override
    public Lock writeLock() {
        return new WriteLock();
    }

    private class ReadLock
    implements Lock {
        private ReadLock() {
        }

        @Override
        public void lock() {
            while (SpinReadWriteLock.this.lock.incrementAndGet() <= 0) {
                SpinReadWriteLock.this.lock.decrementAndGet();
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock() {
            if (SpinReadWriteLock.this.lock.incrementAndGet() > 0) {
                return true;
            }
            SpinReadWriteLock.this.lock.decrementAndGet();
            return false;
        }

        @Override
        public boolean tryLock(long arg0, TimeUnit arg1) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void unlock() {
            SpinReadWriteLock.this.lock.decrementAndGet();
        }
    }

    private class WriteLock
    implements Lock {
        private WriteLock() {
        }

        @Override
        public void lock() {
            while (!SpinReadWriteLock.this.lock.compareAndSet(0, -SpinReadWriteLock.this.numThreads)) {
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock() {
            return SpinReadWriteLock.this.lock.compareAndSet(0, -SpinReadWriteLock.this.numThreads);
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void unlock() {
            while (!SpinReadWriteLock.this.lock.compareAndSet(-SpinReadWriteLock.this.numThreads, 0)) {
            }
        }
    }
}

