/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime.wl;

import galois.runtime.wl.AbstractParameterWorklist;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class ParameterUnorderedWorklist<T>
extends AbstractParameterWorklist<T, T> {
    @Override
    protected AbstractParameterWorklist.InternalParameterQueue<T> makeInternalQueue() {
        return new RandomList();
    }

    @Override
    protected T wrap(T x) {
        return x;
    }

    private static class RandomList<U>
    implements AbstractParameterWorklist.InternalParameterQueue<U> {
        private List<U> backingList = new ArrayList<U>();
        private Random r = new Random();

        private RandomList() {
        }

        @Override
        public void add(U o) {
            this.backingList.add(o);
        }

        @Override
        public U poll() {
            int size = this.backingList.size();
            int x = this.r.nextInt(size);
            U retval = this.backingList.get(x);
            U lastElement = this.backingList.get(size - 1);
            this.backingList.set(x, lastElement);
            this.backingList.remove(size - 1);
            return retval;
        }

        @Override
        public boolean isEmpty() {
            return this.backingList.isEmpty();
        }

        @Override
        public int size() {
            return this.backingList.size();
        }

        @Override
        public RandomList<U> copy() {
            RandomList<U> retval = new RandomList<U>();
            retval.backingList = new ArrayList<U>(this.backingList);
            return retval;
        }

        @Override
        public void clear() {
            this.backingList.clear();
        }
    }
}

