/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime.wl;

import galois.runtime.wl.AbstractParameterWorklist;
import java.util.Comparator;
import java.util.PriorityQueue;
import util.MutableReference;

public class ParameterOrderedWorklist<T>
extends AbstractParameterWorklist<T, MutableReference<T>> {
    private Comparator<T> comparator;

    public ParameterOrderedWorklist(Comparator<T> comparator) {
        this.comparator = comparator;
        this.current = this.makeInternalQueue();
        this.next = this.makeInternalQueue();
    }

    public Comparator<T> comparator() {
        return this.comparator;
    }

    public boolean canCommit(T x) {
        if (this.next.isEmpty()) {
            return true;
        }
        Object top = ((OrderedList)this.next).peek().get();
        return this.comparator.compare(x, top) <= 0;
    }

    @Override
    protected MutableReference<T> wrap(T x) {
        return new Box<T>(x);
    }

    @Override
    protected OrderedList<T> makeInternalQueue() {
        if (this.comparator == null) {
            return null;
        }
        return new OrderedList(this.comparator);
    }

    private static class Box<S>
    extends MutableReference<S> {
        public Box(S obj) {
            super(obj);
        }

        public boolean equals(Object o) {
            return this == o;
        }
    }

    private static class OrderedList<U>
    implements AbstractParameterWorklist.InternalParameterQueue<MutableReference<U>> {
        private PriorityQueue<MutableReference<U>> pq;
        private Comparator<U> comparator;

        private OrderedList(final Comparator<U> comparator) {
            this.comparator = comparator;
            this.pq = new PriorityQueue(20, new Comparator<MutableReference<U>>(){

                @Override
                public int compare(MutableReference<U> o1, MutableReference<U> o2) {
                    return comparator.compare(o1.get(), o2.get());
                }
            });
        }

        @Override
        public void add(MutableReference<U> o) {
            this.pq.add(o);
        }

        @Override
        public boolean isEmpty() {
            return this.pq.isEmpty();
        }

        @Override
        public MutableReference<U> poll() {
            return this.pq.poll();
        }

        @Override
        public int size() {
            return this.pq.size();
        }

        public MutableReference<U> peek() {
            return this.pq.peek();
        }

        @Override
        public OrderedList<U> copy() {
            OrderedList<U> retval = new OrderedList<U>(this.comparator);
            retval.pq = new PriorityQueue<MutableReference<U>>(this.pq);
            return retval;
        }

        @Override
        public void clear() {
            this.pq.clear();
        }
    }
}

