/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime.wl;

import galois.runtime.ForeachContext;
import galois.runtime.wl.Maker;
import galois.runtime.wl.MatchingConcurrentVersion;
import galois.runtime.wl.MatchingLeafVersion;
import galois.runtime.wl.OnlyLeaf;
import galois.runtime.wl.Worklist;
import java.util.Arrays;
import java.util.Random;

@OnlyLeaf
@MatchingConcurrentVersion(value=ConcurrentRandomOrder.class)
@MatchingLeafVersion(value=ConcurrentRandomOrder.class)
class ConcurrentRandomOrder<T>
implements Worklist<T> {
    private int queueSize;
    private final Random rand = new Random();
    private T[] queue;

    public ConcurrentRandomOrder(Maker<T> maker, boolean needSize) {
        this(1024, maker, needSize);
    }

    public ConcurrentRandomOrder(int startingSize, Maker<T> maker, boolean needSize) {
        this.queue = new Object[startingSize];
        this.queueSize = 0;
    }

    @Override
    public Worklist<T> newInstance() {
        return new ConcurrentRandomOrder<T>(this.queue.length, null, false);
    }

    @Override
    public synchronized void add(T item, ForeachContext<T> ctx) {
        if (this.queueSize + 1 >= this.queue.length) {
            this.resize();
        }
        this.queue[this.queueSize++] = item;
    }

    @Override
    public void addInitial(T item, ForeachContext<T> ctx) {
        this.add(item, ctx);
    }

    @Override
    public synchronized T poll(ForeachContext<T> ctx) {
        T retval = null;
        if (this.queueSize != 0) {
            int bucket = this.rand.nextInt(this.queueSize);
            retval = this.queue[bucket];
            this.queue[bucket] = this.queue[this.queueSize - 1];
            this.queue[this.queueSize - 1] = null;
            --this.queueSize;
        }
        return retval;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.queueSize == 0;
    }

    @Override
    public synchronized int size() {
        return this.queueSize;
    }

    @Override
    public void finishAddInitial() {
    }

    private void resize() {
        this.queue = Arrays.copyOf(this.queue, this.queue.length * 2);
    }
}

