/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime.wl;

import galois.runtime.ForeachContext;
import galois.runtime.wl.Maker;
import galois.runtime.wl.MatchingConcurrentVersion;
import galois.runtime.wl.MatchingLeafVersion;
import galois.runtime.wl.OnlyLeaf;
import galois.runtime.wl.OrderableWorklist;
import galois.runtime.wl.Worklist;
import java.util.Comparator;
import java.util.concurrent.PriorityBlockingQueue;

@OnlyLeaf
@MatchingLeafVersion(value=ConcurrentOrderedLeaf.class)
@MatchingConcurrentVersion(value=ConcurrentOrderedLeaf.class)
class ConcurrentOrderedLeaf<T>
implements OrderableWorklist<T> {
    private final PriorityBlockingQueue<T> queue;
    private final Comparator<T> comp;

    public ConcurrentOrderedLeaf(Comparator<T> comp, Maker<T> maker, boolean needSize) {
        this.comp = comp;
        this.queue = new PriorityBlockingQueue<T>(111, comp);
    }

    @Override
    public Worklist<T> newInstance() {
        return new ConcurrentOrderedLeaf<T>(this.comp, null, false);
    }

    @Override
    public void add(T item, ForeachContext<T> ctx) {
        this.queue.add(item);
    }

    @Override
    public void addInitial(T item, ForeachContext<T> ctx) {
        this.add(item, ctx);
    }

    @Override
    public T poll(ForeachContext<T> ctx) {
        return this.queue.poll();
    }

    @Override
    public T peek() {
        return this.queue.peek();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public Comparator<T> getComparator() {
        return this.comp;
    }

    @Override
    public void finishAddInitial() {
    }
}

