/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime.wl;

import galois.runtime.ForeachContext;
import galois.runtime.GaloisRuntime;
import galois.runtime.wl.BoundedLIFO;
import galois.runtime.wl.Maker;
import galois.runtime.wl.MatchingConcurrentVersion;
import galois.runtime.wl.MatchingLeafVersion;
import galois.runtime.wl.OnlyLeaf;
import galois.runtime.wl.Worklist;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

@OnlyLeaf
@MatchingConcurrentVersion(value=ConcurrentChunkedRandomOrder.class)
@MatchingLeafVersion(value=ConcurrentChunkedRandomOrder.class)
class ConcurrentChunkedRandomOrder<T>
implements Worklist<T> {
    private final int chunkSize;
    private final Random[] rand;
    private final int initialCapacity;
    private int queueSize;
    private T[] queue;
    private Worklist<T>[] current;
    private AtomicInteger size;

    public ConcurrentChunkedRandomOrder(Maker<T> maker, boolean needSize) {
        this(32, 1024, maker, needSize);
    }

    public ConcurrentChunkedRandomOrder(int chunkSize, Maker<T> maker, boolean needSize) {
        this(chunkSize, 1024, maker, needSize);
    }

    public ConcurrentChunkedRandomOrder(int chunkSize, int initialCapacity, Maker<T> maker, boolean needSize) {
        this(initialCapacity, initialCapacity, (Worklist<T>[])null, needSize);
        int numThreads = GaloisRuntime.getRuntime().getMaxThreads();
        this.current = new Worklist[numThreads];
        int i = 0;
        while (i < numThreads) {
            this.current[i] = new BoundedLIFO(chunkSize, null, false);
            ++i;
        }
    }

    private ConcurrentChunkedRandomOrder(int chunkSize, int initialCapacity, Worklist<T>[] current, boolean needSize) {
        this.chunkSize = chunkSize;
        this.initialCapacity = initialCapacity;
        this.current = current;
        int numThreads = GaloisRuntime.getRuntime().getMaxThreads();
        this.rand = new Random[numThreads];
        int i = 0;
        while (i < numThreads) {
            this.rand[i] = new Random();
            ++i;
        }
        this.queue = new Object[initialCapacity];
        if (needSize) {
            this.size = new AtomicInteger();
        }
    }

    @Override
    public Worklist<T> newInstance() {
        int numThreads = this.current.length;
        Worklist[] c = new Worklist[numThreads];
        int i = 0;
        while (i < numThreads) {
            c[i] = this.current[i].newInstance();
            ++i;
        }
        return new ConcurrentChunkedRandomOrder<T>(this.chunkSize, this.initialCapacity, c, this.size != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(T item, ForeachContext<T> ctx) {
        int tid = ctx.getThreadId();
        if (this.size != null) {
            this.size.incrementAndGet();
        }
        Worklist<T> c = this.current[tid];
        c.add(item, ctx);
        if (c.size() >= this.chunkSize) {
            ConcurrentChunkedRandomOrder concurrentChunkedRandomOrder = this;
            synchronized (concurrentChunkedRandomOrder) {
                T t;
                while ((t = c.poll(ctx)) != null) {
                    this.addInternal(t);
                }
            }
        }
    }

    private void addInternal(T item) {
        if (this.queueSize + 1 >= this.queue.length) {
            this.resize();
        }
        this.queue[this.queueSize++] = item;
    }

    @Override
    public synchronized void addInitial(T item, ForeachContext<T> ctx) {
        if (this.size != null) {
            this.size.incrementAndGet();
        }
        this.addInternal(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T poll(ForeachContext<T> ctx) {
        int tid = ctx.getThreadId();
        T retval = this.current[tid].poll(ctx);
        if (retval == null) {
            ConcurrentChunkedRandomOrder concurrentChunkedRandomOrder = this;
            synchronized (concurrentChunkedRandomOrder) {
                int i = 0;
                while (i < this.chunkSize + 1) {
                    if (this.queueSize == 0) break;
                    int bucket = this.rand[tid].nextInt(this.queueSize);
                    T item = this.queue[bucket];
                    if (retval == null) {
                        retval = item;
                    } else {
                        this.current[tid].add(item, ctx);
                    }
                    this.queue[bucket] = this.queue[this.queueSize - 1];
                    this.queue[this.queueSize - 1] = null;
                    --this.queueSize;
                    ++i;
                }
            }
        }
        if (this.size != null && retval != null) {
            this.size.decrementAndGet();
        }
        return retval;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.queueSize == 0;
    }

    @Override
    public int size() {
        if (this.size != null) {
            return this.size.get();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void finishAddInitial() {
    }

    private void resize() {
        this.queue = Arrays.copyOf(this.queue, this.queue.length * 2);
    }
}

