/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime.wl;

import galois.runtime.ForeachContext;
import galois.runtime.GaloisRuntime;
import galois.runtime.wl.ConcurrentChunkedFIFOLeaf;
import galois.runtime.wl.Maker;
import galois.runtime.wl.MatchingConcurrentVersion;
import galois.runtime.wl.MatchingLeafVersion;
import galois.runtime.wl.NestedAreSerial;
import galois.runtime.wl.Worklist;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

@NestedAreSerial
@MatchingConcurrentVersion(value=ConcurrentChunkedFIFO.class)
@MatchingLeafVersion(value=ConcurrentChunkedFIFOLeaf.class)
class ConcurrentChunkedFIFO<T>
implements Worklist<T> {
    private static final int CACHE_MULTIPLE = 16;
    private final int chunkSize;
    private Worklist<T>[] current;
    private Worklist<T>[] next;
    private final ConcurrentLinkedQueue<Worklist<T>> pool;
    private AtomicInteger size;

    public ConcurrentChunkedFIFO(Maker<T> maker, boolean needSize) {
        this(32, maker, needSize);
    }

    public ConcurrentChunkedFIFO(int chunkSize, Maker<T> maker, boolean needSize) {
        this(chunkSize, null, null, needSize);
        int numThreads = GaloisRuntime.getRuntime().getMaxThreads();
        this.current = new Worklist[numThreads * 16];
        this.next = new Worklist[numThreads * 16];
        int i = 0;
        while (i < numThreads) {
            this.current[super.getIndex((int)i)] = maker.make();
            this.next[super.getIndex((int)i)] = maker.make();
            ++i;
        }
    }

    private ConcurrentChunkedFIFO(int chunkSize, Worklist<T>[] current, Worklist<T>[] next, boolean needSize) {
        this.chunkSize = chunkSize;
        this.current = current;
        this.next = next;
        this.pool = new ConcurrentLinkedQueue();
        if (needSize) {
            this.size = new AtomicInteger();
        }
    }

    @Override
    public Worklist<T> newInstance() {
        int numThreads = this.current.length / 16;
        Worklist[] c = new Worklist[numThreads * 16];
        Worklist[] n = new Worklist[numThreads * 16];
        int i = 0;
        while (i < numThreads) {
            c[this.getIndex((int)i)] = this.current[this.getIndex(i)].newInstance();
            n[this.getIndex((int)i)] = this.next[this.getIndex(i)].newInstance();
            ++i;
        }
        return new ConcurrentChunkedFIFO<T>(this.chunkSize, c, n, this.size != null);
    }

    private int getIndex(int tid) {
        return tid * 16;
    }

    @Override
    public void add(T item, ForeachContext<T> ctx) {
        int tid = ctx.getThreadId();
        int idx = this.getIndex(tid);
        if (this.size != null) {
            this.size.incrementAndGet();
        }
        Worklist<T> n = this.next[idx];
        n.add(item, ctx);
        if (n.size() >= this.chunkSize) {
            this.pool.add(n);
            this.next[idx] = n.newInstance();
        }
    }

    @Override
    public void addInitial(T item, ForeachContext<T> ctx) {
        this.add(item, ctx);
    }

    @Override
    public T poll(ForeachContext<T> ctx) {
        int tid = ctx.getThreadId();
        int idx = this.getIndex(tid);
        if (this.current[idx] == null) {
            this.current[idx] = this.pool.poll();
        }
        T retval = null;
        while (this.current[idx] != null) {
            retval = this.current[idx].poll(ctx);
            if (retval != null) break;
            this.current[idx] = this.pool.poll();
        }
        if (this.current[idx] == null) {
            retval = this.next[idx].poll(ctx);
        }
        if (this.size != null && retval != null) {
            this.size.decrementAndGet();
        }
        return retval;
    }

    @Override
    public boolean isEmpty() {
        if (this.size != null) {
            return this.size.get() == 0;
        }
        return this.pool.isEmpty();
    }

    @Override
    public int size() {
        if (this.size != null) {
            return this.size.get();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void finishAddInitial() {
    }
}

