/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime.wl;

import galois.runtime.ForeachContext;
import galois.runtime.GaloisRuntime;
import galois.runtime.wl.ConcurrentBucketedLeaf;
import galois.runtime.wl.Maker;
import galois.runtime.wl.MatchingConcurrentVersion;
import galois.runtime.wl.MatchingLeafVersion;
import galois.runtime.wl.Worklist;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import util.fn.Lambda;

@MatchingConcurrentVersion(value=ConcurrentBucketed.class)
@MatchingLeafVersion(value=ConcurrentBucketedLeaf.class)
class ConcurrentBucketed<T>
implements Worklist<T> {
    private static final int CACHE_MULTIPLE = 16;
    private final Lambda<T, Integer> indexer;
    private Worklist<T>[] bucket;
    private final boolean ascending;
    private final int[] cursor;
    private AtomicInteger size;

    public ConcurrentBucketed(int numBuckets, Lambda<T, Integer> indexer, Maker<T> maker, boolean needSize) {
        this(numBuckets, true, indexer, maker, needSize);
    }

    public ConcurrentBucketed(int numBuckets, boolean ascending, Lambda<T, Integer> indexer, Maker<T> maker, boolean needSize) {
        this(numBuckets, ascending, indexer, (Worklist<T>[])null, needSize);
        this.bucket = new Worklist[numBuckets];
        int i = 0;
        while (i < numBuckets) {
            this.bucket[i] = maker.make();
            ++i;
        }
    }

    private ConcurrentBucketed(int numBuckets, boolean ascending, Lambda<T, Integer> indexer, Worklist<T>[] bucket, boolean needSize) {
        this.indexer = indexer;
        this.ascending = ascending;
        this.bucket = bucket;
        int numThreads = GaloisRuntime.getRuntime().getMaxThreads();
        this.cursor = new int[numThreads * 16];
        if (!ascending) {
            Arrays.fill(this.cursor, numBuckets - 1);
        }
        if (needSize) {
            this.size = new AtomicInteger();
        }
    }

    @Override
    public Worklist<T> newInstance() {
        int numBuckets = this.bucket.length;
        Worklist[] b = new Worklist[numBuckets];
        int i = 0;
        while (i < numBuckets) {
            b[i] = this.bucket[i].newInstance();
            ++i;
        }
        return new ConcurrentBucketed<T>(numBuckets, this.ascending, this.indexer, b, this.size != null);
    }

    private int getIndex(int tid) {
        return tid * 16;
    }

    @Override
    public void add(T item, ForeachContext<T> ctx) {
        int tid = ctx.getThreadId();
        int index = this.indexer.call(item);
        if (this.size != null) {
            this.size.incrementAndGet();
        }
        this.bucket[index].add(item, ctx);
        if (this.ascending) {
            if (index < this.cursor[this.getIndex(tid)]) {
                this.cursor[this.getIndex((int)tid)] = index;
            }
        } else if (index > this.cursor[this.getIndex(tid)]) {
            this.cursor[this.getIndex((int)tid)] = index;
        }
    }

    @Override
    public void addInitial(T item, ForeachContext<T> ctx) {
        this.add(item, ctx);
    }

    @Override
    public T poll(ForeachContext<T> ctx) {
        int tid = ctx.getThreadId();
        int cur = this.cursor[this.getIndex(tid)];
        T retval = null;
        while (cur < this.bucket.length && cur >= 0) {
            retval = this.bucket[cur].poll(ctx);
            if (retval != null) break;
            if (this.ascending) {
                ++cur;
                continue;
            }
            --cur;
        }
        if (retval != null) {
            if (this.size != null) {
                this.size.decrementAndGet();
            }
            if (this.cursor[this.getIndex(tid)] != cur) {
                this.cursor[this.getIndex((int)tid)] = cur;
            }
        } else {
            this.cursor[this.getIndex((int)tid)] = this.ascending ? 0 : this.bucket.length - 1;
        }
        return retval;
    }

    @Override
    public int size() {
        if (this.size != null) {
            return this.size.get();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        if (this.size != null) {
            return this.size.get() == 0;
        }
        int i = 0;
        while (i < this.bucket.length) {
            if (!this.bucket[i].isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void finishAddInitial() {
    }
}

