/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime.wl;

import galois.runtime.ForeachContext;
import galois.runtime.wl.BoundedLIFO;
import galois.runtime.wl.ConcurrentChunkedRandomOrder;
import galois.runtime.wl.Maker;
import galois.runtime.wl.MatchingConcurrentVersion;
import galois.runtime.wl.MatchingLeafVersion;
import galois.runtime.wl.OnlyLeaf;
import galois.runtime.wl.Worklist;
import java.util.Arrays;
import java.util.Random;

@OnlyLeaf
@MatchingConcurrentVersion(value=ConcurrentChunkedRandomOrder.class)
@MatchingLeafVersion(value=ChunkedRandomOrder.class)
public class ChunkedRandomOrder<T>
implements Worklist<T> {
    public static final int DEFAULT_CHUNK_SIZE = 32;
    public static final int DEFAULT_INITIAL_CAPACITY = 1024;
    private final int chunkSize;
    private final Random rand;
    private final int initialCapacity;
    private int queueSize;
    private T[] queue;
    private Worklist<T> current;
    private int size;

    public ChunkedRandomOrder(Maker<T> maker, boolean needSize) {
        this(32, 1024, maker, needSize);
    }

    public ChunkedRandomOrder(int chunkSize, Maker<T> maker, boolean needSize) {
        this(chunkSize, 1024, maker, needSize);
    }

    public ChunkedRandomOrder(int chunkSize, int initialCapacity, Maker<T> maker, boolean needSize) {
        this(initialCapacity, initialCapacity, new BoundedLIFO(chunkSize, null, false), needSize);
    }

    private ChunkedRandomOrder(int chunkSize, int initialCapacity, Worklist<T> current, boolean needSize) {
        this.chunkSize = chunkSize;
        this.initialCapacity = initialCapacity;
        this.current = current;
        this.rand = new Random();
        this.queue = new Object[initialCapacity];
    }

    @Override
    public Worklist<T> newInstance() {
        return new ChunkedRandomOrder<T>(this.chunkSize, this.initialCapacity, this.current.newInstance(), false);
    }

    @Override
    public void add(T item, ForeachContext<T> ctx) {
        ++this.size;
        this.current.add(item, ctx);
        if (this.current.size() >= this.chunkSize) {
            T t;
            while ((t = this.current.poll(ctx)) != null) {
                this.addInternal(t);
            }
        }
    }

    private void addInternal(T item) {
        if (this.queueSize + 1 >= this.queue.length) {
            this.resize();
        }
        this.queue[this.queueSize++] = item;
    }

    @Override
    public void addInitial(T item, ForeachContext<T> ctx) {
        ++this.size;
        this.addInternal(item);
    }

    @Override
    public T poll(ForeachContext<T> ctx) {
        T retval = this.current.poll(ctx);
        if (retval == null) {
            int i = 0;
            while (i < this.chunkSize + 1) {
                if (this.queueSize == 0) break;
                int bucket = this.rand.nextInt(this.queueSize);
                T item = this.queue[bucket];
                if (retval == null) {
                    retval = item;
                } else {
                    this.current.add(item, ctx);
                }
                this.queue[bucket] = this.queue[this.queueSize - 1];
                this.queue[this.queueSize - 1] = null;
                --this.queueSize;
                ++i;
            }
        }
        if (retval != null) {
            --this.size;
        }
        return retval;
    }

    @Override
    public boolean isEmpty() {
        return this.queueSize == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void finishAddInitial() {
    }

    private void resize() {
        this.queue = Arrays.copyOf(this.queue, this.queue.length * 2);
    }
}

