/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime.wl;

import galois.runtime.ForeachContext;
import galois.runtime.wl.ChunkedLIFOLeaf;
import galois.runtime.wl.ConcurrentChunkedLIFO;
import galois.runtime.wl.Maker;
import galois.runtime.wl.MatchingConcurrentVersion;
import galois.runtime.wl.MatchingLeafVersion;
import galois.runtime.wl.NestedAreSerial;
import galois.runtime.wl.Worklist;

@NestedAreSerial
@MatchingConcurrentVersion(value=ConcurrentChunkedLIFO.class)
@MatchingLeafVersion(value=ChunkedLIFOLeaf.class)
public class ChunkedLIFO<T>
implements Worklist<T> {
    public static final int DEFAULT_CHUNK_SIZE = 32;
    private final int chunkSize;
    private Worklist<T> current;
    private Node<T> head;
    private int size;

    public ChunkedLIFO(Maker<T> maker, boolean needSize) {
        this(32, maker, needSize);
    }

    public ChunkedLIFO(int chunkSize, Maker<T> maker, boolean needSize) {
        this(chunkSize, maker.make(), needSize);
    }

    private ChunkedLIFO(int chunkSize, Worklist<T> current, boolean needSize) {
        this.chunkSize = chunkSize;
        this.current = current;
        this.head = null;
    }

    @Override
    public Worklist<T> newInstance() {
        return new ChunkedLIFO<T>(this.chunkSize, this.current.newInstance(), false);
    }

    @Override
    public void add(T item, ForeachContext<T> ctx) {
        ++this.size;
        this.current.add(item, ctx);
        if (this.current.size() >= this.chunkSize) {
            this.addInternal(this.current);
            this.current = this.current.newInstance();
        }
    }

    @Override
    public void addInitial(T item, ForeachContext<T> ctx) {
        this.add(item, ctx);
    }

    @Override
    public T poll(ForeachContext<T> ctx) {
        if (this.current == null) {
            this.current = this.pollInternal();
        }
        T retval = null;
        while (this.current != null) {
            retval = this.current.poll(ctx);
            if (retval != null) break;
            this.current = this.pollInternal();
        }
        if (retval != null) {
            ++this.size;
        }
        return retval;
    }

    private void addInternal(Worklist<T> wl) {
        Node<T> next = new Node<T>(wl);
        ((Node)next).next = (Node)this.head;
        this.head = next;
    }

    private Worklist<T> pollInternal() {
        Node next;
        Node<T> cur = this.head;
        if (cur == null) {
            return null;
        }
        this.head = next = ((Node)cur).next;
        return ((Node)cur).wl;
    }

    @Override
    public boolean isEmpty() {
        return this.head == null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void finishAddInitial() {
    }

    private static class Node<T> {
        private Node<T> next;
        private Worklist<T> wl;

        public Node(Worklist<T> wl) {
            this.wl = wl;
        }
    }
}

