/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime.wl;

import galois.runtime.ForeachContext;
import galois.runtime.wl.ChunkedFIFOLeaf;
import galois.runtime.wl.ConcurrentChunkedFIFO;
import galois.runtime.wl.Maker;
import galois.runtime.wl.MatchingConcurrentVersion;
import galois.runtime.wl.MatchingLeafVersion;
import galois.runtime.wl.NestedAreSerial;
import galois.runtime.wl.Worklist;
import java.util.ArrayDeque;
import java.util.Deque;

@NestedAreSerial
@MatchingConcurrentVersion(value=ConcurrentChunkedFIFO.class)
@MatchingLeafVersion(value=ChunkedFIFOLeaf.class)
public class ChunkedFIFO<T>
implements Worklist<T> {
    public static final int DEFAULT_CHUNK_SIZE = 32;
    private final int chunkSize;
    private Worklist<T> current;
    private Worklist<T> next;
    private Deque<Worklist<T>> pool;
    private int size;

    public ChunkedFIFO(Maker<T> maker, boolean needSize) {
        this(32, maker, needSize);
    }

    public ChunkedFIFO(int chunkSize, Maker<T> maker, boolean needSize) {
        this(chunkSize, maker.make(), maker.make(), needSize);
    }

    private ChunkedFIFO(int chunkSize, Worklist<T> current, Worklist<T> next, boolean needSize) {
        this.chunkSize = chunkSize;
        this.current = current;
        this.next = next;
        this.pool = new ArrayDeque<Worklist<T>>();
        this.size = 0;
    }

    @Override
    public Worklist<T> newInstance() {
        return new ChunkedFIFO<T>(this.chunkSize, this.current.newInstance(), this.next.newInstance(), false);
    }

    @Override
    public void add(T item, ForeachContext<T> ctx) {
        ++this.size;
        this.next.add(item, ctx);
        if (this.next.size() >= this.chunkSize) {
            this.pool.add(this.next);
            this.next = this.next.newInstance();
        }
    }

    @Override
    public void addInitial(T item, ForeachContext<T> ctx) {
        this.add(item, ctx);
    }

    @Override
    public T poll(ForeachContext<T> ctx) {
        if (this.current == null) {
            this.current = this.pool.poll();
        }
        T retval = null;
        while (this.current != null) {
            retval = this.current.poll(ctx);
            if (retval != null) break;
            this.current = this.pool.poll();
        }
        if (this.current == null) {
            retval = this.next.poll(ctx);
        }
        if (retval != null) {
            --this.size;
        }
        return retval;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void finishAddInitial() {
    }
}

