/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime.wl;

import galois.runtime.ForeachContext;
import galois.runtime.wl.BucketedLeaf;
import galois.runtime.wl.ConcurrentBucketed;
import galois.runtime.wl.Maker;
import galois.runtime.wl.MatchingConcurrentVersion;
import galois.runtime.wl.MatchingLeafVersion;
import galois.runtime.wl.Worklist;
import util.fn.Lambda;

@MatchingConcurrentVersion(value=ConcurrentBucketed.class)
@MatchingLeafVersion(value=BucketedLeaf.class)
public class Bucketed<T>
implements Worklist<T> {
    private final Lambda<T, Integer> indexer;
    private Worklist<T>[] bucket;
    private int size;
    private int cursor;
    private final boolean ascending;

    public Bucketed(int numBuckets, Lambda<T, Integer> indexer, Maker<T> maker, boolean needSize) {
        this(numBuckets, true, indexer, maker, needSize);
    }

    public Bucketed(int numBuckets, boolean ascending, Lambda<T, Integer> indexer, Maker<T> maker, boolean needSize) {
        this(numBuckets, ascending, indexer, (Worklist<T>[])null, needSize);
        this.bucket = new Worklist[numBuckets];
        int i = 0;
        while (i < numBuckets) {
            this.bucket[i] = maker.make();
            ++i;
        }
    }

    private Bucketed(int numBuckets, boolean ascending, Lambda<T, Integer> indexer, Worklist<T>[] bucket, boolean needSize) {
        this.indexer = indexer;
        this.ascending = ascending;
        this.bucket = bucket;
        this.size = 0;
        this.cursor = ascending ? 0 : numBuckets - 1;
    }

    @Override
    public Worklist<T> newInstance() {
        int numBuckets = this.bucket.length;
        Worklist[] b = new Worklist[numBuckets];
        int i = 0;
        while (i < numBuckets) {
            b[i] = this.bucket[i].newInstance();
            ++i;
        }
        return new Bucketed<T>(numBuckets, this.ascending, this.indexer, b, false);
    }

    @Override
    public void add(T item, ForeachContext<T> ctx) {
        int index = this.indexer.call(item);
        ++this.size;
        this.bucket[index].add(item, ctx);
        if (this.ascending) {
            if (this.cursor >= index) {
                this.cursor = index;
            }
        } else if (this.cursor <= index) {
            this.cursor = index;
        }
    }

    @Override
    public void addInitial(T item, ForeachContext<T> ctx) {
        this.add(item, ctx);
    }

    @Override
    public T poll(ForeachContext<T> ctx) {
        int cur;
        T retval = null;
        while ((cur = this.cursor++) < this.bucket.length && cur >= 0) {
            retval = this.bucket[cur].poll(ctx);
            if (retval != null) break;
            if (this.ascending) continue;
            --this.cursor;
        }
        if (retval != null) {
            --this.size;
        }
        return retval;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void finishAddInitial() {
    }
}

