/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime.wl;

import galois.runtime.ForeachContext;
import galois.runtime.wl.ConcurrentBoundedLIFO;
import galois.runtime.wl.Maker;
import galois.runtime.wl.MatchingConcurrentVersion;
import galois.runtime.wl.MatchingLeafVersion;
import galois.runtime.wl.OnlyLeaf;
import galois.runtime.wl.Worklist;

@OnlyLeaf
@MatchingConcurrentVersion(value=ConcurrentBoundedLIFO.class)
@MatchingLeafVersion(value=BoundedLIFO.class)
public class BoundedLIFO<T>
implements Worklist<T> {
    public static final int DEFAULT_MAX_ELEMENTS = 32;
    private final Object[] buffer;
    private int top;

    public BoundedLIFO(Maker<T> maker, boolean needSize) {
        this(32, maker, needSize);
    }

    public BoundedLIFO(int maxElements, Maker<T> maker, boolean needSize) {
        this.buffer = new Object[maxElements];
        this.top = 0;
    }

    @Override
    public Worklist<T> newInstance() {
        return new BoundedLIFO<T>(this.buffer.length, null, false);
    }

    @Override
    public void add(T item, ForeachContext<T> ctx) {
        this.buffer[this.top++] = item;
    }

    @Override
    public void addInitial(T item, ForeachContext<T> ctx) {
        this.add(item, ctx);
    }

    @Override
    public T poll(ForeachContext<T> ctx) {
        if (this.top > 0) {
            return (T)this.buffer[--this.top];
        }
        return null;
    }

    @Override
    public int size() {
        return this.top;
    }

    @Override
    public boolean isEmpty() {
        return this.top == 0;
    }

    @Override
    public void finishAddInitial() {
    }
}

