/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime;

import galois.objects.Mappable;
import galois.runtime.Callback;
import galois.runtime.Executor;
import galois.runtime.Features;
import galois.runtime.Iteration;
import galois.runtime.IterationAbortException;
import galois.runtime.IterationStatistics;
import galois.runtime.MapInternalContext;
import galois.runtime.MappableType;
import galois.runtime.ReleaseCallback;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.ExecutionException;

class SerialMappableExecutor<T>
implements Executor,
MapInternalContext {
    private final Mappable<T> mappable;
    private final Deque<Callback> suspendThunks;
    private int numCommitted;

    public SerialMappableExecutor(Mappable<T> mappable) {
        this.mappable = mappable;
        this.suspendThunks = new ArrayDeque<Callback>();
    }

    public IterationStatistics call(Object body, MappableType type, Object ... args) throws ExecutionException {
        this.numCommitted = 0;
        type.call(this.mappable, body, this, args);
        this.mappable.mapInternalDone();
        IterationStatistics stats = new IterationStatistics();
        stats.putStats(Thread.currentThread(), this.numCommitted, 0);
        return stats;
    }

    @Override
    public void abort() {
    }

    @Override
    public void begin() {
    }

    @Override
    public void commit(Object obj) {
        Features.getReplayFeature().onCommit(null, this.getIterationId(), obj);
        ++this.numCommitted;
        if (!this.suspendThunks.isEmpty()) {
            for (Callback c : this.suspendThunks) {
                c.call();
            }
        }
    }

    public int getIterationId() {
        return 0;
    }

    @Override
    public int getThreadId() {
        return 0;
    }

    @Override
    public void arbitrate(Iteration current, Iteration conflicter) throws IterationAbortException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onCommit(Iteration it, Callback action) {
        this.suspendThunks.addFirst(action);
    }

    @Override
    public void onRelease(Iteration it, ReleaseCallback action) {
    }

    @Override
    public void onUndo(Iteration it, Callback action) {
    }

    @Override
    public boolean isSerial() {
        return true;
    }

    @Override
    public void suspend(Callback listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void suspendDone() {
        throw new UnsupportedOperationException();
    }
}

