/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime;

import galois.runtime.Callback;
import galois.runtime.ForeachContext;
import galois.runtime.GaloisRuntime;
import galois.runtime.Iteration;
import galois.runtime.NoReplayFeature;
import galois.runtime.PlaybackReplayFeature;
import galois.runtime.RecordReplayFeature;
import galois.runtime.Replayable;
import java.io.Serializable;
import util.Launcher;
import util.fn.LambdaVoid;

public abstract class ReplayFeature {
    private static final int CACHE_MULTIPLE = 16;
    private final int[] first;
    private final int[] counters;
    private final int maxtIterations;
    private final Callback[] undoActions;
    private final Callback[] commitActions;
    private boolean invalid;

    public void invalidate() {
        this.invalid = true;
    }

    protected final void checkValidity() {
        assert (!this.invalid);
    }

    protected ReplayFeature(int maxtIterations) {
        this.maxtIterations = maxtIterations;
        this.counters = new int[maxtIterations * 16];
        this.first = new int[maxtIterations * 16];
        this.undoActions = new Callback[maxtIterations];
        this.commitActions = new Callback[maxtIterations];
        int iterationId = 0;
        while (iterationId < maxtIterations) {
            final int index = this.getCounterIndex(iterationId);
            this.undoActions[iterationId] = new Callback(){

                @Override
                public void call() {
                    ((ReplayFeature)ReplayFeature.this).counters[index] = ReplayFeature.this.first[index];
                    ((ReplayFeature)ReplayFeature.this).first[index] = 0;
                }
            };
            this.commitActions[iterationId] = new Callback(){

                @Override
                public void call() {
                    ((ReplayFeature)ReplayFeature.this).first[index] = 0;
                }
            };
            ++iterationId;
        }
    }

    protected final String getLogName(int curLog) {
        return String.format("replaylog%d", curLog);
    }

    protected final long getRid(Object obj) {
        Replayable r = (Replayable)obj;
        long rid = r.getRid();
        assert (rid != 0L);
        return rid;
    }

    private int getCounterIndex(int iterationId) {
        return iterationId * 16;
    }

    protected final long makeRid(int iterationId) {
        int index;
        int n = index = this.getCounterIndex(iterationId);
        int n2 = this.counters[n];
        this.counters[n] = n2 + 1;
        int counter = n2;
        return Rids.makeRid(this.maxtIterations, iterationId, counter);
    }

    protected final void setNextRid(Iteration it, int iterationId, Replayable obj) {
        int index;
        if (it != null && this.first[index = this.getCounterIndex(iterationId)] == 0) {
            this.first[index] = this.counters[index];
            it.addUndoAction(this.undoActions[iterationId]);
            it.addCommitAction(this.commitActions[iterationId]);
        }
        long rid = this.makeRid(iterationId);
        obj.setRid(rid);
    }

    protected final void setNextRid(Replayable obj) {
        long rid = Rids.makeSerialRid();
        obj.setRid(rid);
    }

    public abstract void onCommit(Iteration var1, int var2, Object var3);

    public abstract void onCallbackExecute(long var1);

    public abstract <T> void registerCallback(long var1, LambdaVoid<ForeachContext<T>> var3);

    public abstract void registerCallback(long var1, Callback var3);

    public abstract boolean isCallbackControlled();

    public void onCreateReplayable(Replayable obj) {
        if (GaloisRuntime.getRuntime().inRoot()) {
            this.setNextRid(obj);
        } else {
            Iteration it = Iteration.getCurrentIteration();
            if (it != null) {
                this.setNextRid(it, it.getId(), obj);
            } else {
                this.setNextRid(null, 0, obj);
            }
        }
    }

    public abstract void onFinish();

    static enum CallbackType {
        CALLBACK,
        LAMBDA_CONTEXT;

    }

    static final class Log
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Action[] actions;
        private long[] rids;
        private int[] iterationIds;
        private int size;
        private final int capacity;

        public Log(int capacity) {
            this.capacity = capacity;
            this.actions = new Action[capacity];
            this.rids = new long[capacity];
            this.iterationIds = new int[capacity];
            this.size = capacity;
        }

        public void putEntry(int index, Action action, long rid, int iterationId) {
            this.actions[index] = action;
            this.rids[index] = rid;
            this.iterationIds[index] = iterationId;
        }

        public Action getAction(int index) {
            return this.actions[index];
        }

        public long getRid(int index) {
            return this.rids[index];
        }

        public int getIterationId(int index) {
            return this.iterationIds[index];
        }

        public void setSize(int size) {
            this.size = size;
        }

        public int size() {
            return this.size;
        }

        public int getCapacity() {
            return this.capacity;
        }

        protected static enum Action {
            POLL,
            CALLBACK;

        }
    }

    private static final class Rids {
        private static boolean initialized;
        private static long counter;

        static {
            counter = 1L;
        }

        private Rids() {
        }

        private static long makeRid(int maxtIterations, int iterationId, int counter) {
            int logNT = 32 - Integer.numberOfLeadingZeros(maxtIterations - 1);
            return counter << logNT + 1 | iterationId << 1 | 1;
        }

        private static long makeSerialRid() {
            if (!initialized) {
                Launcher.getLauncher().onRestart(new Runnable(){

                    @Override
                    public void run() {
                        counter = 1L;
                        initialized = false;
                    }
                });
                initialized = true;
            }
            return counter++ << 1;
        }
    }

    static enum Type {
        RECORD,
        PLAYBACK,
        NO;


        public ReplayFeature create(int numThreads) {
            switch (this) {
                case RECORD: {
                    return new RecordReplayFeature(numThreads);
                }
                case PLAYBACK: {
                    return new PlaybackReplayFeature(numThreads);
                }
                case NO: {
                    return new NoReplayFeature(numThreads);
                }
            }
            throw new Error("Unknown option: " + (Object)((Object)this));
        }
    }
}

