/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime;

import galois.runtime.Callback;
import galois.runtime.ForeachContext;
import galois.runtime.Iteration;
import galois.runtime.ReplayFeature;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.GZIPOutputStream;
import util.fn.LambdaVoid;

class RecordReplayFeature
extends ReplayFeature {
    private static final int LOG_SIZE = 0x100000;
    private final AtomicInteger cur;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition cond = this.lock.newCondition();
    private ReplayFeature.Log log;
    private int curLog;

    public RecordReplayFeature(int maxIterations) {
        super(maxIterations);
        this.cur = new AtomicInteger();
        this.log = new ReplayFeature.Log(0x100000);
    }

    private int getIndex() {
        boolean makeLog;
        int retval;
        do {
            makeLog = false;
            retval = this.cur.get();
            if (retval == 0x100000) {
                makeLog = true;
                continue;
            }
            if (retval <= 0x100000) continue;
            this.waitForRotate();
        } while (!this.cur.compareAndSet(retval, retval + 1));
        if (makeLog) {
            this.rotate();
            return 0;
        }
        return retval;
    }

    private void rotate() {
        this.lock.lock();
        try {
            this.rotateLog();
            this.cur.set(1);
            this.cond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void waitForRotate() {
        this.lock.lock();
        try {
            try {
                while (this.cur.get() > 0x100000) {
                    this.cond.await();
                }
            }
            catch (InterruptedException e) {
                throw new Error(e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void rotateLog() {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new GZIPOutputStream(new FileOutputStream(this.getLogName(this.curLog))));
            out.writeObject(this.log);
            out.close();
            this.log = new ReplayFeature.Log(0x100000);
            ++this.curLog;
            this.cur.set(0);
        }
        catch (FileNotFoundException e) {
            throw new Error(e);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    @Override
    public void onCommit(Iteration it, int iterationId, Object item) {
        this.checkValidity();
        int index = this.getIndex();
        this.log.putEntry(index, ReplayFeature.Log.Action.POLL, this.getRid(item), iterationId);
    }

    @Override
    public void onCallbackExecute(long rid) {
        int index = this.getIndex();
        this.log.putEntry(index, ReplayFeature.Log.Action.CALLBACK, rid, -1);
    }

    @Override
    public boolean isCallbackControlled() {
        this.checkValidity();
        return false;
    }

    @Override
    public <T> void registerCallback(long rid, LambdaVoid<ForeachContext<T>> callback) {
        this.checkValidity();
    }

    @Override
    public void registerCallback(long rid, Callback callback) {
        this.checkValidity();
    }

    @Override
    public void onFinish() {
        this.checkValidity();
        boolean exactlyFull = this.cur.get() == 0x100000;
        this.log.setSize(this.cur.get());
        this.rotateLog();
        if (exactlyFull) {
            this.log.setSize(0);
            this.rotateLog();
        }
    }
}

