/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime;

import galois.runtime.AbstractParameterExecutor;
import galois.runtime.Iteration;
import galois.runtime.IterationAbortException;
import galois.runtime.OrderedIteration;
import galois.runtime.WorkNotUsefulException;
import galois.runtime.wl.ParameterOrderedWorklist;
import galois.runtime.wl.ParameterWorklist;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ExecutionException;
import util.MutableReference;

class ParameterOrderedExecutor<T>
extends AbstractParameterExecutor<T, MutableReference<T>> {
    private static final boolean HELPGC = true;
    private static final int FLUSH_STATS_INTERVAL = 100;
    private final Map<OrderedIteration<MutableReference<T>>, Integer> executionHistory;
    private final List<OrderedStepRecord<T>> allStepRec;
    private OrderedStepRecord<T> currStepRec;
    private int numExecuted;
    private final Comparator<T> itemCmp;
    private final ParameterOrderedWorklist<T> worklist;
    protected final PriorityQueue<OrderedIteration<MutableReference<T>>> rob;
    private int nextToLog = 0;

    public ParameterOrderedExecutor(ParameterOrderedWorklist<T> worklist) {
        this.worklist = worklist;
        this.itemCmp = worklist.comparator();
        this.rob = new PriorityQueue<T>(64, new RobComparator<T>(this.itemCmp));
        this.executionHistory = new HashMap<OrderedIteration<MutableReference<T>>, Integer>();
        this.allStepRec = new ArrayList<OrderedStepRecord<T>>();
        this.currStepRec = new OrderedStepRecord();
        this.nextToLog = 0;
    }

    @Override
    protected Iteration newIteration() {
        return new OrderedIteration(this.getIterationId());
    }

    @Override
    public final void add(T t) {
        this.add(t, (byte)-1);
    }

    @Override
    public void add(T t, byte flags) {
        this.worklist.add(t);
    }

    private static <U> U getIterationObject(OrderedIteration<MutableReference<U>> it) {
        assert (it.getIterationObject() != null);
        return it.getIterationObject().get();
    }

    @Override
    protected int commitAll() {
        int numCommits = 0;
        while (!this.rob.isEmpty()) {
            OrderedIteration<MutableReference<T>> robHead = this.rob.peek();
            Object robHeadObj = ParameterOrderedExecutor.getIterationObject(robHead);
            if (robHead.hasStatus(OrderedIteration.Status.ABORT_DONE)) {
                this.rob.poll();
                continue;
            }
            if (!this.worklist.canCommit(robHeadObj)) break;
            assert (robHead.hasStatus(OrderedIteration.Status.READY_TO_COMMIT));
            this.rob.poll();
            Iteration.setCurrentIteration(robHead);
            robHead.setStatus(OrderedIteration.Status.COMMITTING);
            int ns = robHead.performCommit(true);
            AbstractParameterExecutor.StepRecord<OrderedIteration<MutableReference<T>>> rec = this.getStepRecord(robHead);
            rec.logNeighSize(ns);
            ++numCommits;
        }
        return numCommits;
    }

    private AbstractParameterExecutor.StepRecord<OrderedIteration<MutableReference<T>>> getStepRecord(OrderedIteration<MutableReference<T>> it) {
        int executedStep = this.executionHistory.get(it);
        assert (this.allStepRec.get(executedStep) != null);
        return this.allStepRec.get(executedStep);
    }

    private void abortIteration(MutableReference<T> boxedCur, OrderedIteration<MutableReference<T>> it, boolean removeRecords) {
        assert (it.getIterationObject() == boxedCur);
        this.worklist.defer(boxedCur);
        it.setStatus(OrderedIteration.Status.ABORTING);
        it.performAbort();
        if (removeRecords) {
            AbstractParameterExecutor.StepRecord<OrderedIteration<MutableReference<T>>> rec = this.getStepRecord(it);
            rec.unlog(it);
            this.executionHistory.remove(it);
        }
    }

    private void markExecuted(OrderedIteration<MutableReference<T>> it) {
        assert (Iteration.getCurrentIteration() == it);
        it.setStatus(OrderedIteration.Status.READY_TO_COMMIT);
        this.rob.add(it);
    }

    @Override
    public void arbitrate(Iteration current, Iteration conflicter) throws IterationAbortException {
        this.arbitrateInternal((OrderedIteration)current, (OrderedIteration)conflicter);
    }

    private void arbitrateInternal(OrderedIteration<MutableReference<T>> current, OrderedIteration<MutableReference<T>> conflicter) {
        Object confObj;
        Object currObj = ParameterOrderedExecutor.getIterationObject(current);
        int res = this.itemCmp.compare(currObj, confObj = ParameterOrderedExecutor.getIterationObject(conflicter));
        if (res >= 0) {
            IterationAbortException.throwException();
        } else {
            MutableReference boxedConf = conflicter.getIterationObject();
            this.abortIteration(boxedConf, conflicter, true);
        }
    }

    @Override
    protected void initTimeStep() {
        this.numExecuted = 0;
        this.currStepRec.logWlSize(this.worklist.size());
    }

    @Override
    protected void finishTimeStep() {
        assert (this.allStepRec.size() == this.getTimeStep());
        this.allStepRec.add(this.currStepRec);
        this.currStepRec = new OrderedStepRecord();
    }

    @Override
    protected void finishLoop() {
        System.out.println("finishing loop, nextToLog = " + this.nextToLog);
        int i = this.nextToLog;
        while (i < this.allStepRec.size()) {
            this.dumpStep(this.allStepRec.get(i));
            ++i;
        }
    }

    private void dumpStep(AbstractParameterExecutor.StepRecord<OrderedIteration<MutableReference<T>>> stepRec) {
        this.dumpStepStats(stepRec);
        for (OrderedIteration it : stepRec.executed.keySet()) {
            this.executionHistory.remove(it);
        }
        stepRec.clear();
    }

    @Override
    protected void logStats() {
        if (this.getTimeStep() % 100 == 0) {
            boolean flushStep = true;
            while (flushStep && this.nextToLog <= this.getTimeStep()) {
                AbstractParameterExecutor.StepRecord nextToLogRec = this.allStepRec.get(this.nextToLog);
                for (OrderedIteration it : nextToLogRec.executed.keySet()) {
                    if (it.hasStatus(OrderedIteration.Status.COMMIT_DONE) || it.hasStatus(OrderedIteration.Status.ABORT_DONE)) continue;
                    flushStep = false;
                    break;
                }
                if (!flushStep) continue;
                this.dumpStep(nextToLogRec);
                ++this.nextToLog;
            }
        }
    }

    @Override
    protected ParameterWorklist<T, MutableReference<T>> getWorklist() {
        return this.worklist;
    }

    @Override
    protected void run(MutableReference<T> boxedCur, Iteration iter) throws ExecutionException {
        OrderedIteration it = (OrderedIteration)iter;
        assert (Iteration.getCurrentIteration() == it);
        it.setIterationObject(boxedCur);
        it.setStatus(OrderedIteration.Status.SCHEDULED);
        T cur = boxedCur.get();
        boolean notUsefull = false;
        try {
            try {
                this.runBody(cur, it);
            }
            catch (WorkNotUsefulException e) {
                notUsefull = true;
            }
            logger.fine(String.format("Successfully executed %s(%s)", it, cur));
            this.markExecuted(it);
            ++this.numExecuted;
            if (parameterCommittedLimit > 0 && this.numExecuted >= parameterCommittedLimit) {
                this.worklist.deferRemainingItems();
            }
            this.executionHistory.put(it, this.getTimeStep());
            this.currStepRec.logExecuted(it, notUsefull);
        }
        catch (IterationAbortException iae) {
            logger.fine(String.format("%s(%s) aborted", it, cur));
            this.abortIteration(boxedCur, it, false);
        }
    }

    @Override
    protected boolean usingEagerOutput() {
        return false;
    }

    private static class OrderedStepRecord<T>
    extends AbstractParameterExecutor.StepRecord<OrderedIteration<MutableReference<T>>> {
        private OrderedStepRecord() {
        }
    }

    private static class RobComparator<U>
    implements Comparator<OrderedIteration<MutableReference<U>>> {
        private final Comparator<U> objCmp;

        public RobComparator(Comparator<U> objCmp) {
            this.objCmp = objCmp;
        }

        @Override
        public int compare(OrderedIteration<MutableReference<U>> it1, OrderedIteration<MutableReference<U>> it2) {
            Object obj1 = ParameterOrderedExecutor.getIterationObject(it1);
            Object obj2 = ParameterOrderedExecutor.getIterationObject(it2);
            int res = this.objCmp.compare(obj1, obj2);
            return res;
        }
    }
}

