/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime;

import galois.runtime.Iteration;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class OrderedIteration<T>
extends Iteration {
    private boolean retired = false;
    private Lock retiredLock;
    private Condition retiredCond;
    private AtomicReference<Status> status = new AtomicReference<Status>(Status.UNSCHEDULED);
    private T iterationObject;

    public OrderedIteration(int id) {
        super(id);
        this.retiredLock = new ReentrantLock();
        this.retiredCond = this.retiredLock.newCondition();
    }

    public final Condition getRetiredCond() {
        return this.retiredCond;
    }

    public final Lock getRetiredLock() {
        return this.retiredLock;
    }

    public final boolean hasRetired() {
        return this.retired;
    }

    public void setIterationObject(T obj) {
        this.iterationObject = obj;
    }

    public T getIterationObject() {
        return this.iterationObject;
    }

    @Override
    public int performAbort() {
        if (this.getStatus() == Status.ABORT_DONE || this.getStatus() == Status.COMMIT_DONE) {
            return 0;
        }
        if (this.getStatus() != Status.ABORTING) {
            throw new RuntimeException("wrong status in performAbort " + (Object)((Object)this.getStatus()));
        }
        int r = super.performAbort();
        this.setStatus(Status.ABORT_DONE);
        this.wakeupConflicters();
        return r;
    }

    void wakeupConflicters() {
        this.retiredLock.lock();
        try {
            this.retired = true;
            this.retiredCond.signalAll();
        }
        finally {
            this.retiredLock.unlock();
        }
    }

    @Override
    public int performCommit(boolean releaseLocks) {
        if (this.getStatus() == Status.ABORT_DONE || this.getStatus() == Status.COMMIT_DONE) {
            return 0;
        }
        if (this.getStatus() != Status.COMMITTING) {
            throw new RuntimeException("wrong status in performCommit " + this);
        }
        int r = super.performCommit(releaseLocks);
        this.setStatus(Status.COMMIT_DONE);
        this.wakeupConflicters();
        return r;
    }

    @Override
    protected void reset() {
        super.clearLogs(true);
        this.setStatus(Status.UNSCHEDULED);
    }

    @Override
    Iteration recycle() {
        this.reset();
        return this;
    }

    Status getStatus() {
        return this.status.get();
    }

    public boolean hasStatus(Status expected) {
        return this.getStatus() == expected;
    }

    public void setStatus(Status status) {
        this.status.set(status);
    }

    public boolean casStatus(Status expect, Status update) {
        return this.status.compareAndSet(expect, update);
    }

    public String toString() {
        if (this.iterationObject != null) {
            return String.format("(it=%d,%s,%s)", new Object[]{this.getId(), this.status.get(), this.iterationObject});
        }
        return String.format("(it=%d,null,%s)", new Object[]{this.getId(), this.status.get()});
    }

    public static enum Status {
        UNSCHEDULED,
        SCHEDULED,
        READY_TO_COMMIT,
        COMMITTING,
        COMMIT_DONE,
        ABORT_SELF,
        ABORTING,
        ABORT_DONE;

    }
}

