/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime;

import galois.runtime.AbstractGaloisExecutor;
import galois.runtime.Callback;
import galois.runtime.Features;
import galois.runtime.ForeachContext;
import galois.runtime.Iteration;
import galois.runtime.IterationAbortException;
import galois.runtime.OrderedIteration;
import galois.runtime.wl.OrderableWorklist;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

class OrderedExecutor<T>
extends AbstractGaloisExecutor<T> {
    private static final boolean fineLogLevel = logger.isLoggable(Level.FINE);
    private static final int GET_FREE_ITER_ATTEMPTS = 10;
    private final Comparator<T> comp;
    private final OrderableWorklist<T> worklist;
    private final PriorityQueue<OrderedIteration<T>> rob;
    private final ROBComparator<T> robComp;
    private final ReentrantLock robLock;
    private ArrayBlockingQueue<OrderedIteration<T>> freeList;

    public OrderedExecutor(OrderableWorklist<T> worklist) {
        this.worklist = worklist;
        this.comp = worklist.getComparator();
        this.robComp = new ROBComparator<T>(this.comp);
        this.rob = new PriorityQueue<T>(64, this.robComp);
        this.robLock = new ReentrantLock();
        this.freeList = new ArrayBlockingQueue(this.getMaxIterations());
        int i = 0;
        while (i < this.getMaxIterations()) {
            this.freeList.add(new OrderedIteration(i));
            ++i;
        }
    }

    private static void log(String msg, Object ... args) {
        if (fineLogLevel) {
            logger.fine(String.format("Thread %d: %s", Thread.currentThread().getId(), String.format(msg, args)));
        }
    }

    static void dbout(String msg, Object ... args) {
        System.err.printf("[Thread %2d] %s\n", Thread.currentThread().getId(), String.format(msg, args));
    }

    private static <U> void orderIterationToAbortAndSleepWaiting(OrderedIteration<U> current, OrderedIteration<U> conflicter) {
        Lock lock = conflicter.getRetiredLock();
        lock.lock();
        try {
            try {
                Condition conflicterRetiredCond = conflicter.getRetiredCond();
                while (!conflicter.hasRetired()) {
                    OrderedExecutor.log("%s is going to SLEEP waiting for %s", current, conflicter);
                    conflicterRetiredCond.await();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new RuntimeException("Thread has been interrupted!!!");
            }
        }
        catch (Throwable throwable) {
            OrderedExecutor.log("%s WOKE UP from sleep waiting for %s", current, conflicter);
            lock.unlock();
            throw throwable;
        }
        OrderedExecutor.log("%s WOKE UP from sleep waiting for %s", current, conflicter);
        lock.unlock();
    }

    @Override
    protected void abortIteration(Iteration theirIt) throws IterationAbortException {
        OrderedIteration it = (OrderedIteration)theirIt;
        it.setStatus(OrderedIteration.Status.ABORTING);
        OrderedExecutor.log("aborting %s with object %s", it, it.getIterationObject());
        it.performAbort();
        this.clearROB(it);
    }

    @Override
    public void arbitrate(Iteration current, Iteration conflicter) {
        OrderedExecutor.log("arbitrate between current %s & conflicter %s", current, conflicter);
        this.arbitrateInternal((OrderedIteration)current, (OrderedIteration)conflicter);
        OrderedExecutor.log("returning from arbitrate current %s & conflicter %s", current, conflicter);
    }

    private void arbitrateInternal(OrderedIteration<T> current, OrderedIteration<T> conflicter) throws IterationAbortException {
        assert (current.hasStatus(OrderedIteration.Status.SCHEDULED) || current.hasStatus(OrderedIteration.Status.ABORT_SELF));
        if (current.hasStatus(OrderedIteration.Status.ABORT_SELF)) {
            IterationAbortException.throwException();
        }
        if (conflicter == null) {
            return;
        }
        OrderedExecutor.log("Thread: %d arbitrating between %s (%s) and %s (%s)", Thread.currentThread().getId(), current, current.getIterationObject(), conflicter, conflicter.getIterationObject());
        if (conflicter.hasStatus(OrderedIteration.Status.COMMIT_DONE) || conflicter.hasStatus(OrderedIteration.Status.ABORT_DONE) || conflicter.hasStatus(OrderedIteration.Status.UNSCHEDULED)) {
            OrderedExecutor.log("%s has a trivially resolved conflict with %s ", current, conflicter);
            return;
        }
        int result = this.compareIterationPriorities(current, conflicter);
        if (result >= 0) {
            OrderedExecutor.log("%s is @@@@@@@aborted@@@@@@ by %s", current, conflicter);
            IterationAbortException.throwException();
        }
        OrderedExecutor.log("%s is going to ######abort##### %s", current, conflicter);
        if (conflicter.casStatus(OrderedIteration.Status.SCHEDULED, OrderedIteration.Status.ABORT_SELF)) {
            OrderedExecutor.log("Telling SCHEDULED iteration %s to abort itself A_SELF", conflicter);
            OrderedExecutor.orderIterationToAbortAndSleepWaiting(current, conflicter);
        } else if (conflicter.casStatus(OrderedIteration.Status.READY_TO_COMMIT, OrderedIteration.Status.ABORTING)) {
            OrderedExecutor.log("Telling RTC iteration %s to abort itself ABORTING", conflicter);
            this.abortAndAdd(conflicter);
        } else {
            if (conflicter.hasStatus(OrderedIteration.Status.ABORT_DONE) || conflicter.hasStatus(OrderedIteration.Status.COMMIT_DONE) || conflicter.hasStatus(OrderedIteration.Status.UNSCHEDULED)) {
                return;
            }
            OrderedExecutor.log("%s trying to abort ABORT_SELF/ABORTING iteration %s", current, conflicter);
            OrderedExecutor.orderIterationToAbortAndSleepWaiting(current, conflicter);
        }
    }

    private void abortAndAdd(OrderedIteration<T> it) {
        this.worklist.add(it.getIterationObject(), null);
        this.abortIteration(it);
    }

    private int clearROB(OrderedIteration<T> debugIt) {
        int retval = 0;
        this.robLock.lock();
        try {
            int niter = 0;
            while (!this.rob.isEmpty()) {
                OrderedIteration<T> robHead = this.rob.peek();
                OrderedExecutor.log("%d cleaning: looking at: %s ", niter, robHead);
                ++niter;
                if (robHead.hasStatus(OrderedIteration.Status.COMMIT_DONE) || robHead.hasStatus(OrderedIteration.Status.UNSCHEDULED)) {
                    throw new RuntimeException("Iteration " + robHead + " has bad status in ROB ");
                }
                if (!robHead.hasStatus(OrderedIteration.Status.READY_TO_COMMIT) && !robHead.hasStatus(OrderedIteration.Status.ABORT_DONE)) break;
                if (!this.isOfHighestPriority(robHead)) {
                    OrderedExecutor.log("clearRob: iteration %s does not have highest priority", robHead);
                    break;
                }
                OrderedExecutor.log("clearRob: iteration %s has highest priority", robHead);
                if (robHead.casStatus(OrderedIteration.Status.READY_TO_COMMIT, OrderedIteration.Status.COMMITTING)) {
                    retval += robHead.performCommit(true);
                    this.rob.poll();
                    OrderedExecutor.log("done with committing %s", robHead);
                    this.addToFreeList(robHead);
                    continue;
                }
                if (!robHead.hasStatus(OrderedIteration.Status.ABORT_DONE)) break;
                this.rob.poll();
                OrderedExecutor.log("removing A_DONE %s from ROB", robHead);
                this.addToFreeList(robHead);
            }
            int n = retval;
            return n;
        }
        finally {
            this.robLock.unlock();
        }
    }

    private void addToFreeList(OrderedIteration<T> it) {
        it.recycle();
        this.freeList.add(it);
    }

    @Override
    public final void commitIteration(Iteration theirIt, final int iterationId, final T item, boolean releaseLocks) {
        final OrderedIteration it = (OrderedIteration)theirIt;
        if (it.hasStatus(OrderedIteration.Status.SCHEDULED)) {
            assert (Iteration.getCurrentIteration() == it) : String.format("Iteration different from currentIteration\n", new Object[0]);
            assert (item == it.getIterationObject()) : String.format("iteration object mismatch item = %s, it = %s\n", item, it);
            it.addCommitAction(new Callback(){

                @Override
                public void call() {
                    Features.getReplayFeature().onCommit(it, iterationId, item);
                }
            });
        }
        if (!(it.hasStatus(OrderedIteration.Status.SCHEDULED) || it.hasStatus(OrderedIteration.Status.ABORT_SELF) || it.hasStatus(OrderedIteration.Status.UNSCHEDULED))) {
            throw new RuntimeException("Iteration " + it + " with Unexpected Status during commit");
        }
        if (it.casStatus(OrderedIteration.Status.SCHEDULED, OrderedIteration.Status.READY_TO_COMMIT)) {
            OrderedExecutor.log("Setting status of %s from SCHEDULED to RTC", it);
            this.clearROB(it);
        } else if (it.hasStatus(OrderedIteration.Status.ABORT_SELF)) {
            OrderedExecutor.log("Setting status of %s from A_SELF to ABORTING", it);
            IterationAbortException.throwException();
        } else if (it.hasStatus(OrderedIteration.Status.UNSCHEDULED)) {
            this.addToFreeList(it);
            this.clearROB(it);
        } else {
            IterationAbortException.throwException();
        }
    }

    private int compareIterationPriorities(OrderedIteration<T> current, OrderedIteration<T> conflicter) {
        return this.robComp.compare(current, conflicter);
    }

    @Override
    protected T poll(ForeachContext<T> ctx) {
        OrderedIteration it = (OrderedIteration)Iteration.getCurrentIteration();
        T obj = null;
        this.robLock.lock();
        try {
            obj = this.worklist.poll(ctx);
            if (obj == null) {
                return null;
            }
            assert (it.hasStatus(OrderedIteration.Status.UNSCHEDULED)) : String.format("Unwanted status of iter in poll() %s\n", it);
            it.setStatus(OrderedIteration.Status.SCHEDULED);
            it.setIterationObject(obj);
            this.rob.add(it);
            OrderedExecutor.log("scheduling %s with object %s", it, obj);
        }
        finally {
            this.robLock.unlock();
        }
        return obj;
    }

    private boolean isOfHighestPriority(OrderedIteration<T> it) {
        T currentTopObj = this.worklist.peek();
        if (currentTopObj == null) {
            return true;
        }
        T itObj = it.getIterationObject();
        boolean res = this.comp.compare(itObj, currentTopObj) <= 0;
        OrderedExecutor.log("Result of comparing %s with %s is %s", itObj, currentTopObj, res);
        return res;
    }

    @Override
    protected Iteration newIteration(Iteration prev, int tid) {
        OrderedIteration<T> retIt = this.freeList.poll();
        int attempts = 0;
        while (retIt == null) {
            this.clearROB(retIt);
            if (attempts >= 10) {
                retIt = this.removeAbortDone();
                if (retIt != null) {
                    assert (retIt.hasStatus(OrderedIteration.Status.ABORT_DONE));
                    retIt.recycle();
                    break;
                }
                try {
                    retIt = this.freeList.take();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            ++attempts;
            retIt = this.freeList.poll();
        }
        assert (retIt != null);
        return retIt;
    }

    private OrderedIteration<T> removeAbortDone() {
        this.robLock.lock();
        try {
            Iterator<OrderedIteration<T>> i = this.rob.iterator();
            while (i.hasNext()) {
                OrderedIteration<T> it = i.next();
                if (!it.hasStatus(OrderedIteration.Status.ABORT_DONE)) continue;
                i.remove();
                OrderedIteration<T> orderedIteration = it;
                return orderedIteration;
            }
            return null;
        }
        finally {
            this.robLock.unlock();
        }
    }

    @Override
    protected boolean allIterRetired() {
        this.robLock.lock();
        try {
            boolean bl = this.rob.isEmpty();
            return bl;
        }
        finally {
            this.robLock.unlock();
        }
    }

    private static class ROBComparator<U>
    implements Comparator<OrderedIteration<U>> {
        private Comparator<U> comp;

        public ROBComparator(Comparator<U> iterObjComparator) {
            this.comp = iterObjComparator;
        }

        @Override
        public int compare(OrderedIteration<U> it1, OrderedIteration<U> it2) {
            U it2Obj;
            if (it1 == it2) {
                return 0;
            }
            U it1Obj = it1.getIterationObject();
            int objCmpRes = this.comp.compare(it1Obj, it2Obj = it2.getIterationObject());
            if (objCmpRes == 0) {
                return it1.hashCode() - it2.hashCode();
            }
            return objCmpRes;
        }
    }
}

