/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime;

import galois.objects.Mappable;
import galois.runtime.AbstractConcurrentExecutor;
import galois.runtime.AbstractGaloisExecutor;
import galois.runtime.ForeachContext;
import galois.runtime.Iteration;
import galois.runtime.IterationStatistics;
import galois.runtime.MapInternalContext;
import galois.runtime.MappableType;
import galois.runtime.UnorderedExecutor;
import galois.runtime.wl.Worklist;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import util.fn.Lambda2Void;

class MappableExecutor<T>
extends UnorderedExecutor<Object> {
    private final Mappable<T> mappable;
    private Object[] args;
    private MappableType type;
    private Object body;
    private Lambda2Void<Object, ForeachContext<Object>> dummyBody;

    public MappableExecutor(Mappable<T> mappable) {
        this.mappable = mappable;
    }

    @Override
    protected AbstractConcurrentExecutor.Process newProcess(int tid) {
        return new MyProcess(tid);
    }

    private void initialize(Object body, MappableType type, Object[] args) {
        this.body = body;
        this.type = type;
        this.args = args;
    }

    public IterationStatistics call(Object body, MappableType type, Object ... args) throws ExecutionException {
        this.initialize(body, type, args);
        IterationStatistics stats = this.call(this.dummyBody, new DummyWorklist(this.numThreads));
        this.mappable.mapInternalDone();
        return stats;
    }

    private class DummyWorklist
    implements Worklist<Object> {
        private AtomicInteger size;

        private DummyWorklist(int numThreads) {
            this.size = new AtomicInteger(numThreads);
        }

        @Override
        public void add(Object item, ForeachContext<Object> ctx) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addInitial(Object item, ForeachContext<Object> ctx) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void finishAddInitial() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return this.size.get() <= 0;
        }

        @Override
        public Object poll(ForeachContext<Object> ctx) {
            if (this.size.getAndDecrement() > 0) {
                return this;
            }
            return null;
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Worklist<Object> newInstance() {
            throw new UnsupportedOperationException();
        }
    }

    private class MyProcess
    extends AbstractGaloisExecutor.GaloisProcess
    implements MapInternalContext {
        public MyProcess(int id) {
            super(id);
        }

        @Override
        protected void doCall() throws Exception {
            try {
                MappableExecutor.this.type.call(MappableExecutor.this.mappable, MappableExecutor.this.body, this, MappableExecutor.this.args);
            }
            finally {
                Iteration.setCurrentIteration(null);
            }
        }

        @Override
        public void abort() {
            this.doAbort();
        }

        @Override
        public void begin() {
            this.setupCurrentIteration();
        }

        @Override
        public void commit(Object obj) {
            this.doCommit(obj);
        }
    }
}

