/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime;

import galois.runtime.Callback;
import galois.runtime.Executor;
import galois.runtime.ForeachContext;
import galois.runtime.GaloisRuntime;
import galois.runtime.Iteration;
import galois.runtime.ParameterStatistics;
import galois.runtime.ReleaseCallback;
import galois.runtime.wl.ParameterWorklist;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import util.SystemProperties;
import util.fn.Lambda2Void;

abstract class AbstractParameterExecutor<T, S>
implements Executor,
ForeachContext<T> {
    protected static Logger logger = Logger.getLogger("galois.runtime.ParameterExecutor");
    protected static int parameterCommittedLimit = SystemProperties.getIntProperty("galois.runtime.parameterCommittedLimit", -1);
    protected Lambda2Void<T, ForeachContext<T>> body;
    private int timeStep;
    private final Deque<Callback> suspendThunks = new ArrayDeque<Callback>();
    protected boolean yield;
    private ParameterStatistics stats;

    protected AbstractParameterExecutor() {
        if (parameterCommittedLimit > 0) {
            logger.info("Number of executed iterations per step (i.e. max available parallelism limited by: " + parameterCommittedLimit);
        }
    }

    protected void log(String msg, Object ... args) {
    }

    @Override
    public void finish() {
        Iteration.getCurrentIteration().addCommitAction(new Callback(){

            @Override
            public void call() {
                AbstractParameterExecutor.this.yield = true;
            }
        });
    }

    @Override
    public int getThreadId() {
        return 0;
    }

    @Override
    public int getIterationId() {
        return 0;
    }

    @Override
    public void onRelease(Iteration it, ReleaseCallback action) {
        it.addReleaseAction(action);
    }

    @Override
    public void onCommit(Iteration it, Callback action) {
        it.addCommitAction(action);
    }

    @Override
    public void onUndo(Iteration it, Callback action) {
        it.addUndoAction(action);
    }

    @Override
    public boolean isSerial() {
        return false;
    }

    @Override
    public void suspend(Callback listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void suspendDone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void suspendWith(final Callback call) {
        Iteration.getCurrentIteration().addCommitAction(new Callback(){

            @Override
            public void call() {
                AbstractParameterExecutor.this.suspendThunks.addFirst(call);
                AbstractParameterExecutor.this.yield = true;
            }
        });
    }

    public final ParameterStatistics call(Lambda2Void<T, ForeachContext<T>> body) throws ExecutionException {
        this.body = body;
        this.stats = new ParameterStatistics();
        this.runLoop();
        return this.stats;
    }

    protected abstract int commitAll();

    protected abstract void finishLoop();

    protected abstract void finishTimeStep();

    protected abstract void initTimeStep();

    protected abstract ParameterWorklist<T, S> getWorklist();

    protected abstract void logStats();

    protected final int getTimeStep() {
        return this.timeStep;
    }

    protected final <I extends Iteration> void dumpStepStats(StepRecord<I> stepRec) {
        int notUsefulSize = stepRec.getNumNotUsefull();
        int parallelWork = stepRec.executed.size() - notUsefulSize;
        int worklistSize = stepRec.worklistSize - notUsefulSize;
        this.stats.putStats(Thread.currentThread(), parallelWork, worklistSize, notUsefulSize, stepRec.neighborhoodSizes);
    }

    protected abstract void run(S var1, Iteration var2) throws ExecutionException;

    protected abstract Iteration newIteration();

    protected final void runBody(T cur, Iteration it) {
        this.body.call(cur, this);
    }

    private void runLoop() throws ExecutionException {
        this.timeStep = 0;
        ParameterWorklist<T, S> worklist = this.getWorklist();
        while (!worklist.isEmpty()) {
            logger.info(String.format("Beginning timestep %d with %d worklist items", this.timeStep, worklist.size()));
            this.initTimeStep();
            Iteration currIter = null;
            while (!worklist.isEmpty()) {
                currIter = this.newIteration();
                Iteration.setCurrentIteration(currIter);
                S cur = worklist.internalNext();
                this.run(cur, currIter);
            }
            this.finishTimeStep();
            logger.fine("In root executor, commit outstanding iterations");
            int numCommits = this.commitAll();
            if (numCommits == 0) {
                throw new IllegalStateException("No commits! must make forward progress");
            }
            this.logStats();
            if (this.yield) {
                GaloisRuntime.getRuntime().replaceWithRootContextAndCall(new Callback(){

                    @Override
                    public void call() {
                        for (Callback thunk : AbstractParameterExecutor.this.suspendThunks) {
                            thunk.call();
                        }
                    }
                });
                this.suspendThunks.clear();
                this.yield = false;
            }
            worklist.nextStep();
            ++this.timeStep;
        }
        this.finishLoop();
    }

    protected abstract boolean usingEagerOutput();

    protected static class StepRecord<I extends Iteration> {
        Map<I, Boolean> executed = new HashMap<I, Boolean>();
        int numNotUsefull = 0;
        List<Integer> neighborhoodSizes = new ArrayList<Integer>();
        int worklistSize = 0;

        protected StepRecord() {
        }

        public void logExecuted(I it, boolean notUseful) {
            this.executed.put(it, notUseful);
            if (notUseful) {
                ++this.numNotUsefull;
            }
        }

        public int getNumNotUsefull() {
            return this.numNotUsefull;
        }

        public void logNeighSize(int neighSize) {
            this.neighborhoodSizes.add(neighSize);
        }

        public void logWlSize(int wlSize) {
            this.worklistSize = wlSize;
        }

        public void unlog(I it) {
            Boolean notUsefull = this.executed.remove(it);
            if (notUsefull != null && notUsefull.booleanValue()) {
                --this.numNotUsefull;
            }
        }

        public void clear() {
            this.executed.clear();
            this.numNotUsefull = 0;
            this.neighborhoodSizes.clear();
            this.worklistSize = 0;
        }
    }
}

