/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime;

import galois.runtime.AbstractConcurrentExecutor;
import galois.runtime.Callback;
import galois.runtime.ForeachContext;
import galois.runtime.GaloisRuntime;
import galois.runtime.Iteration;
import galois.runtime.IterationAbortException;
import galois.runtime.ReleaseCallback;
import galois.runtime.WorkNotProgressiveException;
import galois.runtime.WorkNotUsefulException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;

abstract class AbstractGaloisExecutor<T>
extends AbstractConcurrentExecutor<T> {
    protected static Logger logger = Logger.getLogger("galois.runtime.Executor");
    protected int maxIterations = GaloisRuntime.getRuntime().getMaxIterations();
    private static final int lockCoalescing = 0;

    protected AbstractGaloisExecutor() {
    }

    protected int getMaxIterations() {
        return this.maxIterations;
    }

    protected void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    @Override
    public abstract void arbitrate(Iteration var1, Iteration var2);

    protected abstract void commitIteration(Iteration var1, int var2, T var3, boolean var4);

    protected abstract void abortIteration(Iteration var1) throws IterationAbortException;

    protected abstract Iteration newIteration(Iteration var1, int var2);

    protected abstract T poll(ForeachContext<T> var1);

    @Override
    protected AbstractConcurrentExecutor.Process newProcess(int tid) {
        return new GaloisProcess(tid);
    }

    @Override
    public void onRelease(Iteration it, ReleaseCallback action) {
        it.addReleaseAction(action);
    }

    @Override
    public void onCommit(Iteration it, Callback action) {
        it.addCommitAction(action);
    }

    @Override
    public void onUndo(Iteration it, Callback action) {
        it.addUndoAction(action);
    }

    protected class GaloisProcess
    extends AbstractConcurrentExecutor.Process {
        private Iteration currentIteration;
        private int iterationId;
        private boolean first;
        private int lastAbort;
        private int consecAborts;

        public GaloisProcess(int id) {
            super(id);
            this.iterationId = -1;
        }

        protected final void setupCurrentIteration() {
            Iteration it = AbstractGaloisExecutor.this.newIteration(this.currentIteration, this.getThreadId());
            if (it != this.currentIteration || this.first) {
                this.currentIteration = it;
                Iteration.setCurrentIteration(it);
                this.iterationId = this.currentIteration.getId();
                this.first = false;
            }
        }

        private T nextItem() {
            Object item;
            try {
                item = AbstractGaloisExecutor.this.poll(this);
            }
            catch (IterationAbortException e) {
                throw new Error("Worklist method threw unexpected exception");
            }
            if (item == null) {
                AbstractGaloisExecutor.this.commitIteration(this.currentIteration, this.iterationId, item, true);
            }
            return item;
        }

        protected final void doCommit(T item) {
            try {
                AbstractGaloisExecutor.this.commitIteration(this.currentIteration, this.iterationId, item, !false);
                ++this.numCommitted;
                this.recordCpuId();
            }
            catch (IterationAbortException iae) {
                this.readd(item);
                this.doAbort();
            }
        }

        protected final void doAbort() {
            AbstractGaloisExecutor.this.abortIteration(this.currentIteration);
            ++this.numAborted;
            int logFactor = 4;
            int mask = 15;
            if (this.lastAbort == this.numCommitted) {
                ++this.consecAborts;
                if (this.consecAborts > 1 && (this.consecAborts & 0xF) == 0) {
                    this.startWaiting();
                    try {
                        try {
                            Thread.sleep(this.consecAborts >> 4);
                        }
                        catch (InterruptedException e) {
                            throw new Error(e);
                        }
                    }
                    finally {
                        this.stopWaiting();
                    }
                }
            } else {
                this.consecAborts = 0;
            }
            this.lastAbort = this.numCommitted;
        }

        private void readd(T item) {
            while (true) {
                try {
                    AbstractGaloisExecutor.this.worklist.add(item, this);
                }
                catch (IterationAbortException iterationAbortException) {
                    continue;
                }
                break;
            }
        }

        @Override
        protected void doCall() throws Exception {
            this.first = true;
            try {
                while (true) {
                    this.setupCurrentIteration();
                    Object item = this.nextItem();
                    if (item == null) {
                        if (AbstractGaloisExecutor.this.yield) {
                            break;
                        }
                    } else {
                        try {
                            AbstractGaloisExecutor.this.body.call(item, this);
                            this.doCommit(item);
                        }
                        catch (IterationAbortException iae) {
                            this.readd(item);
                            this.doAbort();
                        }
                        catch (WorkNotProgressiveException wpe) {
                            this.doCommit(item);
                        }
                        catch (WorkNotUsefulException wnue) {
                            this.doCommit(item);
                        }
                        catch (Throwable e) {
                            if (this.currentIteration != null) {
                                ++this.numAborted;
                                AbstractGaloisExecutor.this.abortIteration(this.currentIteration);
                            }
                            throw new ExecutionException(e);
                        }
                        if (!AbstractGaloisExecutor.this.yield) continue;
                        break;
                    }
                    if (this.isDone()) break;
                }
            }
            finally {
                AbstractGaloisExecutor.this.makeAllDone();
                AbstractGaloisExecutor.this.wakeupAll();
                this.currentIteration = null;
                Iteration.setCurrentIteration(null);
            }
        }

        @Override
        public final void add(T t) {
            this.add(t, (byte)-1);
        }

        @Override
        public void add(final T t, byte flags) {
            final GaloisProcess ctx = this;
            if (GaloisRuntime.needMethodFlag(flags, (byte)2)) {
                this.currentIteration.addCommitAction(new Callback(){

                    @Override
                    public void call() {
                        ((GaloisProcess)GaloisProcess.this).AbstractGaloisExecutor.this.worklist.add(t, ctx);
                        if (AbstractGaloisExecutor.this.someDone()) {
                            AbstractGaloisExecutor.this.wakeupOne();
                        }
                    }
                });
            } else {
                AbstractGaloisExecutor.this.worklist.add(t, ctx);
                if (AbstractGaloisExecutor.this.someDone()) {
                    AbstractGaloisExecutor.this.wakeupOne();
                }
            }
        }

        @Override
        public void finish() {
            this.currentIteration.addCommitAction(new Callback(){

                @Override
                public void call() {
                    ((GaloisProcess)GaloisProcess.this).AbstractGaloisExecutor.this.finish = true;
                    ((GaloisProcess)GaloisProcess.this).AbstractGaloisExecutor.this.yield = true;
                }
            });
        }

        @Override
        public void suspendWith(final Callback call) {
            this.currentIteration.addCommitAction(new Callback(){

                @Override
                public void call() {
                    AbstractGaloisExecutor.this.addSuspendThunk(call);
                    ((GaloisProcess)GaloisProcess.this).AbstractGaloisExecutor.this.yield = true;
                }
            });
        }

        @Override
        public int getIterationId() {
            return this.iterationId;
        }
    }
}

