/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime;

import galois.runtime.Callback;
import galois.runtime.Executor;
import galois.runtime.ForeachContext;
import galois.runtime.GaloisRuntime;
import galois.runtime.Iteration;
import galois.runtime.IterationStatistics;
import galois.runtime.wl.Worklist;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import util.CPUFunctions;
import util.CollectionMath;
import util.Launcher;
import util.Statistics;
import util.fn.Lambda2Void;

abstract class AbstractConcurrentExecutor<T>
implements Executor {
    private static final boolean cpuFunctionsLoaded = GaloisRuntime.getRuntime().moreStats() && CPUFunctions.isLoaded();
    protected Worklist<T> worklist;
    protected Lambda2Void<T, ForeachContext<T>> body;
    protected final int numThreads = GaloisRuntime.getRuntime().getMaxThreads();
    private final ReentrantLock lock;
    private final Condition moreWork;
    private final List<Process> processes;
    private final AtomicInteger numDone = new AtomicInteger();
    private final Deque<Callback> suspendThunks;
    protected boolean yield;
    protected boolean finish;
    private Callback suspendListener;
    private IdlenessStatistics idleStats;
    private long systemWaitStart;
    private long systemStartTime;
    private boolean idleCounted;

    protected AbstractConcurrentExecutor() {
        this.lock = new ReentrantLock();
        this.moreWork = this.lock.newCondition();
        this.processes = new ArrayList<Process>();
        this.suspendThunks = new ArrayDeque<Callback>();
    }

    protected abstract Process newProcess(int var1);

    @Override
    public boolean isSerial() {
        return false;
    }

    @Override
    public void suspend(Callback listener) {
        this.systemWaitStart = System.nanoTime();
        this.suspendListener = listener;
        this.yield = true;
        this.makeAllDone();
        this.wakeupAll();
    }

    @Override
    public void suspendDone() {
        this.suspendListener = null;
        if (!this.idleCounted) {
            this.idleStats.put(this.systemStartTime, System.nanoTime(), this.processes, System.nanoTime() - this.systemWaitStart);
            this.idleCounted = true;
        }
    }

    private void startTiming() {
        this.systemStartTime = System.nanoTime();
    }

    private void stopTiming() {
        if (!this.idleCounted) {
            this.idleStats.put(this.systemStartTime, System.nanoTime(), this.processes, 0L);
            this.idleCounted = true;
        }
    }

    @Override
    public abstract void arbitrate(Iteration var1, Iteration var2);

    protected boolean allIterRetired() {
        return true;
    }

    private final void initialize(Lambda2Void<T, ForeachContext<T>> body, Worklist<T> worklist) {
        this.body = body;
        this.worklist = worklist;
        this.processes.clear();
        int tid = 0;
        while (tid < this.numThreads) {
            this.processes.add(this.newProcess(tid));
            ++tid;
        }
    }

    private void reset() {
        this.yield = false;
        this.finish = false;
        this.suspendListener = null;
        this.idleCounted = false;
        this.suspendThunks.clear();
        this.numDone.set(0);
    }

    public final IterationStatistics call(Lambda2Void<T, ForeachContext<T>> body, Worklist<T> worklist) throws ExecutionException {
        this.initialize(body, worklist);
        try {
            this.idleStats = new IdlenessStatistics();
            do {
                this.reset();
                this.startTiming();
                GaloisRuntime.getRuntime().callAll(this.processes);
                this.stopTiming();
                if (this.suspendThunks.isEmpty()) continue;
                GaloisRuntime.getRuntime().replaceWithRootContextAndCall(new Callback(){

                    @Override
                    public void call() {
                        for (Callback thunk : AbstractConcurrentExecutor.this.suspendThunks) {
                            thunk.call();
                        }
                    }
                });
            } while (!this.allIterRetired() || !this.finish && this.yield);
            Launcher.getLauncher().addStats(this.idleStats);
            if (cpuFunctionsLoaded) {
                CpuStatistics cpuStats = new CpuStatistics(this.numThreads);
                for (Process p : this.processes) {
                    cpuStats.putStats(p.id, p.cpuIds);
                }
                Launcher.getLauncher().addStats(cpuStats);
            }
            IterationStatistics stats = new IterationStatistics();
            for (Process p : this.processes) {
                stats.putStats(p.thread, p.numCommitted, p.numAborted);
            }
            return stats;
        }
        catch (InterruptedException e) {
            throw new ExecutionException(e);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    protected synchronized void addSuspendThunk(Callback callback) {
        this.suspendThunks.add(callback);
    }

    protected void wakeupOne() {
        this.lock.lock();
        try {
            this.moreWork.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void wakeupAll() {
        this.lock.lock();
        try {
            this.moreWork.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void makeAllDone() {
        int n;
        while (!this.numDone.compareAndSet(n = this.numDone.get(), this.numThreads)) {
        }
    }

    protected boolean someDone() {
        return this.numDone.get() > 0;
    }

    static /* synthetic */ ReentrantLock access$2(AbstractConcurrentExecutor abstractConcurrentExecutor) {
        return abstractConcurrentExecutor.lock;
    }

    static /* synthetic */ AtomicInteger access$3(AbstractConcurrentExecutor abstractConcurrentExecutor) {
        return abstractConcurrentExecutor.numDone;
    }

    static /* synthetic */ Condition access$4(AbstractConcurrentExecutor abstractConcurrentExecutor) {
        return abstractConcurrentExecutor.moreWork;
    }

    private static class CpuStatistics
    extends Statistics {
        private List<int[]> rows = new ArrayList<int[]>();
        private final List<Integer> tids;
        private int maxLength;
        private List<List<Integer>> results = new ArrayList<List<Integer>>();

        public CpuStatistics(int numThreads) {
            this.tids = new ArrayList<Integer>();
        }

        public void putStats(int tid, int[] cpuIds) {
            this.rows.add(cpuIds);
            this.tids.add(tid);
            this.maxLength = Math.max(this.maxLength, cpuIds.length);
        }

        private void computeResults() {
            if (this.rows != null) {
                this.results.add(this.getResults());
                this.rows = null;
            }
        }

        private List<Integer> getResults() {
            ArrayList<Integer> results = new ArrayList<Integer>();
            int size = this.rows.size();
            int i = 0;
            while (i < this.maxLength) {
                int max = 0;
                int maxTid = -1;
                int sum = 0;
                int j = 0;
                while (j < size) {
                    int value = this.rows.get(j)[i];
                    if (max < value) {
                        max = value;
                        maxTid = this.tids.get(j);
                    }
                    sum += value;
                    ++j;
                }
                if (sum > 0) {
                    results.add(i);
                    results.add(maxTid);
                    results.add(max);
                    results.add(sum);
                }
                ++i;
            }
            return results;
        }

        @Override
        public void dumpFull(PrintStream out) {
            this.computeResults();
            this.printFullHeader(out, "Processor Utilization");
            out.print("Max util per logical processor [cpuid, tid, utilization, (max / total samples)] per executor:\n");
            for (List<Integer> r : this.results) {
                int size = r.size();
                out.print("[");
                int i = 0;
                while (i < size) {
                    int cpuid = r.get(i);
                    int tid = r.get(i + 1);
                    int max = r.get(i + 2);
                    int total = r.get(i + 3);
                    float average = (float)max / (float)total;
                    out.printf("%d %d %.4f (%d / %d)", cpuid, tid, Float.valueOf(average), max, total);
                    if (i != size - 4) {
                        out.print(", ");
                    }
                    i += 4;
                }
                out.print("]");
                out.println();
            }
        }

        @Override
        public void dumpSummary(PrintStream out) {
            this.computeResults();
            this.printSummaryHeader(out, "Processor Utilization");
            int max = 0;
            int sum = 0;
            int count = 0;
            for (List<Integer> r : this.results) {
                int i = 0;
                while (i < r.size()) {
                    max += r.get(i + 2).intValue();
                    sum += r.get(i + 3).intValue();
                    i += 4;
                }
                count += r.size() / 4;
            }
            float mean = sum == 0 ? 0.0f : (float)max / (float)sum;
            float meanCounts = this.results.size() == 0 ? 0.0f : (float)count / (float)this.results.size();
            out.printf("mean: %.4f mean total processors: %.2f\n", Float.valueOf(mean), Float.valueOf(meanCounts));
        }

        @Override
        public void merge(Object other) {
            CpuStatistics stats = (CpuStatistics)other;
            stats.computeResults();
            this.results.addAll(stats.results);
        }
    }

    private class IdlenessStatistics
    extends Statistics {
        private final List<Long> threadTimes = new ArrayList<Long>();
        private final List<Long> idleTimes = new ArrayList<Long>();

        private IdlenessStatistics() {
        }

        @Override
        public void dumpFull(PrintStream out) {
            this.printFullHeader(out, "Idleness");
            out.printf("Thread time per measured period (thread*ms): %s\n", this.threadTimes);
            out.printf("Idle thread time per measured period (thread*ms): %s\n", this.idleTimes);
        }

        public void put(long systemStartTime, long systemStopTime, List<Process> processes, long systemAccumWait) {
            long idleTime = 0L;
            for (Process p : processes) {
                long stopTime = p.stopTime;
                if (p.startTime == 0L) continue;
                if (p.stopTime == 0L) {
                    stopTime = systemStopTime;
                }
                idleTime = (long)((double)idleTime + (double)(p.startTime - systemStartTime) / 1000000.0);
                idleTime = (long)((double)idleTime + (double)(systemStopTime - stopTime) / 1000000.0);
                idleTime = (long)((double)idleTime + (double)p.accumWait / 1000000.0);
            }
            idleTime = (long)((double)idleTime + (double)systemAccumWait / 1000000.0);
            this.threadTimes.add((systemStopTime - systemStartTime) / 1000000L * (long)processes.size());
            this.idleTimes.add(idleTime);
        }

        @Override
        public void dumpSummary(PrintStream out) {
            this.printSummaryHeader(out, "Idleness (thread*ms)");
            long totalThread = CollectionMath.sumLong(this.threadTimes);
            long totalIdle = CollectionMath.sumLong(this.idleTimes);
            out.printf("Thread Time: %d Idle Time: %d Rel. Idleness: %.4f\n", totalThread, totalIdle, (double)totalIdle / (double)totalThread);
        }

        @Override
        public void merge(Object obj) {
            IdlenessStatistics other = (IdlenessStatistics)obj;
            this.threadTimes.addAll(other.threadTimes);
            this.idleTimes.addAll(other.idleTimes);
        }
    }

    protected abstract class Process
    implements Callable<Object>,
    ForeachContext<T> {
        private final int id;
        Thread thread;
        protected int numCommitted;
        protected int numAborted;
        private long startTime;
        private long stopTime;
        private long waitStart;
        private long accumWait;
        private int[] cpuIds;

        protected Process(int id) {
            this.id = id;
            if (cpuFunctionsLoaded) {
                this.cpuIds = new int[256];
            }
        }

        protected abstract void doCall() throws Exception;

        protected final void recordCpuId() {
            if (cpuFunctionsLoaded) {
                int cpuid;
                int n = cpuid = CPUFunctions.getCpuId();
                this.cpuIds[n] = this.cpuIds[n] + 1;
            }
        }

        @Override
        public final Object call() throws Exception {
            this.thread = Thread.currentThread();
            this.accumWait = 0L;
            this.stopTime = 0L;
            this.startTime = System.nanoTime();
            try {
                this.doCall();
            }
            finally {
                this.stopTime = System.nanoTime();
                if (AbstractConcurrentExecutor.this.suspendListener != null) {
                    AbstractConcurrentExecutor.this.suspendListener.call();
                }
            }
            return null;
        }

        protected final void startWaiting() {
            this.waitStart = System.nanoTime();
        }

        protected final void stopWaiting() {
            this.accumWait += System.nanoTime() - this.waitStart;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected final boolean isDone() throws InterruptedException {
            block13: {
                AbstractConcurrentExecutor.access$2(AbstractConcurrentExecutor.this).lock();
                if (AbstractConcurrentExecutor.access$3(AbstractConcurrentExecutor.this).incrementAndGet() > AbstractConcurrentExecutor.this.numThreads) {
                    AbstractConcurrentExecutor.access$2(AbstractConcurrentExecutor.this).unlock();
                    return true;
                }
                {
                    if (AbstractConcurrentExecutor.access$3(AbstractConcurrentExecutor.this).get() != AbstractConcurrentExecutor.this.numThreads) ** GOTO lbl26
                    if (!AbstractConcurrentExecutor.this.worklist.isEmpty()) break block13;
                    AbstractConcurrentExecutor.this.wakeupAll();
                    AbstractConcurrentExecutor.access$2(AbstractConcurrentExecutor.this).unlock();
                    return true;
                }
            }
            ** try [egrp 2[TRYBLOCK] [3 : 96->107)] { 
lbl16:
            // 1 sources

            AbstractConcurrentExecutor.access$3(AbstractConcurrentExecutor.this).decrementAndGet();
            return false;
lbl-1000:
            // 1 sources

            {
                this.startWaiting();
                try {
                    AbstractConcurrentExecutor.access$4(AbstractConcurrentExecutor.this).await();
                    continue;
                }
                finally {
                    this.stopWaiting();
                }
lbl26:
                // 2 sources

                ** while (AbstractConcurrentExecutor.access$3((AbstractConcurrentExecutor)AbstractConcurrentExecutor.this).get() < AbstractConcurrentExecutor.this.numThreads && AbstractConcurrentExecutor.this.worklist.isEmpty())
            }
lbl27:
            // 1 sources

            if (AbstractConcurrentExecutor.access$3(AbstractConcurrentExecutor.this).get() != AbstractConcurrentExecutor.this.numThreads) ** GOTO lbl-1000
            AbstractConcurrentExecutor.this.wakeupAll();
            AbstractConcurrentExecutor.access$2(AbstractConcurrentExecutor.this).unlock();
            return true;
lbl-1000:
            // 1 sources

            {
                if (AbstractConcurrentExecutor.access$3(AbstractConcurrentExecutor.this).get() <= AbstractConcurrentExecutor.this.numThreads) ** GOTO lbl-1000
                AbstractConcurrentExecutor.access$2(AbstractConcurrentExecutor.this).unlock();
                return true;
            }
lbl-1000:
            // 1 sources

            {
                AbstractConcurrentExecutor.access$3(AbstractConcurrentExecutor.this).decrementAndGet();
                AbstractConcurrentExecutor.access$2(AbstractConcurrentExecutor.this).unlock();
                return false;
            }
lbl38:
            // 1 sources

            finally {
                AbstractConcurrentExecutor.access$2(AbstractConcurrentExecutor.this).unlock();
            }
        }

        @Override
        public int getThreadId() {
            return this.id;
        }
    }
}

