/*
 * Decompiled with CFR 0.152.
 */
package galois.objects.graph;

import galois.objects.GObject;
import galois.objects.graph.GNode;
import galois.objects.graph.ObjectGraph;
import galois.objects.graph.SerialGNode;
import galois.runtime.Callback;
import galois.runtime.GaloisRuntime;
import galois.runtime.Iteration;
import galois.runtime.MapInternalContext;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import util.fn.Lambda2Void;
import util.fn.Lambda3Void;
import util.fn.LambdaVoid;

final class SerialLocalComputationObjectGraph<N extends GObject, E>
implements ObjectGraph<N, E> {
    private Node[] nodes;
    private E[] edgeData;
    private int[] inIdx;
    private int[] ins;
    private int[] outIdx;
    private int[] outs;

    public SerialLocalComputationObjectGraph(ObjectGraph<N, E> in) {
        this.createGraph(in);
    }

    private void createGraph(final ObjectGraph<N, E> g) {
        int numNodes = g.size();
        this.nodes = new Node[numNodes];
        final GNode[] rnodes = new GNode[numNodes];
        final TObjectIntHashMap nodeMap = new TObjectIntHashMap();
        g.map(new LambdaVoid<GNode<N>>(){

            @Override
            public void call(GNode<N> node) {
                int idx = nodeMap.size();
                nodeMap.put(node, idx);
                ((SerialLocalComputationObjectGraph)SerialLocalComputationObjectGraph.this).nodes[idx] = new Node(SerialLocalComputationObjectGraph.this, idx, (GObject)node.getData());
                rnodes[idx] = node;
            }
        });
        TIntArrayList inIdx = new TIntArrayList();
        final TIntArrayList ins = new TIntArrayList();
        TIntArrayList outIdx = new TIntArrayList();
        final TIntArrayList outs = new TIntArrayList();
        final ArrayList edgeData = new ArrayList();
        inIdx.add(0);
        outIdx.add(0);
        int i = 0;
        while (i < numNodes) {
            final GNode src = rnodes[i];
            g.mapInNeighbors(src, new LambdaVoid<GNode<N>>(){

                @Override
                public void call(GNode<N> dst) {
                    ins.add(nodeMap.get(dst));
                }
            });
            inIdx.add(ins.size());
            src.map(new LambdaVoid<GNode<N>>(){

                @Override
                public void call(GNode<N> dst) {
                    outs.add(nodeMap.get(dst));
                    edgeData.add(g.getEdgeData(src, dst));
                }
            });
            outIdx.add(outs.size());
            ++i;
        }
        this.inIdx = inIdx.toArray();
        this.ins = ins.toArray();
        this.outIdx = outIdx.toArray();
        this.outs = outs.toArray();
        this.edgeData = edgeData.toArray();
    }

    private int getId(GNode n) {
        return ((Node)n).id;
    }

    @Override
    public GNode<N> createNode(N n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GNode<N> createNode(N n, byte flags) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(GNode<N> src) {
        return this.add(src, (byte)-1);
    }

    @Override
    public boolean add(GNode<N> src, byte flags) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(GNode<N> src) {
        return this.remove(src, (byte)-1);
    }

    @Override
    public boolean remove(GNode<N> src, byte flags) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(GNode<N> src) {
        return this.contains(src, (byte)-1);
    }

    @Override
    public boolean contains(GNode<N> src, byte flags) {
        int idx = this.getId(src);
        return idx >= 0 && idx < this.nodes.length;
    }

    private void acquireAll(byte flags) {
        if (GaloisRuntime.needMethodFlag(flags, (byte)1)) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public int size() {
        return this.size((byte)-1);
    }

    @Override
    public int size(byte flags) {
        this.acquireAll(flags);
        return this.nodes.length;
    }

    @Override
    public boolean addNeighbor(GNode<N> src, GNode<N> dst) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addNeighbor(GNode<N> src, GNode<N> dst, byte flags) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeNeighbor(GNode<N> src, GNode<N> dst) {
        return this.removeNeighbor(src, dst, (byte)-1);
    }

    @Override
    public boolean removeNeighbor(GNode<N> src, GNode<N> dst, byte flags) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNeighbor(GNode<N> src, GNode<N> dst) {
        return this.hasNeighbor(src, dst, (byte)-1);
    }

    private boolean hasNeighbor(GNode<N> src, GNode<N> dst, int[] adjIdx, int[] adj) {
        int idx = this.getId(src);
        int target = this.getId(dst);
        int start = adjIdx[idx];
        int end = adjIdx[idx + 1];
        int i = start;
        while (i < end) {
            if (adj[i] == target) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean hasNeighbor(GNode<N> src, GNode<N> dst, byte flags) {
        return this.hasNeighbor(src, dst, this.inIdx, this.ins) || this.hasNeighbor(src, dst, this.outIdx, this.outs);
    }

    void mapNeighbor(int[] adjIdx, int[] adj, GNode<N> src, LambdaVoid<GNode<N>> body) {
        int idx = this.getId(src);
        int start = adjIdx[idx];
        int end = adjIdx[idx + 1];
        int i = start;
        while (i < end) {
            Node other = this.nodes[adj[i]];
            body.call(other);
            ++i;
        }
    }

    @Override
    public void mapInNeighbors(GNode<N> src, LambdaVoid<GNode<N>> body) {
        this.mapInNeighbors(src, body, (byte)-1);
    }

    @Override
    public void mapInNeighbors(GNode<N> src, LambdaVoid<GNode<N>> body, byte flags) {
        this.mapNeighbor(this.inIdx, this.ins, src, body);
    }

    private int neighborsSize(GNode<N> src, int[] adjIdx, int[] adj) {
        int idx = this.getId(src);
        int start = adjIdx[idx];
        int end = adjIdx[idx + 1];
        return end - start;
    }

    @Override
    public int inNeighborsSize(GNode<N> src) {
        return this.inNeighborsSize(src, (byte)-1);
    }

    @Override
    public int inNeighborsSize(GNode<N> src, byte flags) {
        return this.neighborsSize(src, this.inIdx, this.ins);
    }

    @Override
    public int outNeighborsSize(GNode<N> src) {
        return this.outNeighborsSize(src, (byte)-1);
    }

    @Override
    public int outNeighborsSize(GNode<N> src, byte flags) {
        return this.neighborsSize(src, this.outIdx, this.outs);
    }

    @Override
    public boolean addEdge(GNode<N> src, GNode<N> dst, E data) {
        return this.addEdge(src, dst, data, (byte)-1);
    }

    @Override
    public boolean addEdge(GNode<N> src, GNode<N> dst, E data, byte flags) {
        throw new UnsupportedOperationException();
    }

    private int getEdgeIdx(GNode<N> src, GNode<N> dst) {
        int idx = this.getId(src);
        int target = this.getId(dst);
        int start = this.outIdx[idx];
        int end = this.outIdx[idx + 1];
        int i = start;
        while (i < end) {
            if (this.outs[i] == target) {
                return i;
            }
            ++i;
        }
        throw new Error("No such edge");
    }

    @Override
    public E getEdgeData(GNode<N> src, GNode<N> dst) {
        return this.getEdgeData(src, dst, (byte)-1);
    }

    @Override
    public E getEdgeData(GNode<N> src, GNode<N> dst, byte flags) {
        return this.getEdgeData(src, dst, flags, flags);
    }

    @Override
    public E getEdgeData(GNode<N> src, GNode<N> dst, byte edgeFlags, byte dataFlags) {
        return this.edgeData[this.getEdgeIdx(src, dst)];
    }

    @Override
    public E setEdgeData(GNode<N> src, GNode<N> dst, E d) {
        return this.setEdgeData(src, dst, d, (byte)-1);
    }

    @Override
    public E setEdgeData(final GNode<N> src, final GNode<N> dst, E data, byte flags) {
        int idx = this.getEdgeIdx(src, dst);
        final E oldData = this.edgeData[idx];
        if (oldData != data) {
            this.edgeData[idx] = data;
            if (GaloisRuntime.needMethodFlag(flags, (byte)2)) {
                GaloisRuntime.getRuntime().onUndo(Iteration.getCurrentIteration(), new Callback(){

                    @Override
                    public void call() {
                        SerialLocalComputationObjectGraph.this.setEdgeData(src, dst, oldData, (byte)0);
                    }
                });
            }
        }
        return oldData;
    }

    @Override
    public boolean isDirected() {
        return true;
    }

    @Override
    public void mapInternal(LambdaVoid<GNode<N>> body, MapInternalContext ctx) {
        int size = this.nodes.length;
        int i = 0;
        while (i < size) {
            ctx.begin();
            body.call(this.nodes[i]);
            ctx.commit(this.nodes[i]);
            ++i;
        }
    }

    @Override
    public <A1> void mapInternal(Lambda2Void<GNode<N>, A1> body, MapInternalContext ctx, A1 arg1) {
        int size = this.nodes.length;
        int i = 0;
        while (i < size) {
            ctx.begin();
            body.call(this.nodes[i], arg1);
            ctx.commit(this.nodes[i]);
            ++i;
        }
    }

    @Override
    public <A1, A2> void mapInternal(Lambda3Void<GNode<N>, A1, A2> body, MapInternalContext ctx, A1 arg1, A2 arg2) {
        int size = this.nodes.length;
        int i = 0;
        while (i < size) {
            ctx.begin();
            body.call(this.nodes[i], arg1, arg2);
            ctx.commit(this.nodes[i]);
            ++i;
        }
    }

    @Override
    public void mapInternalDone() {
    }

    @Override
    public void map(LambdaVoid<GNode<N>> body) {
        this.map(body, (byte)-1);
    }

    @Override
    public void map(LambdaVoid<GNode<N>> body, byte flags) {
        this.acquireAll(flags);
        int i = 0;
        while (i < this.nodes.length) {
            body.call(this.nodes[i]);
            ++i;
        }
    }

    @Override
    public <A1> void map(Lambda2Void<GNode<N>, A1> body, A1 arg1) {
        this.map(body, arg1, (byte)-1);
    }

    @Override
    public <A1> void map(Lambda2Void<GNode<N>, A1> body, A1 arg1, byte flags) {
        this.acquireAll(flags);
        int i = 0;
        while (i < this.nodes.length) {
            body.call(this.nodes[i], arg1);
            ++i;
        }
    }

    @Override
    public <A1, A2> void map(Lambda3Void<GNode<N>, A1, A2> body, A1 arg1, A2 arg2) {
        this.map(body, arg1, arg2, (byte)-1);
    }

    @Override
    public <A1, A2> void map(Lambda3Void<GNode<N>, A1, A2> body, A1 arg1, A2 arg2, byte flags) {
        this.acquireAll(flags);
        int i = 0;
        while (i < this.nodes.length) {
            body.call(this.nodes[i], arg1, arg2);
            ++i;
        }
    }

    @Override
    public void access(byte flags) {
    }

    private static final class Node
    extends SerialGNode<N> {
        private final int id;
        private N data;
        final /* synthetic */ SerialLocalComputationObjectGraph this$0;

        private Node(int id, N data) {
            this.this$0 = var1_1;
            this.id = id;
            this.data = data;
        }

        @Override
        public N getData() {
            return this.getData((byte)-1);
        }

        @Override
        public N getData(byte flags) {
            return this.getData(flags, flags);
        }

        @Override
        public N getData(byte nodeFlags, byte dataFlags) {
            return this.data;
        }

        @Override
        public N setData(N data) {
            return this.setData((N)data, (byte)-1);
        }

        @Override
        public N setData(N data, byte flags) {
            Object oldData = this.data;
            if (oldData != data) {
                this.data = data;
                if (GaloisRuntime.needMethodFlag(flags, (byte)2)) {
                    GaloisRuntime.getRuntime().onUndo(Iteration.getCurrentIteration(), new Callback((GObject)oldData){
                        private final /* synthetic */ GObject val$oldData;
                        {
                            this.val$oldData = gObject;
                        }

                        @Override
                        public void call() {
                            Node.this.setData(this.val$oldData, (byte)0);
                        }
                    });
                }
            }
            return oldData;
        }

        @Override
        public void mapInternal(LambdaVoid<GNode<N>> body, MapInternalContext ctx) {
            int idx = this.this$0.getId(this);
            int startIdx = this.this$0.outIdx[idx];
            int endIdx = this.this$0.outIdx[idx + 1];
            int size = endIdx - startIdx;
            int i = 0;
            while (i < size) {
                Node item = this.this$0.nodes[this.this$0.outs[startIdx + i]];
                ctx.begin();
                body.call(item);
                ctx.commit(item);
                ++i;
            }
        }

        @Override
        public <A1> void mapInternal(Lambda2Void<GNode<N>, A1> body, MapInternalContext ctx, A1 arg1) {
            int idx = this.this$0.getId(this);
            int startIdx = this.this$0.outIdx[idx];
            int endIdx = this.this$0.outIdx[idx + 1];
            int size = endIdx - startIdx;
            int i = 0;
            while (i < size) {
                Node item = this.this$0.nodes[this.this$0.outs[startIdx + i]];
                ctx.begin();
                body.call(item, arg1);
                ctx.commit(item);
                ++i;
            }
        }

        @Override
        public <A1, A2> void mapInternal(Lambda3Void<GNode<N>, A1, A2> body, MapInternalContext ctx, A1 arg1, A2 arg2) {
            int idx = this.this$0.getId(this);
            int startIdx = this.this$0.outIdx[idx];
            int endIdx = this.this$0.outIdx[idx + 1];
            int size = endIdx - startIdx;
            int i = 0;
            while (i < size) {
                Node item = this.this$0.nodes[this.this$0.outs[startIdx + i]];
                ctx.begin();
                body.call(item, arg1, arg2);
                ctx.commit(item);
                ++i;
            }
        }

        @Override
        public void mapInternalDone() {
        }

        @Override
        public void map(LambdaVoid<GNode<N>> body) {
            this.map(body, (byte)-1);
        }

        @Override
        public void map(LambdaVoid<GNode<N>> body, byte flags) {
            this.this$0.mapNeighbor(this.this$0.outIdx, this.this$0.outs, this, body);
        }

        @Override
        public <A1> void map(Lambda2Void<GNode<N>, A1> body, A1 arg1) {
            this.map(body, arg1, (byte)-1);
        }

        @Override
        public <A1> void map(Lambda2Void<GNode<N>, A1> body, A1 arg1, byte flags) {
            int idx = this.this$0.getId(this);
            int start = this.this$0.outIdx[idx];
            int end = this.this$0.outIdx[idx + 1];
            int i = start;
            while (i < end) {
                Node other = this.this$0.nodes[this.this$0.outs[i]];
                body.call(other, arg1);
                ++i;
            }
        }

        @Override
        public <A1, A2> void map(Lambda3Void<GNode<N>, A1, A2> body, A1 arg1, A2 arg2) {
            this.map(body, arg1, arg2, (byte)-1);
        }

        @Override
        public <A1, A2> void map(Lambda3Void<GNode<N>, A1, A2> body, A1 arg1, A2 arg2, byte flags) {
            int idx = this.this$0.getId(this);
            int start = this.this$0.outIdx[idx];
            int end = this.this$0.outIdx[idx + 1];
            int i = start;
            while (i < end) {
                Node other = this.this$0.nodes[this.this$0.outs[i]];
                body.call(other, arg1, arg2);
                ++i;
            }
        }
    }
}

