/*
 * Decompiled with CFR 0.152.
 */
package galois.objects.graph;

import galois.objects.GObject;
import galois.objects.graph.GNode;
import galois.objects.graph.IndexedGraph;
import galois.objects.graph.SerialGNode;
import galois.runtime.IterationAbortException;
import galois.runtime.MapInternalContext;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import util.fn.Lambda2Void;
import util.fn.Lambda3Void;
import util.fn.LambdaVoid;

final class SerialArrayIndexedTree<N extends GObject>
implements IndexedGraph<N> {
    private final int maxNeighbors;
    private LinkedNode head;
    private int size;
    private static final int chunkSize = 64;

    public SerialArrayIndexedTree(int capacity) {
        assert (capacity > 0);
        this.maxNeighbors = capacity;
        this.head = null;
        this.size = 0;
    }

    @Override
    public GNode<N> createNode(N data) {
        return this.createNode(data, (byte)-1);
    }

    @Override
    public GNode<N> createNode(N n, byte flags) {
        return new IndexedTreeNode(this, n);
    }

    @Override
    public final boolean add(GNode<N> src) {
        return this.add(src, (byte)-1);
    }

    @Override
    public boolean add(GNode<N> src, byte flags) {
        if (((IndexedTreeNode)src).add(this)) {
            ++this.size;
            return true;
        }
        return false;
    }

    @Override
    public final boolean remove(GNode<N> src) {
        return this.remove(src, (byte)-1);
    }

    @Override
    public boolean remove(GNode<N> src, byte flags) {
        if (!this.contains(src, flags)) {
            return false;
        }
        --this.size;
        IndexedTreeNode ignsrc = (IndexedTreeNode)src;
        int i = 0;
        while (i < this.maxNeighbors) {
            if (ignsrc.child[i] != null) {
                this.removeNeighbor(ignsrc, i, flags);
            }
            ++i;
        }
        if (ignsrc.parent != null) {
            this.removeNeighbor(ignsrc.parent, ignsrc, flags);
        }
        boolean ret = ignsrc.remove(this);
        assert (ret);
        return true;
    }

    @Override
    public final boolean contains(GNode<N> src) {
        return this.contains(src, (byte)-1);
    }

    @Override
    public boolean contains(GNode<N> src, byte flags) {
        return ((IndexedTreeNode)src).inGraph(this);
    }

    @Override
    public final int size() {
        return this.size((byte)-1);
    }

    @Override
    public int size(byte flags) {
        int ret = this.size;
        assert (ret >= 0);
        return ret;
    }

    @Override
    public final boolean addNeighbor(GNode<N> src, GNode<N> dst) {
        throw new UnsupportedOperationException("addNeighbor not supported in IndexedGraphs");
    }

    @Override
    public boolean addNeighbor(GNode<N> src, GNode<N> dst, byte flags) {
        throw new UnsupportedOperationException("addNeighbor not supported in IndexedGraphs");
    }

    @Override
    public final boolean removeNeighbor(GNode<N> src, GNode<N> dst) {
        return this.removeNeighbor(src, dst, (byte)-1);
    }

    @Override
    public boolean removeNeighbor(GNode<N> src, GNode<N> dst, byte flags) {
        int idx = this.childIndex(src, dst);
        if (idx >= 0) {
            this.removeNeighbor(src, idx, flags);
            return true;
        }
        return false;
    }

    @Override
    public final boolean hasNeighbor(GNode<N> src, GNode<N> dst) {
        return this.hasNeighbor(src, dst, (byte)-1);
    }

    @Override
    public boolean hasNeighbor(GNode<N> src, GNode<N> dst, byte flags) {
        return this.childIndex(src, dst) >= 0;
    }

    @Override
    public final void mapInNeighbors(GNode<N> src, LambdaVoid<GNode<N>> body) {
        this.mapInNeighbors(src, body, (byte)-1);
    }

    @Override
    public void mapInNeighbors(GNode<N> src, LambdaVoid<GNode<N>> closure, byte flags) {
        IndexedTreeNode n = (IndexedTreeNode)src;
        if (n.parent != null) {
            closure.call(n.parent);
        }
    }

    @Override
    public final int inNeighborsSize(GNode<N> src) {
        return this.inNeighborsSize(src, (byte)-1);
    }

    @Override
    public int inNeighborsSize(GNode<N> src, byte flags) {
        IndexedTreeNode ignsrc = (IndexedTreeNode)src;
        if (ignsrc.parent != null) {
            return 1;
        }
        return 0;
    }

    @Override
    public final int outNeighborsSize(GNode<N> src) {
        return this.outNeighborsSize(src, (byte)-1);
    }

    @Override
    public int outNeighborsSize(GNode<N> src, byte flags) {
        IndexedTreeNode ignsrc = (IndexedTreeNode)src;
        int cnt = 0;
        int i = 0;
        while (i < this.maxNeighbors) {
            if (ignsrc.child[i] != null) {
                ++cnt;
            }
            ++i;
        }
        return cnt;
    }

    @Override
    public boolean isDirected() {
        return true;
    }

    @Override
    public final void setNeighbor(GNode<N> src, GNode<N> dst, int idx) {
        this.setNeighbor(src, dst, idx, (byte)-1);
    }

    @Override
    public void setNeighbor(GNode<N> src, GNode<N> dst, int idx, byte flags) {
        IndexedTreeNode ignsrc = (IndexedTreeNode)src;
        IndexedTreeNode old = ignsrc.child[idx];
        if (old != dst) {
            IndexedTreeNode igndst = (IndexedTreeNode)dst;
            if (igndst.parent != null) {
                this.removeNeighbor(igndst.parent, igndst, flags);
            }
            igndst.parent = ignsrc;
            if (old != null) {
                this.removeNeighbor(ignsrc, idx, flags);
            }
            ignsrc.child[idx] = igndst;
        }
    }

    @Override
    public final GNode<N> getNeighbor(GNode<N> node, int idx) {
        return this.getNeighbor(node, idx, (byte)-1);
    }

    @Override
    public GNode<N> getNeighbor(GNode<N> node, int idx, byte flags) {
        IndexedTreeNode ignode = (IndexedTreeNode)node;
        IndexedTreeNode ret = ignode.child[idx];
        return ret;
    }

    @Override
    public final boolean removeNeighbor(GNode<N> node, int idx) {
        return this.removeNeighbor(node, idx, (byte)-1);
    }

    @Override
    public boolean removeNeighbor(GNode<N> src, int idx, byte flags) {
        IndexedTreeNode ignsrc = (IndexedTreeNode)src;
        IndexedTreeNode child = ignsrc.child[idx];
        if (child != null) {
            ignsrc.child[idx].parent = null;
            ignsrc.child[idx] = null;
            return true;
        }
        return false;
    }

    private int childIndex(GNode<N> src, GNode<N> dst) {
        IndexedTreeNode ignsrc = (IndexedTreeNode)src;
        List<IndexedTreeNode> neighborList = Arrays.asList(ignsrc.child);
        return neighborList.indexOf(dst);
    }

    private boolean tryMark(IndexedTreeNode curr) {
        return true;
    }

    private IndexedTreeNode scanForNode(LinkedNode start) {
        while (start != null) {
            if (start.isDummy()) {
                start = start.getNext();
                continue;
            }
            return (IndexedTreeNode)start;
        }
        return null;
    }

    @Override
    public void mapInternal(LambdaVoid<GNode<N>> body, MapInternalContext ctx) {
        IndexedTreeNode begin = this.scanForNode(this.head);
        while (begin != null) {
            boolean owned = false;
            if (this.tryMark(begin)) {
                owned = true;
            }
            IndexedTreeNode cur = begin;
            int i = 0;
            while (i < 64) {
                if (owned) {
                    while (true) {
                        try {
                            ctx.begin();
                            body.call(cur);
                            ctx.commit(cur);
                        }
                        catch (IterationAbortException e) {
                            ctx.abort();
                            continue;
                        }
                        break;
                    }
                }
                if ((cur = this.scanForNode(cur.next)) == null) break;
                ++i;
            }
            begin = cur;
        }
    }

    @Override
    public <A1> void mapInternal(Lambda2Void<GNode<N>, A1> body, MapInternalContext ctx, A1 arg1) {
        IndexedTreeNode begin = this.scanForNode(this.head);
        while (begin != null) {
            boolean owned = false;
            if (this.tryMark(begin)) {
                owned = true;
            }
            IndexedTreeNode cur = begin;
            int i = 0;
            while (i < 64) {
                if (owned) {
                    while (true) {
                        try {
                            ctx.begin();
                            body.call(cur, arg1);
                            ctx.commit(cur);
                        }
                        catch (IterationAbortException e) {
                            ctx.abort();
                            continue;
                        }
                        break;
                    }
                }
                if ((cur = this.scanForNode(cur.next)) == null) break;
                ++i;
            }
            begin = cur;
        }
    }

    @Override
    public <A1, A2> void mapInternal(Lambda3Void<GNode<N>, A1, A2> body, MapInternalContext ctx, A1 arg1, A2 arg2) {
        IndexedTreeNode begin = this.scanForNode(this.head);
        while (begin != null) {
            boolean owned = false;
            if (this.tryMark(begin)) {
                owned = true;
            }
            IndexedTreeNode cur = begin;
            int i = 0;
            while (i < 64) {
                if (owned) {
                    while (true) {
                        try {
                            ctx.begin();
                            body.call(cur, arg1, arg2);
                            ctx.commit(cur);
                        }
                        catch (IterationAbortException e) {
                            ctx.abort();
                            continue;
                        }
                        break;
                    }
                }
                if ((cur = this.scanForNode(cur.next)) == null) break;
                ++i;
            }
            begin = cur;
        }
    }

    @Override
    public void map(LambdaVoid<GNode<N>> body) {
        this.map(body, (byte)-1);
    }

    @Override
    public void map(LambdaVoid<GNode<N>> body, byte flags) {
        LinkedNode curr = this.head;
        while (curr != null) {
            if (!curr.isDummy()) {
                IndexedTreeNode gsrc = (IndexedTreeNode)curr;
                assert (gsrc.in);
                body.call(gsrc);
            }
            curr = curr.getNext();
        }
    }

    @Override
    public <A1> void map(Lambda2Void<GNode<N>, A1> body, A1 arg1) {
        this.map(body, arg1, (byte)-1);
    }

    @Override
    public <A1> void map(Lambda2Void<GNode<N>, A1> body, A1 arg1, byte flags) {
        LinkedNode curr = this.head;
        while (curr != null) {
            if (!curr.isDummy()) {
                IndexedTreeNode gsrc = (IndexedTreeNode)curr;
                assert (gsrc.in);
                body.call(gsrc, arg1);
            }
            curr = curr.getNext();
        }
    }

    @Override
    public <A1, A2> void map(Lambda3Void<GNode<N>, A1, A2> body, A1 arg1, A2 arg2) {
        this.map(body, arg1, arg2, (byte)-1);
    }

    @Override
    public <A1, A2> void map(Lambda3Void<GNode<N>, A1, A2> body, A1 arg1, A2 arg2, byte flags) {
        LinkedNode curr = this.head;
        while (curr != null) {
            if (!curr.isDummy()) {
                IndexedTreeNode gsrc = (IndexedTreeNode)curr;
                assert (gsrc.in);
                body.call(gsrc, arg1, arg2);
            }
            curr = curr.getNext();
        }
    }

    @Override
    public void mapInternalDone() {
    }

    @Override
    public void access(byte flags) {
    }

    private static class DummyLinkedNode
    implements LinkedNode {
        private LinkedNode next;

        private DummyLinkedNode() {
        }

        @Override
        public void setNext(LinkedNode next) {
            this.next = next;
        }

        @Override
        public LinkedNode getNext() {
            return this.next;
        }

        @Override
        public boolean isDummy() {
            return true;
        }
    }

    protected static final class IndexedTreeNode
    extends SerialGNode<N>
    implements LinkedNode {
        protected N data;
        protected IndexedTreeNode[] child;
        protected IndexedTreeNode parent;
        private boolean in;
        private LinkedNode dummy;
        private LinkedNode next;
        final /* synthetic */ SerialArrayIndexedTree this$0;

        public IndexedTreeNode(N nodedata) {
            this.this$0 = var1_1;
            this.data = nodedata;
            this.child = (IndexedTreeNode[])Array.newInstance(this.getClass(), ((SerialArrayIndexedTree)var1_1).maxNeighbors);
            Arrays.fill(this.child, null);
            this.parent = null;
        }

        private boolean tryMark(IndexedTreeNode curr) {
            return true;
        }

        private boolean inGraph(SerialArrayIndexedTree<N> g) {
            return this.this$0 == g && this.in;
        }

        private boolean add(SerialArrayIndexedTree<N> g) {
            if (this.this$0 != g) {
                throw new UnsupportedOperationException("cannot add nodes created by a different graph");
            }
            if (!this.in) {
                LinkedNode currHead;
                this.in = true;
                this.dummy = new DummyLinkedNode();
                this.dummy.setNext(this);
                this.next = currHead = this.this$0.head;
                this.this$0.head = this.dummy;
                return true;
            }
            return false;
        }

        private boolean remove(SerialArrayIndexedTree<N> g) {
            if (this.inGraph(g)) {
                this.in = false;
                this.dummy.setNext(this.next);
                return true;
            }
            return false;
        }

        @Override
        public boolean isDummy() {
            return false;
        }

        @Override
        public LinkedNode getNext() {
            return this.next;
        }

        @Override
        public void setNext(LinkedNode next) {
            this.next = next;
        }

        @Override
        public final N getData() {
            return this.getData((byte)-1);
        }

        @Override
        public N getData(byte flags) {
            return this.getData(flags, flags);
        }

        @Override
        public N getData(byte nodeFlags, byte dataFlags) {
            Object ret = this.data;
            return ret;
        }

        @Override
        public final N setData(N data) {
            return this.setData((N)data, (byte)-1);
        }

        @Override
        public N setData(N data, byte flags) {
            Object oldData = this.data;
            this.data = data;
            return oldData;
        }

        @Override
        public void mapInternal(LambdaVoid<GNode<N>> body, MapInternalContext ctx) {
            int i = 0;
            while (i < this.this$0.maxNeighbors) {
                IndexedTreeNode c = this.child[i];
                if (c != null && this.tryMark(c)) {
                    while (true) {
                        try {
                            ctx.begin();
                            body.call(c);
                            ctx.commit(c);
                        }
                        catch (IterationAbortException iae) {
                            ctx.abort();
                            continue;
                        }
                        break;
                    }
                }
                ++i;
            }
        }

        @Override
        public <A1> void mapInternal(Lambda2Void<GNode<N>, A1> body, MapInternalContext ctx, A1 arg1) {
            int i = 0;
            while (i < this.this$0.maxNeighbors) {
                IndexedTreeNode c = this.child[i];
                if (c != null && this.tryMark(c)) {
                    while (true) {
                        try {
                            ctx.begin();
                            body.call(c, arg1);
                            ctx.commit(c);
                        }
                        catch (IterationAbortException iae) {
                            ctx.abort();
                            continue;
                        }
                        break;
                    }
                }
                ++i;
            }
        }

        @Override
        public <A1, A2> void mapInternal(Lambda3Void<GNode<N>, A1, A2> body, MapInternalContext ctx, A1 arg1, A2 arg2) {
            int i = 0;
            while (i < this.this$0.maxNeighbors) {
                IndexedTreeNode c = this.child[i];
                if (c != null && this.tryMark(c)) {
                    while (true) {
                        try {
                            ctx.begin();
                            body.call(c, arg1, arg2);
                            ctx.commit(c);
                        }
                        catch (IterationAbortException iae) {
                            ctx.abort();
                            continue;
                        }
                        break;
                    }
                }
                ++i;
            }
        }

        @Override
        public final void map(LambdaVoid<GNode<N>> body) {
            this.map(body, (byte)-1);
        }

        @Override
        public void map(LambdaVoid<GNode<N>> body, byte flags) {
            int i = 0;
            while (i < this.this$0.maxNeighbors) {
                IndexedTreeNode c = this.child[i];
                if (c != null) {
                    body.call(c);
                }
                ++i;
            }
        }

        @Override
        public <A1> void map(Lambda2Void<GNode<N>, A1> body, A1 arg1) {
            this.map(body, arg1, (byte)-1);
        }

        @Override
        public <A1> void map(Lambda2Void<GNode<N>, A1> body, A1 arg1, byte flags) {
            int i = 0;
            while (i < this.this$0.maxNeighbors) {
                IndexedTreeNode c = this.child[i];
                if (c != null) {
                    body.call(c, arg1);
                }
                ++i;
            }
        }

        @Override
        public <A1, A2> void map(Lambda3Void<GNode<N>, A1, A2> body, A1 arg1, A2 arg2) {
            this.map(body, arg1, arg2, (byte)-1);
        }

        @Override
        public <A1, A2> void map(Lambda3Void<GNode<N>, A1, A2> body, A1 arg1, A2 arg2, byte flags) {
            int i = 0;
            while (i < this.this$0.maxNeighbors) {
                IndexedTreeNode c = this.child[i];
                if (c != null) {
                    body.call(c, arg1, arg2);
                }
                ++i;
            }
        }

        @Override
        public void mapInternalDone() {
        }
    }

    private static interface LinkedNode {
        public void setNext(LinkedNode var1);

        public LinkedNode getNext();

        public boolean isDummy();
    }
}

