/*
 * Decompiled with CFR 0.152.
 */
package galois.objects.graph;

import galois.objects.GObject;
import galois.objects.graph.GNode;
import galois.objects.graph.Graph;
import galois.objects.graph.GraphLocker;
import galois.objects.graph.ObjectGraph;
import galois.runtime.Callback;
import galois.runtime.GaloisRuntime;
import galois.runtime.Iteration;
import java.util.HashMap;
import java.util.Map;
import util.fn.Lambda3Void;
import util.fn.LambdaVoid;

final class ObjectGraphLocker
extends GraphLocker {
    ObjectGraphLocker() {
    }

    static <N extends GObject, E> void removeNeighborEpilog(final ObjectGraph<N, E> graph, final GNode<N> src, final GNode<N> dst, final E edgeData, byte flags) {
        if (GaloisRuntime.needMethodFlag(flags, (byte)2)) {
            GaloisRuntime.getRuntime().onUndo(Iteration.getCurrentIteration(), new Callback(){

                @Override
                public void call() {
                    graph.addEdge(src, dst, edgeData, (byte)0);
                }
            });
        }
    }

    static <N extends GObject, E> void removeNodeProlog(final ObjectGraph<N, E> graph, final GNode<N> src, byte flags) {
        if (GaloisRuntime.needMethodFlag(flags, (byte)1)) {
            graph.mapInNeighbors(src, lock, (byte)0);
            if (graph.isDirected()) {
                src.map(lock2, Iteration.getCurrentIteration(), (byte)0);
            }
        }
        if (!GaloisRuntime.needMethodFlag(flags, (byte)2)) {
            return;
        }
        Lambda3Void getOutNeighbors = new Lambda3Void<GNode<N>, GNode<N>, Map<GNode<N>, E>>(){

            @Override
            public void call(GNode<N> dst, GNode<N> src, Map<GNode<N>, E> map) {
                map.put(src, graph.getEdgeData(src, dst, (byte)0));
            }
        };
        final HashMap outMap = new HashMap();
        src.map(getOutNeighbors, src, outMap, (byte)0);
        final HashMap inMap = new HashMap();
        graph.mapInNeighbors(src, new LambdaVoid<GNode<N>>(){

            @Override
            public void call(GNode<N> dst) {
                inMap.put(dst, graph.getEdgeData(dst, src, (byte)0));
            }
        }, (byte)0);
        GaloisRuntime.getRuntime().onUndo(Iteration.getCurrentIteration(), new Callback(){

            @Override
            public void call() {
                graph.add(src, (byte)0);
                for (Map.Entry edgeData : outMap.entrySet()) {
                    graph.addEdge(src, (GNode)edgeData.getKey(), edgeData.getValue(), (byte)0);
                }
                for (Map.Entry edgeData : inMap.entrySet()) {
                    graph.addEdge((GNode)edgeData.getKey(), src, edgeData.getValue(), (byte)0);
                }
            }
        });
    }

    static <N extends GObject> void addEdgeProlog(GNode<N> src, GNode<N> dst, byte flags) {
        ObjectGraphLocker.acquireLock(src, dst, flags);
    }

    static <N extends GObject> void addEdgeEpilog(final Graph<N> graph, final GNode<N> src, final GNode<N> dst, byte flags) {
        if (GaloisRuntime.needMethodFlag(flags, (byte)2)) {
            GaloisRuntime.getRuntime().onUndo(Iteration.getCurrentIteration(), new Callback(){

                @Override
                public void call() {
                    graph.removeNeighbor(src, dst, (byte)0);
                }
            });
        }
    }

    static <N extends GObject> void getEdgeDataProlog(GNode<N> src, GNode<N> dst, byte flags) {
        ObjectGraphLocker.acquireLock(src, dst, flags);
    }

    static <E> void getEdgeDataEpilog(E data, byte flags) {
        if (GaloisRuntime.needMethodFlag(flags, (byte)3)) {
            ((GObject)data).access(flags);
        }
    }

    static <N extends GObject> void setEdgeDataProlog(GNode<N> src, GNode<N> dst, byte flags) {
        ObjectGraphLocker.acquireLock(src, dst, flags);
    }

    static <N extends GObject, E> void setEdgeDataEpilog(final ObjectGraph<N, E> graph, final GNode<N> src, final GNode<N> dst, final E data, byte flags) {
        if (GaloisRuntime.needMethodFlag(flags, (byte)2)) {
            GaloisRuntime.getRuntime().onUndo(Iteration.getCurrentIteration(), new Callback(){

                @Override
                public void call() {
                    graph.setEdgeData(src, dst, data, (byte)0);
                }
            });
        }
    }
}

