/*
 * Decompiled with CFR 0.152.
 */
package galois.objects.graph;

import galois.objects.GObject;
import galois.objects.graph.DoubleGraph;
import galois.objects.graph.FloatGraph;
import galois.objects.graph.Graph;
import galois.objects.graph.HashMorphObjectGraph;
import galois.objects.graph.IntGraph;
import galois.objects.graph.LongGraph;
import galois.objects.graph.ObjectGraph;
import galois.objects.graph.ObjectGraphToAllObjectGraphAdapter;
import galois.objects.graph.ObjectGraphToDoubleGraphAdapter;
import galois.objects.graph.ObjectGraphToFloatGraphAdapter;
import galois.objects.graph.ObjectGraphToIntGraphAdapter;
import galois.objects.graph.ObjectGraphToLongGraphAdapter;
import galois.objects.graph.ObjectGraphToVoidGraphAdapter;
import galois.objects.graph.SerialHashMorphObjectGraph;
import galois.objects.graph.SerialVectorMorphObjectGraph;
import galois.objects.graph.VectorMorphObjectGraph;
import galois.runtime.GaloisRuntime;

public final class MorphGraph {
    private MorphGraph() {
    }

    public static class DoubleGraphBuilder {
        boolean serial = false;
        boolean directed = false;
        boolean backedByVector = false;

        public DoubleGraphBuilder serial(boolean serial) {
            this.serial = serial;
            return this;
        }

        public DoubleGraphBuilder directed(boolean directed) {
            this.directed = directed;
            return this;
        }

        public DoubleGraphBuilder backedByVector(boolean backedByVector) {
            this.backedByVector = backedByVector;
            return this;
        }

        public <N extends GObject> DoubleGraph<N> create() {
            ObjectGraphBuilder builder = new ObjectGraphBuilder();
            ObjectGraph objectGraph = builder.directed(this.directed).serial(this.serial).backedByVector(this.backedByVector).create();
            return new ObjectGraphToDoubleGraphAdapter(objectGraph);
        }
    }

    public static class FloatGraphBuilder {
        boolean serial = false;
        boolean directed = false;
        boolean backedByVector = false;

        public FloatGraphBuilder serial(boolean serial) {
            this.serial = serial;
            return this;
        }

        public FloatGraphBuilder directed(boolean directed) {
            this.directed = directed;
            return this;
        }

        public FloatGraphBuilder backedByVector(boolean backedByVector) {
            this.backedByVector = backedByVector;
            return this;
        }

        public <N extends GObject> FloatGraph<N> create() {
            ObjectGraphBuilder builder = new ObjectGraphBuilder();
            ObjectGraph objectGraph = builder.directed(this.directed).serial(this.serial).backedByVector(this.backedByVector).create();
            return new ObjectGraphToFloatGraphAdapter(objectGraph);
        }
    }

    public static class IntGraphBuilder {
        boolean serial = false;
        boolean directed = false;
        boolean backedByVector = false;

        public IntGraphBuilder serial(boolean serial) {
            this.serial = serial;
            return this;
        }

        public IntGraphBuilder directed(boolean directed) {
            this.directed = directed;
            return this;
        }

        public IntGraphBuilder backedByVector(boolean backedByVector) {
            this.backedByVector = backedByVector;
            return this;
        }

        public <N extends GObject> IntGraph<N> create() {
            ObjectGraphBuilder builder = new ObjectGraphBuilder();
            ObjectGraph objectGraph = builder.directed(this.directed).serial(this.serial).backedByVector(this.backedByVector).create();
            return new ObjectGraphToIntGraphAdapter(objectGraph);
        }
    }

    public static class LongGraphBuilder {
        boolean serial = false;
        boolean directed = false;
        boolean backedByVector = false;

        public LongGraphBuilder serial(boolean serial) {
            this.serial = serial;
            return this;
        }

        public LongGraphBuilder directed(boolean directed) {
            this.directed = directed;
            return this;
        }

        public LongGraphBuilder backedByVector(boolean backedByVector) {
            this.backedByVector = backedByVector;
            return this;
        }

        public <N extends GObject> LongGraph<N> create() {
            ObjectGraphBuilder builder = new ObjectGraphBuilder();
            ObjectGraph objectGraph = builder.directed(this.directed).serial(this.serial).backedByVector(this.backedByVector).create();
            return new ObjectGraphToLongGraphAdapter(objectGraph);
        }
    }

    public static class ObjectGraphBuilder {
        boolean serial = false;
        boolean directed = false;
        boolean backedByVector = false;

        public ObjectGraphBuilder serial(boolean serial) {
            this.serial = serial;
            return this;
        }

        public ObjectGraphBuilder directed(boolean directed) {
            this.directed = directed;
            return this;
        }

        public ObjectGraphBuilder backedByVector(boolean backedByVector) {
            this.backedByVector = backedByVector;
            return this;
        }

        public <N extends GObject, E> ObjectGraph<N, E> create() {
            ObjectGraph retval = this.serial || GaloisRuntime.getRuntime().useSerial() ? (this.backedByVector ? new SerialVectorMorphObjectGraph(this.directed) : new SerialHashMorphObjectGraph(this.directed)) : (this.backedByVector ? new VectorMorphObjectGraph(this.directed) : new HashMorphObjectGraph(this.directed));
            if (GaloisRuntime.getRuntime().ignoreUserFlags()) {
                retval = new ObjectGraphToAllObjectGraphAdapter(retval);
            }
            return retval;
        }
    }

    public static class VoidGraphBuilder {
        boolean serial = false;
        boolean directed = false;
        boolean backedByVector = false;

        public VoidGraphBuilder serial(boolean serial) {
            this.serial = serial;
            return this;
        }

        public VoidGraphBuilder directed(boolean directed) {
            this.directed = directed;
            return this;
        }

        public VoidGraphBuilder backedByVector(boolean backedByVector) {
            this.backedByVector = backedByVector;
            return this;
        }

        public <N extends GObject> Graph<N> create() {
            ObjectGraphBuilder builder = new ObjectGraphBuilder();
            ObjectGraph objectGraph = builder.directed(this.directed).serial(this.serial).backedByVector(this.backedByVector).create();
            return new ObjectGraphToVoidGraphAdapter(objectGraph);
        }
    }
}

