/*
 * Decompiled with CFR 0.152.
 */
package galois.objects.graph;

import galois.objects.GObject;
import galois.objects.graph.ConcurrentGNode;
import galois.objects.graph.DoubleGraph;
import galois.objects.graph.DoubleGraphToObjectGraphAdapter;
import galois.objects.graph.FloatGraph;
import galois.objects.graph.FloatGraphToObjectGraphAdapter;
import galois.objects.graph.GNode;
import galois.objects.graph.Graph;
import galois.objects.graph.IntGraph;
import galois.objects.graph.IntGraphToObjectGraphAdapter;
import galois.objects.graph.LongGraph;
import galois.objects.graph.LongGraphToObjectGraphAdapter;
import galois.objects.graph.ObjectGraph;
import galois.objects.graph.ObjectGraphToAllObjectGraphAdapter;
import galois.objects.graph.ObjectGraphToDoubleGraphAdapter;
import galois.objects.graph.ObjectGraphToFloatGraphAdapter;
import galois.objects.graph.ObjectGraphToIntGraphAdapter;
import galois.objects.graph.ObjectGraphToLongGraphAdapter;
import galois.objects.graph.ObjectGraphToVoidGraphAdapter;
import galois.objects.graph.SerialLocalComputationObjectGraph;
import galois.objects.graph.VoidGraphToObjectGraphAdapter;
import galois.runtime.Callback;
import galois.runtime.GaloisRuntime;
import galois.runtime.Iteration;
import galois.runtime.IterationAbortException;
import galois.runtime.MapInternalContext;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import util.fn.Lambda2Void;
import util.fn.Lambda3Void;
import util.fn.LambdaVoid;

public final class LocalComputationGraph<N extends GObject, E>
implements ObjectGraph<N, E> {
    private static final int chunkSize = 2 * GaloisRuntime.getRuntime().getMaxThreads();
    private final AtomicInteger mapCur;
    private Node[] nodes;
    private E[] edgeData;
    private int[] inIdx;
    private int[] ins;
    private int[] outIdx;
    private int[] outs;

    LocalComputationGraph(ObjectGraph<N, E> in) {
        this.createGraph(in);
        this.mapCur = new AtomicInteger();
    }

    private void createGraph(final ObjectGraph<N, E> g) {
        int numNodes = g.size();
        this.nodes = new Node[numNodes];
        final GNode[] rnodes = new GNode[numNodes];
        final TObjectIntHashMap nodeMap = new TObjectIntHashMap();
        g.map(new LambdaVoid<GNode<N>>(){

            @Override
            public void call(GNode<N> node) {
                int idx = nodeMap.size();
                nodeMap.put(node, idx);
                ((LocalComputationGraph)LocalComputationGraph.this).nodes[idx] = new Node(LocalComputationGraph.this, idx, (GObject)node.getData());
                rnodes[idx] = node;
            }
        });
        TIntArrayList inIdx = new TIntArrayList();
        final TIntArrayList ins = new TIntArrayList();
        TIntArrayList outIdx = new TIntArrayList();
        final TIntArrayList outs = new TIntArrayList();
        final ArrayList edgeData = new ArrayList();
        inIdx.add(0);
        outIdx.add(0);
        int i = 0;
        while (i < numNodes) {
            final GNode src = rnodes[i];
            g.mapInNeighbors(src, new LambdaVoid<GNode<N>>(){

                @Override
                public void call(GNode<N> dst) {
                    ins.add(nodeMap.get(dst));
                }
            });
            inIdx.add(ins.size());
            src.map(new LambdaVoid<GNode<N>>(){

                @Override
                public void call(GNode<N> dst) {
                    outs.add(nodeMap.get(dst));
                    edgeData.add(g.getEdgeData(src, dst));
                }
            });
            outIdx.add(outs.size());
            ++i;
        }
        this.inIdx = inIdx.toArray();
        this.ins = ins.toArray();
        this.outIdx = outIdx.toArray();
        this.outs = outs.toArray();
        this.edgeData = edgeData.toArray();
    }

    private int getId(GNode n) {
        return ((Node)n).id;
    }

    static void acquire(GNode node, byte flags) {
        Iteration.acquire(node, flags);
    }

    private static void acquireAll(byte flags) {
        if (GaloisRuntime.needMethodFlag(flags, (byte)1)) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public GNode<N> createNode(N n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GNode<N> createNode(N n, byte flags) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(GNode<N> src) {
        return this.add(src, (byte)-1);
    }

    @Override
    public boolean add(GNode<N> src, byte flags) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(GNode<N> src) {
        return this.remove(src, (byte)-1);
    }

    @Override
    public boolean remove(GNode<N> src, byte flags) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(GNode<N> src) {
        return this.contains(src, (byte)-1);
    }

    @Override
    public boolean contains(GNode<N> src, byte flags) {
        LocalComputationGraph.acquire(src, flags);
        int idx = this.getId(src);
        return idx >= 0 && idx < this.nodes.length;
    }

    @Override
    public int size() {
        return this.size((byte)-1);
    }

    @Override
    public int size(byte flags) {
        LocalComputationGraph.acquireAll(flags);
        return this.nodes.length;
    }

    @Override
    public boolean addNeighbor(GNode<N> src, GNode<N> dst) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addNeighbor(GNode<N> src, GNode<N> dst, byte flags) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeNeighbor(GNode<N> src, GNode<N> dst) {
        return this.removeNeighbor(src, dst, (byte)-1);
    }

    @Override
    public boolean removeNeighbor(GNode<N> src, GNode<N> dst, byte flags) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNeighbor(GNode<N> src, GNode<N> dst) {
        return this.hasNeighbor(src, dst, (byte)-1);
    }

    private boolean hasNeighbor(GNode<N> src, GNode<N> dst, int[] adjIdx, int[] adj) {
        int idx = this.getId(src);
        int target = this.getId(dst);
        int start = adjIdx[idx];
        int end = adjIdx[idx + 1];
        int i = start;
        while (i < end) {
            if (adj[i] == target) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean hasNeighbor(GNode<N> src, GNode<N> dst, byte flags) {
        LocalComputationGraph.acquire(src, flags);
        LocalComputationGraph.acquire(dst, flags);
        return this.hasNeighbor(src, dst, this.inIdx, this.ins) || this.hasNeighbor(src, dst, this.outIdx, this.outs);
    }

    void acquireNeighbors(GNode<N> src, int[] adjIdx, int[] adj, byte flags) {
        Iteration it = Iteration.acquire(src, flags);
        if (it != null) {
            int idx = this.getId(src);
            int start = adjIdx[idx];
            int end = adjIdx[idx + 1];
            int i = start;
            while (i < end) {
                Node other = this.nodes[adj[i]];
                it.acquire(other);
                ++i;
            }
        }
    }

    void mapNeighbor(int[] adjIdx, int[] adj, GNode<N> src, LambdaVoid<GNode<N>> body) {
        int idx = this.getId(src);
        int start = adjIdx[idx];
        int end = adjIdx[idx + 1];
        int i = start;
        while (i < end) {
            Node other = this.nodes[adj[i]];
            body.call(other);
            ++i;
        }
    }

    @Override
    public void mapInNeighbors(GNode<N> src, LambdaVoid<GNode<N>> body) {
        this.mapInNeighbors(src, body, (byte)-1);
    }

    @Override
    public void mapInNeighbors(GNode<N> src, LambdaVoid<GNode<N>> body, byte flags) {
        this.acquireNeighbors(src, this.inIdx, this.ins, flags);
        this.mapNeighbor(this.inIdx, this.ins, src, body);
    }

    private int neighborsSize(GNode<N> src, int[] adjIdx, int[] adj) {
        int idx = this.getId(src);
        int start = adjIdx[idx];
        int end = adjIdx[idx + 1];
        return end - start;
    }

    @Override
    public int inNeighborsSize(GNode<N> src) {
        return this.inNeighborsSize(src, (byte)-1);
    }

    @Override
    public int inNeighborsSize(GNode<N> src, byte flags) {
        this.acquireNeighbors(src, this.inIdx, this.ins, flags);
        return this.neighborsSize(src, this.inIdx, this.ins);
    }

    @Override
    public int outNeighborsSize(GNode<N> src) {
        return this.outNeighborsSize(src, (byte)-1);
    }

    @Override
    public int outNeighborsSize(GNode<N> src, byte flags) {
        this.acquireNeighbors(src, this.outIdx, this.outs, flags);
        return this.neighborsSize(src, this.outIdx, this.outs);
    }

    @Override
    public boolean addEdge(GNode<N> src, GNode<N> dst, E data) {
        return this.addEdge(src, dst, data, (byte)-1);
    }

    @Override
    public boolean addEdge(GNode<N> src, GNode<N> dst, E data, byte flags) {
        throw new UnsupportedOperationException();
    }

    private int getEdgeIdx(GNode<N> src, GNode<N> dst) {
        int idx = this.getId(src);
        int target = this.getId(dst);
        int start = this.outIdx[idx];
        int end = this.outIdx[idx + 1];
        int i = start;
        while (i < end) {
            if (this.outs[i] == target) {
                return i;
            }
            ++i;
        }
        throw new Error("No such edge");
    }

    @Override
    public E getEdgeData(GNode<N> src, GNode<N> dst) {
        return this.getEdgeData(src, dst, (byte)-1);
    }

    @Override
    public E getEdgeData(GNode<N> src, GNode<N> dst, byte flags) {
        return this.getEdgeData(src, dst, flags, flags);
    }

    @Override
    public E getEdgeData(GNode<N> src, GNode<N> dst, byte edgeFlags, byte dataFlags) {
        LocalComputationGraph.acquire(src, edgeFlags);
        LocalComputationGraph.acquire(dst, edgeFlags);
        E retval = this.edgeData[this.getEdgeIdx(src, dst)];
        if (GaloisRuntime.needMethodFlag(dataFlags, (byte)3)) {
            ((GObject)retval).access(dataFlags);
        }
        return retval;
    }

    @Override
    public E setEdgeData(GNode<N> src, GNode<N> dst, E d) {
        return this.setEdgeData(src, dst, d, (byte)-1);
    }

    @Override
    public E setEdgeData(final GNode<N> src, final GNode<N> dst, E data, byte flags) {
        LocalComputationGraph.acquire(src, flags);
        LocalComputationGraph.acquire(dst, flags);
        int idx = this.getEdgeIdx(src, dst);
        final E oldData = this.edgeData[idx];
        if (oldData != data) {
            this.edgeData[idx] = data;
            if (GaloisRuntime.needMethodFlag(flags, (byte)2)) {
                GaloisRuntime.getRuntime().onUndo(Iteration.getCurrentIteration(), new Callback(){

                    @Override
                    public void call() {
                        LocalComputationGraph.this.setEdgeData(src, dst, oldData, (byte)0);
                    }
                });
            }
        }
        return oldData;
    }

    @Override
    public boolean isDirected() {
        return true;
    }

    @Override
    public void mapInternal(LambdaVoid<GNode<N>> body, MapInternalContext ctx) {
        int size = this.nodes.length;
        int i = this.mapCur.getAndAdd(chunkSize);
        while (i < size) {
            int j = 0;
            while (j < chunkSize) {
                int index = i + j;
                if (index >= size) break;
                while (true) {
                    try {
                        Node item = this.nodes[index];
                        ctx.begin();
                        body.call(item);
                        ctx.commit(item);
                    }
                    catch (IterationAbortException iae) {
                        ctx.abort();
                        continue;
                    }
                    break;
                }
                ++j;
            }
            i = this.mapCur.getAndAdd(chunkSize);
        }
    }

    @Override
    public <A1> void mapInternal(Lambda2Void<GNode<N>, A1> body, MapInternalContext ctx, A1 arg1) {
        int size = this.nodes.length;
        int i = this.mapCur.getAndAdd(chunkSize);
        while (i < size) {
            int j = 0;
            while (j < chunkSize) {
                int index = i + j;
                if (index >= size) break;
                while (true) {
                    try {
                        Node item = this.nodes[index];
                        ctx.begin();
                        body.call(item, arg1);
                        ctx.commit(item);
                    }
                    catch (IterationAbortException iae) {
                        ctx.abort();
                        continue;
                    }
                    break;
                }
                ++j;
            }
            i = this.mapCur.getAndAdd(chunkSize);
        }
    }

    @Override
    public <A1, A2> void mapInternal(Lambda3Void<GNode<N>, A1, A2> body, MapInternalContext ctx, A1 arg1, A2 arg2) {
        int size = this.nodes.length;
        int i = this.mapCur.getAndAdd(chunkSize);
        while (i < size) {
            int j = 0;
            while (j < chunkSize) {
                int index = i + j;
                if (index >= size) break;
                while (true) {
                    try {
                        Node item = this.nodes[index];
                        ctx.begin();
                        body.call(item, arg1, arg2);
                        ctx.commit(item);
                    }
                    catch (IterationAbortException iae) {
                        ctx.abort();
                        continue;
                    }
                    break;
                }
                ++j;
            }
            i = this.mapCur.getAndAdd(chunkSize);
        }
    }

    @Override
    public void mapInternalDone() {
        this.mapCur.set(0);
    }

    @Override
    public void map(LambdaVoid<GNode<N>> body) {
        this.map(body, (byte)-1);
    }

    @Override
    public void map(LambdaVoid<GNode<N>> body, byte flags) {
        LocalComputationGraph.acquireAll(flags);
        int i = 0;
        while (i < this.nodes.length) {
            body.call(this.nodes[i]);
            ++i;
        }
    }

    @Override
    public <A1> void map(Lambda2Void<GNode<N>, A1> body, A1 arg1) {
        this.map(body, arg1, (byte)-1);
    }

    @Override
    public <A1> void map(Lambda2Void<GNode<N>, A1> body, A1 arg1, byte flags) {
        LocalComputationGraph.acquireAll(flags);
        int i = 0;
        while (i < this.nodes.length) {
            body.call(this.nodes[i], arg1);
            ++i;
        }
    }

    @Override
    public <A1, A2> void map(Lambda3Void<GNode<N>, A1, A2> body, A1 arg1, A2 arg2) {
        this.map(body, arg1, arg2, (byte)-1);
    }

    @Override
    public <A1, A2> void map(Lambda3Void<GNode<N>, A1, A2> body, A1 arg1, A2 arg2, byte flags) {
        LocalComputationGraph.acquireAll(flags);
        int i = 0;
        while (i < this.nodes.length) {
            body.call(this.nodes[i], arg1, arg2);
            ++i;
        }
    }

    @Override
    public void access(byte flags) {
    }

    public static class DoubleGraphBuilder {
        private boolean serial = false;
        private ObjectGraph in;

        public DoubleGraphBuilder serial(boolean serial) {
            this.serial = serial;
            return this;
        }

        public <N extends GObject> DoubleGraphBuilder from(DoubleGraph<N> in) {
            this.in = new DoubleGraphToObjectGraphAdapter<N>(in);
            return this;
        }

        public <N extends GObject> DoubleGraph<N> create() {
            return new ObjectGraphToDoubleGraphAdapter(new ObjectGraphBuilder().serial(this.serial).from(this.in).create());
        }
    }

    public static class FloatGraphBuilder {
        private boolean serial = false;
        private ObjectGraph in;

        public FloatGraphBuilder serial(boolean serial) {
            this.serial = serial;
            return this;
        }

        public <N extends GObject> FloatGraphBuilder from(FloatGraph<N> in) {
            this.in = new FloatGraphToObjectGraphAdapter<N>(in);
            return this;
        }

        public <N extends GObject> FloatGraph<N> create() {
            return new ObjectGraphToFloatGraphAdapter(new ObjectGraphBuilder().serial(this.serial).from(this.in).create());
        }
    }

    public static class IntGraphBuilder {
        private boolean serial = false;
        private ObjectGraph in;

        public IntGraphBuilder serial(boolean serial) {
            this.serial = serial;
            return this;
        }

        public <N extends GObject> IntGraphBuilder from(IntGraph<N> in) {
            this.in = new IntGraphToObjectGraphAdapter<N>(in);
            return this;
        }

        public <N extends GObject> IntGraph<N> create() {
            return new ObjectGraphToIntGraphAdapter(new ObjectGraphBuilder().serial(this.serial).from(this.in).create());
        }
    }

    public static class LongGraphBuilder {
        private boolean serial = false;
        private ObjectGraph in;

        public LongGraphBuilder serial(boolean serial) {
            this.serial = serial;
            return this;
        }

        public <N extends GObject> LongGraphBuilder from(LongGraph<N> in) {
            this.in = new LongGraphToObjectGraphAdapter<N>(in);
            return this;
        }

        public <N extends GObject> LongGraph<N> create() {
            return new ObjectGraphToLongGraphAdapter(new ObjectGraphBuilder().serial(this.serial).from(this.in).create());
        }
    }

    private static final class Node
    extends ConcurrentGNode<N> {
        private final int id;
        private N data;
        final /* synthetic */ LocalComputationGraph this$0;

        private Node(int id, N data) {
            this.this$0 = var1_1;
            this.id = id;
            this.data = data;
        }

        @Override
        public N getData() {
            return this.getData((byte)-1);
        }

        @Override
        public N getData(byte flags) {
            return this.getData(flags, flags);
        }

        @Override
        public N getData(byte nodeFlags, byte dataFlags) {
            LocalComputationGraph.acquire(this, nodeFlags);
            if (GaloisRuntime.needMethodFlag(dataFlags, (byte)3)) {
                this.data.access(dataFlags);
            }
            return this.data;
        }

        @Override
        public N setData(N data) {
            return this.setData((N)data, (byte)-1);
        }

        @Override
        public N setData(N data, byte flags) {
            LocalComputationGraph.acquire(this, flags);
            Object oldData = this.data;
            if (oldData != data) {
                this.data = data;
                if (GaloisRuntime.needMethodFlag(flags, (byte)2)) {
                    GaloisRuntime.getRuntime().onUndo(Iteration.getCurrentIteration(), new Callback((GObject)oldData){
                        private final /* synthetic */ GObject val$oldData;
                        {
                            this.val$oldData = gObject;
                        }

                        @Override
                        public void call() {
                            Node.this.setData(this.val$oldData, (byte)0);
                        }
                    });
                }
            }
            return oldData;
        }

        @Override
        public void mapInternal(LambdaVoid<GNode<N>> body, MapInternalContext ctx) {
            int idx = this.this$0.getId(this);
            int startIdx = this.this$0.outIdx[idx];
            int endIdx = this.this$0.outIdx[idx + 1];
            int size = endIdx - startIdx;
            int i = this.this$0.mapCur.getAndAdd(chunkSize);
            while (i < size) {
                int j = 0;
                while (j < chunkSize) {
                    int index = i + j;
                    if (index >= size) break;
                    while (true) {
                        try {
                            Node item = this.this$0.nodes[this.this$0.outs[startIdx + index]];
                            ctx.begin();
                            body.call(item);
                            ctx.commit(item);
                        }
                        catch (IterationAbortException iae) {
                            ctx.abort();
                            continue;
                        }
                        break;
                    }
                    ++j;
                }
                i = this.this$0.mapCur.getAndAdd(chunkSize);
            }
        }

        @Override
        public <A1> void mapInternal(Lambda2Void<GNode<N>, A1> body, MapInternalContext ctx, A1 arg1) {
            int idx = this.this$0.getId(this);
            int startIdx = this.this$0.outIdx[idx];
            int endIdx = this.this$0.outIdx[idx + 1];
            int size = endIdx - startIdx;
            int i = this.this$0.mapCur.getAndAdd(chunkSize);
            while (i < size) {
                int j = 0;
                while (j < chunkSize) {
                    int index = i + j;
                    if (index >= size) break;
                    while (true) {
                        try {
                            Node item = this.this$0.nodes[this.this$0.outs[startIdx + index]];
                            ctx.begin();
                            body.call(item, arg1);
                            ctx.commit(item);
                        }
                        catch (IterationAbortException iae) {
                            ctx.abort();
                            continue;
                        }
                        break;
                    }
                    ++j;
                }
                i = this.this$0.mapCur.getAndAdd(chunkSize);
            }
        }

        @Override
        public <A1, A2> void mapInternal(Lambda3Void<GNode<N>, A1, A2> body, MapInternalContext ctx, A1 arg1, A2 arg2) {
            int idx = this.this$0.getId(this);
            int startIdx = this.this$0.outIdx[idx];
            int endIdx = this.this$0.outIdx[idx + 1];
            int size = endIdx - startIdx;
            int i = this.this$0.mapCur.getAndAdd(chunkSize);
            while (i < size) {
                int j = 0;
                while (j < chunkSize) {
                    int index = i + j;
                    if (index >= size) break;
                    while (true) {
                        try {
                            Node item = this.this$0.nodes[this.this$0.outs[startIdx + index]];
                            ctx.begin();
                            body.call(item, arg1, arg2);
                            ctx.commit(item);
                        }
                        catch (IterationAbortException iae) {
                            ctx.abort();
                            continue;
                        }
                        break;
                    }
                    ++j;
                }
                i = this.this$0.mapCur.getAndAdd(chunkSize);
            }
        }

        @Override
        public void mapInternalDone() {
            this.this$0.mapCur.set(0);
        }

        @Override
        public void map(LambdaVoid<GNode<N>> body) {
            this.map(body, (byte)-1);
        }

        @Override
        public void map(LambdaVoid<GNode<N>> body, byte flags) {
            this.this$0.acquireNeighbors(this, this.this$0.outIdx, this.this$0.outs, flags);
            this.this$0.mapNeighbor(this.this$0.outIdx, this.this$0.outs, this, body);
        }

        @Override
        public <A1> void map(Lambda2Void<GNode<N>, A1> body, A1 arg1) {
            this.map(body, arg1, (byte)-1);
        }

        @Override
        public <A1> void map(Lambda2Void<GNode<N>, A1> body, A1 arg1, byte flags) {
            this.this$0.acquireNeighbors(this, this.this$0.outIdx, this.this$0.outs, flags);
            int idx = this.this$0.getId(this);
            int start = this.this$0.outIdx[idx];
            int end = this.this$0.outIdx[idx + 1];
            int i = start;
            while (i < end) {
                Node other = this.this$0.nodes[this.this$0.outs[i]];
                body.call(other, arg1);
                ++i;
            }
        }

        @Override
        public <A1, A2> void map(Lambda3Void<GNode<N>, A1, A2> body, A1 arg1, A2 arg2) {
            this.map(body, arg1, arg2, (byte)-1);
        }

        @Override
        public <A1, A2> void map(Lambda3Void<GNode<N>, A1, A2> body, A1 arg1, A2 arg2, byte flags) {
            this.this$0.acquireNeighbors(this, this.this$0.outIdx, this.this$0.outs, flags);
            int idx = this.this$0.getId(this);
            int start = this.this$0.outIdx[idx];
            int end = this.this$0.outIdx[idx + 1];
            int i = start;
            while (i < end) {
                Node other = this.this$0.nodes[this.this$0.outs[i]];
                body.call(other, arg1, arg2);
                ++i;
            }
        }
    }

    public static class ObjectGraphBuilder {
        private boolean serial = false;
        private ObjectGraph in;

        public ObjectGraphBuilder serial(boolean serial) {
            this.serial = serial;
            return this;
        }

        public ObjectGraphBuilder from(ObjectGraph in) {
            this.in = in;
            return this;
        }

        public <N extends GObject, E> ObjectGraph<N, E> create() {
            ObjectGraph retval = this.serial || GaloisRuntime.getRuntime().useSerial() ? new SerialLocalComputationObjectGraph(this.in) : new LocalComputationGraph(this.in);
            if (GaloisRuntime.getRuntime().ignoreUserFlags()) {
                retval = new ObjectGraphToAllObjectGraphAdapter(retval);
            }
            return retval;
        }
    }

    public static class VoidGraphBuilder {
        private boolean serial = false;
        private Graph in;

        public VoidGraphBuilder serial(boolean serial) {
            this.serial = serial;
            return this;
        }

        public VoidGraphBuilder from(Graph in) {
            this.in = in;
            return this;
        }

        public <N extends GObject> Graph<N> create() {
            return new ObjectGraphToVoidGraphAdapter(new ObjectGraphBuilder().serial(this.serial).from(new VoidGraphToObjectGraphAdapter(this.in)).create());
        }
    }
}

