/*
 * Decompiled with CFR 0.152.
 */
package galois.objects.graph;

import galois.objects.GObject;
import galois.objects.graph.GNode;
import galois.objects.graph.Graph;
import galois.runtime.Callback;
import galois.runtime.GaloisRuntime;
import galois.runtime.Iteration;
import java.util.ArrayList;
import java.util.Collection;
import util.fn.Lambda2Void;
import util.fn.LambdaVoid;

class GraphLocker {
    static final LockLambda2 lock2 = new LockLambda2();
    static final InNeighborsLambda2 inNeighbors2 = new InNeighborsLambda2();
    static final LockLambda lock = new LockLambda();

    GraphLocker() {
    }

    static <N extends GObject> void createNodeEpilog(GNode<N> src, byte flags) {
        GraphLocker.acquireLock(src, flags);
    }

    static <N extends GObject> void addNodeProlog(GNode<N> src, byte flags) {
        GraphLocker.acquireLock(src, flags);
    }

    static <N extends GObject> void addNodeEpilog(final Graph<N> graph, final GNode<N> src, byte flags) {
        if (GaloisRuntime.needMethodFlag(flags, (byte)2)) {
            GaloisRuntime.getRuntime().onUndo(Iteration.getCurrentIteration(), new Callback(){

                @Override
                public void call() {
                    graph.remove(src, (byte)0);
                }
            });
        }
    }

    static <N extends GObject> void containsNodeProlog(GNode<N> src, byte flags) {
        GraphLocker.acquireLock(src, flags);
    }

    static void mapProlog(byte flags) {
        GraphLocker.acquireLockOnAll(flags);
    }

    static void sizeProlog(byte flags) {
        GraphLocker.acquireLockOnAll(flags);
    }

    static <N extends GObject> void getNodeDataProlog(GNode<N> src, byte flags) {
        GraphLocker.acquireLock(src, flags);
    }

    static <N extends GObject> void getNodeDataEpilog(N data, byte flags) {
        if (GaloisRuntime.needMethodFlag(flags, (byte)3)) {
            data.access(flags);
        }
    }

    static <N extends GObject> void setNodeDataProlog(GNode<N> src, byte flags) {
        GraphLocker.acquireLock(src, flags);
    }

    static <N extends GObject> void setNodeDataEpilog(final GNode<N> src, final N data, byte flags) {
        if (GaloisRuntime.needMethodFlag(flags, (byte)2)) {
            GaloisRuntime.getRuntime().onUndo(Iteration.getCurrentIteration(), new Callback(){

                @Override
                public void call() {
                    src.setData(data, (byte)0);
                }
            });
        }
    }

    static <N extends GObject> void acquireLock(GNode<N> src, byte flags) {
        Iteration.acquire(src, flags);
    }

    static <N extends GObject> void acquireLock(GNode<N> src, GNode<N> dst, byte flags) {
        Iteration it = Iteration.acquire(src, flags);
        if (it != null) {
            it.acquire(dst);
        }
    }

    static void acquireLockOnAll(byte flags) {
        if (GaloisRuntime.needMethodFlag(flags, (byte)1)) {
            throw new Error("no globals");
        }
    }

    static <N extends GObject> void removeNodeProlog(final Graph<N> graph, final GNode<N> src, byte flags) {
        if (GaloisRuntime.needMethodFlag(flags, (byte)1)) {
            graph.mapInNeighbors(src, lock, (byte)0);
            if (graph.isDirected()) {
                src.map(lock2, Iteration.getCurrentIteration(), (byte)0);
            }
        }
        if (!GaloisRuntime.needMethodFlag(flags, (byte)2)) {
            return;
        }
        final ArrayList neighbors = new ArrayList();
        src.map(inNeighbors2, neighbors, (byte)0);
        if (graph.isDirected()) {
            graph.mapInNeighbors(src, new InNeighborsLambda(neighbors), (byte)0);
        }
        GaloisRuntime.getRuntime().onUndo(Iteration.getCurrentIteration(), new Callback(){

            @Override
            public void call() {
                graph.add(src, (byte)0);
                for (GNode e : neighbors) {
                    graph.addNeighbor(src, e, (byte)0);
                }
            }
        });
    }

    static <N extends GObject> void removeNeighborProlog(GNode<N> src, GNode<N> dst, byte flags) {
        GraphLocker.acquireLock(src, dst, flags);
    }

    static <N extends GObject> void removeNeighborEpilog(final Graph<N> graph, final GNode<N> src, final GNode<N> dst, byte flags) {
        if (GaloisRuntime.needMethodFlag(flags, (byte)2)) {
            GaloisRuntime.getRuntime().onUndo(Iteration.getCurrentIteration(), new Callback(){

                @Override
                public void call() {
                    graph.addNeighbor(src, dst, (byte)0);
                }
            });
        }
    }

    static <N extends GObject> void addNeighborEpilog(final Graph<N> graph, final GNode<N> src, final GNode<N> dst, byte flags) {
        if (GaloisRuntime.needMethodFlag(flags, (byte)2)) {
            GaloisRuntime.getRuntime().onUndo(Iteration.getCurrentIteration(), new Callback(){

                @Override
                public void call() {
                    graph.removeNeighbor(src, dst, (byte)0);
                }
            });
        }
    }

    static <N extends GObject> void hasNeighborProlog(GNode<N> src, GNode<N> dst, byte flags) {
        GraphLocker.acquireLock(src, dst, flags);
    }

    static <N extends GObject> void mapInNeighborsProlog(Graph<N> graph, GNode<N> src, byte flags) {
        GraphLocker.acquireLockOnNodeAndInNeighbors(graph, src, flags);
    }

    static <N extends GObject> void inNeighborsSizeProlog(Graph<N> graph, GNode<N> src, byte flags) {
        GraphLocker.acquireLockOnNodeAndInNeighbors(graph, src, flags);
    }

    static <N extends GObject> void mapOutNeighborsProlog(GNode<N> src, byte flags) {
        GraphLocker.acquireLockOnNodeAndOutNeighbors(src, flags);
    }

    static <N extends GObject> void outNeighborsSizeProlog(GNode<N> src, byte flags) {
        GraphLocker.acquireLockOnNodeAndOutNeighbors(src, flags);
    }

    static <N extends GObject> void acquireLockOnNodeAndInNeighbors(Graph<N> graph, GNode<N> n, byte flags) {
        Iteration it = Iteration.acquire(n, flags);
        if (it != null) {
            graph.mapInNeighbors(n, lock, (byte)0);
        }
    }

    static <N extends GObject> void acquireLockOnNodeAndOutNeighbors(GNode<N> n, byte flags) {
        Iteration it = Iteration.acquire(n, flags);
        if (it != null) {
            n.map(lock2, it, (byte)0);
        }
    }

    private static class InNeighborsLambda<N extends GObject>
    implements LambdaVoid<GNode<N>> {
        private Collection<GNode<N>> bag;

        public InNeighborsLambda(Collection<GNode<N>> bag) {
            this.bag = bag;
        }

        @Override
        public void call(GNode<N> arg0) {
            this.bag.add(arg0);
        }
    }

    private static class InNeighborsLambda2<N extends GObject>
    implements Lambda2Void<GNode<N>, Collection<GNode<N>>> {
        private InNeighborsLambda2() {
        }

        @Override
        public void call(GNode<N> arg0, Collection<GNode<N>> bag) {
            bag.add(arg0);
        }
    }

    private static class LockLambda<N extends GObject>
    implements LambdaVoid<GNode<N>> {
        private LockLambda() {
        }

        @Override
        public void call(GNode<N> arg0) {
            GraphLocker.acquireLock(arg0, (byte)1);
        }
    }

    private static class LockLambda2<N extends GObject>
    implements Lambda2Void<GNode<N>, Iteration> {
        private LockLambda2() {
        }

        @Override
        public void call(GNode<N> arg0, Iteration it) {
            it.acquire(arg0);
        }
    }
}

