/*
 * Decompiled with CFR 0.152.
 */
package galois.objects.graph;

import galois.objects.GObject;
import galois.objects.Mappable;
import galois.objects.Mappables;
import galois.objects.graph.GNode;
import galois.objects.graph.Graph;
import galois.objects.graph.ObjectGraph;
import galois.runtime.ForeachContext;
import galois.runtime.GaloisRuntime;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import util.Launcher;
import util.Pair;
import util.fn.Lambda;
import util.fn.Lambda2Void;
import util.fn.LambdaVoid;

public class GraphGenerator {
    private static final String PROBLEM = "p";
    private static final String ARC = "a";
    private static final String COMMENT = "c";
    private static final String FILE = "file";
    private static final String GRID = "grid";
    private static final String RAND = "rand";
    private static final int MAX_EDGE_WEIGHT = 1000;
    private static final String SPLIT_REGEX = "[ \t]+";

    private static <N extends GObject> List<GNode<N>> createNodes(Graph<N> graph, int numNodes, Lambda<Integer, N> nodeDataGenerator) {
        ArrayList<GNode<N>> nodes = new ArrayList<GNode<N>>();
        int i = 0;
        while (i < numNodes) {
            GObject nodeData = (GObject)nodeDataGenerator.call(i);
            GNode<GObject> gn = graph.createNode(nodeData);
            if (graph.add(gn)) {
                nodes.add(gn);
            }
            ++i;
        }
        return nodes;
    }

    private static <N extends GObject, E> void genGrid(ObjectGraph<N, E> graph, Lambda<Integer, N> nodeDataGen, Lambda<ForeachContext<?>, E> edgeDataGen, int rows, int cols) {
        List<GNode<N>> nodes = GraphGenerator.createNodes(graph, rows * cols, nodeDataGen);
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                ArrayList<GNode<N>> neighbors = new ArrayList<GNode<N>>();
                int index = GraphGenerator.getIndex(i + 1, j, rows, cols);
                if (index >= 0) {
                    neighbors.add(nodes.get(index));
                }
                if ((index = GraphGenerator.getIndex(i - 1, j, rows, cols)) >= 0) {
                    neighbors.add(nodes.get(index));
                }
                if ((index = GraphGenerator.getIndex(i, j + 1, rows, cols)) >= 0) {
                    neighbors.add(nodes.get(index));
                }
                if ((index = GraphGenerator.getIndex(i, j - 1, rows, cols)) >= 0) {
                    neighbors.add(nodes.get(index));
                }
                GNode<N> node = nodes.get(GraphGenerator.getIndex(i, j, rows, cols));
                for (GNode gNode : neighbors) {
                    E ed = edgeDataGen.call(null);
                    graph.addEdge(node, gNode, ed);
                }
                ++j;
            }
            ++i;
        }
    }

    public static <N extends GObject> void readIntegerEdgeGraph(String grPath, ObjectGraph<N, Integer> emptyGraph, Lambda<Integer, N> nodeDataGen) throws IOException {
        GraphGenerator.parseGrFile(emptyGraph, nodeDataGen, grPath);
        GraphGenerator.printMsg(emptyGraph);
    }

    public static <N extends GObject> String[] readIntegerEdgeGraph(String[] args, ObjectGraph<N, Integer> emptyGraph, Lambda<Integer, N> nodeDataGen) throws IOException {
        final Random rand = Launcher.getLauncher().getRandom(1000);
        Lambda edgeDataGen = new Lambda<ForeachContext<?>, Integer>(){

            @Override
            public Integer call(ForeachContext<?> ctx) {
                return rand.nextInt(1000);
            }
        };
        String type = args[0];
        int start = 0;
        if (type.equals(RAND)) {
            int numNodes = Integer.parseInt(args[1]);
            int minDegree = Integer.parseInt(args[2]);
            int maxDegree = Integer.parseInt(args[3]);
            GraphGenerator.randGraph(emptyGraph, nodeDataGen, edgeDataGen, numNodes, minDegree, maxDegree);
            start = 4;
        } else if (type.equals(GRID)) {
            int rows = Integer.parseInt(args[1]);
            int cols = Integer.parseInt(args[2]);
            GraphGenerator.genGrid(emptyGraph, nodeDataGen, edgeDataGen, rows, cols);
            start = 3;
        } else if (type.equals(FILE)) {
            String grPath = args[1];
            GraphGenerator.parseGrFile(emptyGraph, nodeDataGen, grPath);
            start = 2;
        } else {
            GraphGenerator.usage();
        }
        GraphGenerator.printMsg(emptyGraph);
        int length = args.length - start;
        String[] retval = new String[length];
        System.arraycopy(args, start, retval, 0, length);
        return retval;
    }

    private static int getIndex(int i, int j, int rows, int cols) {
        if (i < 0 || i >= rows || j < 0 || j >= cols) {
            return -1;
        }
        return cols * i + j;
    }

    private static Random getRandom(int numNodes) {
        return Launcher.getLauncher().getRandom(numNodes);
    }

    private static <N extends GObject> void parseGrFile(ObjectGraph<N, Integer> graph, Lambda<Integer, N> nodeDataGen, String filename) throws IOException {
        if (filename.endsWith(".chgr.gz")) {
            GraphGenerator.parseChunkedGrFile(graph, nodeDataGen, filename);
        } else {
            GraphGenerator.readGrLines(filename, graph, GraphGenerator.readFirstGrFile(graph, nodeDataGen, filename));
        }
    }

    private static Pair<Integer, String> parseChunkedGrFilename(String filename) {
        Pattern p = Pattern.compile("1-of-(\\d+)");
        Matcher m = p.matcher(filename);
        if (m.find()) {
            int max = Integer.parseInt(m.group(1));
            StringBuffer sb = new StringBuffer();
            m.appendReplacement(sb, "%d-of-" + max);
            m.appendTail(sb);
            return new Pair<Integer, String>(max, sb.toString());
        }
        throw new Error("unknown file type: " + filename);
    }

    private static <N extends GObject> void parseChunkedGrFile(final ObjectGraph<N, Integer> graph, Lambda<Integer, N> nodeDataGen, String filename) throws IOException {
        final List<GNode<N>> nodes = GraphGenerator.readFirstGrFile(graph, nodeDataGen, filename);
        Pair<Integer, String> result = GraphGenerator.parseChunkedGrFilename(filename);
        int max = result.getFirst();
        final String base = result.getSecond();
        Mappable<Pair<Integer, String>> product = Mappables.product(Mappables.range(1, max + 1, 1), new Lambda<Integer, Mappable<String>>(){

            @Override
            public Mappable<String> call(Integer index) {
                String filename = String.format(base, index);
                try {
                    return Mappables.fromReader(GraphGenerator.readFile(filename));
                }
                catch (FileNotFoundException e) {
                    throw new Error(e);
                }
                catch (IOException e) {
                    throw new Error(e);
                }
            }
        });
        try {
            GaloisRuntime.foreach(product, new LambdaVoid<Pair<Integer, String>>(){

                @Override
                public void call(Pair<Integer, String> pair) {
                    String line = pair.getSecond();
                    if (line.startsWith(GraphGenerator.ARC)) {
                        String[] words = line.split(GraphGenerator.SPLIT_REGEX);
                        int srcIndex = Integer.parseInt(words[1]) - 1;
                        int dstIndex = Integer.parseInt(words[2]) - 1;
                        int edgeWeight = Integer.parseInt(words[3]);
                        graph.addEdge((GNode)nodes.get(srcIndex), (GNode)nodes.get(dstIndex), edgeWeight);
                    } else if (!line.startsWith(GraphGenerator.COMMENT) && !line.startsWith(GraphGenerator.PROBLEM)) {
                        int index = pair.getFirst();
                        String filename = String.format(base, index);
                        throw new Error(String.format("unknown line in file %s", filename));
                    }
                }
            });
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
    }

    private static <N extends GObject> List<GNode<N>> readFirstGrFile(ObjectGraph<N, Integer> graph, Lambda<Integer, N> nodeDataGen, String filename) throws IOException {
        try (BufferedReader br = GraphGenerator.readFile(filename);){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.startsWith(PROBLEM)) break;
            }
            if (line == null) {
                throw new Error("could not find the problem line in " + filename);
            }
            String[] words = line.split(SPLIT_REGEX);
            int numNodes = Integer.parseInt(words[words.length - 2]);
            List<GNode<N>> list = GraphGenerator.createNodes(graph, numNodes, nodeDataGen);
            return list;
        }
    }

    private static BufferedReader readFile(String filename) throws FileNotFoundException, IOException {
        return new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(filename))));
    }

    private static <N extends GObject> void readGrLines(String filename, ObjectGraph<N, Integer> graph, List<GNode<N>> nodes) throws IOException {
        try (BufferedReader br = GraphGenerator.readFile(filename);){
            String line;
            int lineNo = 0;
            while ((line = br.readLine()) != null) {
                ++lineNo;
                if (line.startsWith(ARC)) {
                    String[] words = line.split(SPLIT_REGEX);
                    int srcIndex = Integer.parseInt(words[1]) - 1;
                    int dstIndex = Integer.parseInt(words[2]) - 1;
                    int edgeWeight = Integer.parseInt(words[3]);
                    graph.addEdge(nodes.get(srcIndex), nodes.get(dstIndex), edgeWeight);
                    continue;
                }
                if (line.startsWith(COMMENT) || line.startsWith(PROBLEM)) continue;
                throw new Error(String.format("unknown line in file %s line %d", filename, lineNo));
            }
        }
    }

    private static <N extends GObject> void printMsg(Graph<N> graph) {
        int numNodes = graph.size();
        DegreeSum dsum = new DegreeSum();
        graph.map(dsum, graph);
        int numEdges = dsum.sumOutDegree;
        if (!graph.isDirected()) {
            numEdges /= 2;
        }
        System.err.println("graph generated with nodes = " + numNodes + ", edges = " + numEdges);
    }

    private static <N extends GObject, E> void randGraph(ObjectGraph<N, E> graph, Lambda<Integer, N> nodeDataGen, Lambda<ForeachContext<?>, E> edgeDataGenerator, int numNodes, int minDegree, int maxDegree) {
        assert (minDegree <= maxDegree);
        List<GNode<N>> nodes = GraphGenerator.createNodes(graph, numNodes, nodeDataGen);
        Random rand = GraphGenerator.getRandom(numNodes);
        int deltaMax = maxDegree - minDegree;
        for (GNode<N> node : nodes) {
            int degree = deltaMax <= 0 ? minDegree : minDegree + rand.nextInt(deltaMax);
            int i = graph.outNeighborsSize(node);
            while (i < degree) {
                GNode<N> m = nodes.get(rand.nextInt(numNodes));
                if (node == m || graph.hasNeighbor(node, m)) continue;
                E edgeData = edgeDataGenerator.call(null);
                graph.addEdge(node, m, edgeData);
                ++i;
            }
        }
    }

    private static void usage() {
        System.err.println("Provide as Arguments: rand <num-nodes> <min-neighbors-number> <max-neighbors-number>");
        System.err.println("OR: grid <rows> <cols> ");
        System.err.println("OR: tree <num-nodes> <degree>");
        System.err.println("OR: file fileName.gr");
        System.exit(-1);
    }

    private static class DegreeSum<N extends GObject>
    implements Lambda2Void<GNode<N>, Graph<N>> {
        int sumOutDegree = 0;

        private DegreeSum() {
        }

        @Override
        public void call(GNode<N> node, Graph<N> graph) {
            this.sumOutDegree += graph.outNeighborsSize(node);
        }
    }
}

