/*
 * Decompiled with CFR 0.152.
 */
package galois.objects;

import galois.objects.LineMapper;
import galois.objects.Mappable;
import galois.objects.ProductMapper;
import galois.runtime.GaloisRuntime;
import galois.runtime.IterationAbortException;
import galois.runtime.MapInternalContext;
import java.io.BufferedReader;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import util.MutableInteger;
import util.Pair;
import util.fn.Lambda;
import util.fn.Lambda2Void;
import util.fn.Lambda3Void;
import util.fn.LambdaVoid;

public class Mappables {
    public static <A, B> Mappable<Pair<A, B>> product(Mappable<A> rows, Lambda<A, Mappable<B>> cols) {
        return new ProductMapper<A, B>(rows, cols);
    }

    public static Mappable<String> fromReader(BufferedReader reader) {
        return new LineMapper(reader);
    }

    public static Mappable<Integer> range(int start, int end) {
        int chunkSize = 2 * GaloisRuntime.getRuntime().getMaxThreads();
        return Mappables.range(start, end, chunkSize);
    }

    public static Mappable<Integer> range(int start, final int end, final int chunkSize) {
        final AtomicInteger cur = new AtomicInteger(start);
        final MutableInteger serialCur = new MutableInteger(start);
        return new Mappable<Integer>(){

            @Override
            public void mapInternal(LambdaVoid<Integer> body, MapInternalContext ctx) {
                int i = cur.getAndAdd(chunkSize);
                while (i < end) {
                    int j = 0;
                    while (j < chunkSize) {
                        int index = i + j;
                        if (index >= end) break;
                        while (true) {
                            try {
                                ctx.begin();
                                body.call(index);
                                ctx.commit(index);
                            }
                            catch (IterationAbortException iae) {
                                ctx.abort();
                                continue;
                            }
                            break;
                        }
                        ++j;
                    }
                    i = cur.getAndAdd(chunkSize);
                }
            }

            @Override
            public <A1> void mapInternal(Lambda2Void<Integer, A1> body, MapInternalContext ctx, A1 arg1) {
                int i = cur.getAndAdd(chunkSize);
                while (i < end) {
                    int j = 0;
                    while (j < chunkSize) {
                        int index = i + j;
                        if (index >= end) break;
                        while (true) {
                            try {
                                ctx.begin();
                                body.call(index, arg1);
                                ctx.commit(index);
                            }
                            catch (IterationAbortException iae) {
                                ctx.abort();
                                continue;
                            }
                            break;
                        }
                        ++j;
                    }
                    i = cur.getAndAdd(chunkSize);
                }
            }

            @Override
            public <A1, A2> void mapInternal(Lambda3Void<Integer, A1, A2> body, MapInternalContext ctx, A1 arg1, A2 arg2) {
                int i = cur.getAndAdd(chunkSize);
                while (i < end) {
                    int j = 0;
                    while (j < chunkSize) {
                        int index = i + j;
                        if (index >= end) break;
                        while (true) {
                            try {
                                ctx.begin();
                                body.call(index, arg1, arg2);
                                ctx.commit(index);
                            }
                            catch (IterationAbortException iae) {
                                ctx.abort();
                                continue;
                            }
                            break;
                        }
                        ++j;
                    }
                    i = cur.getAndAdd(chunkSize);
                }
            }

            @Override
            public void mapInternalDone() {
                cur.set(0);
            }

            @Override
            public final void map(LambdaVoid<Integer> body) {
                this.map(body, (byte)-1);
            }

            @Override
            public void map(LambdaVoid<Integer> body, byte flags) {
                int index = serialCur.getAndIncrement();
                while (index < end) {
                    body.call(index);
                    index = serialCur.getAndIncrement();
                }
            }

            @Override
            public final <A1> void map(Lambda2Void<Integer, A1> body, A1 arg1) {
                this.map(body, arg1, (byte)-1);
            }

            @Override
            public <A1> void map(Lambda2Void<Integer, A1> body, A1 arg1, byte flags) {
                int index = serialCur.getAndIncrement();
                while (index < end) {
                    body.call(index, arg1);
                    index = serialCur.getAndIncrement();
                }
            }

            @Override
            public final <A1, A2> void map(Lambda3Void<Integer, A1, A2> body, A1 arg1, A2 arg2) {
                this.map(body, arg1, arg2, (byte)-1);
            }

            @Override
            public <A1, A2> void map(Lambda3Void<Integer, A1, A2> body, A1 arg1, A2 arg2, byte flags) {
                int index = serialCur.getAndIncrement();
                while (index < end) {
                    body.call(index, arg1, arg2);
                    index = serialCur.getAndIncrement();
                }
            }
        };
    }

    public static <T> Mappable<T> fromList(final List<T> list) {
        final int size = list.size();
        final int chunkSize = 2 * GaloisRuntime.getRuntime().getMaxThreads();
        final AtomicInteger cur = new AtomicInteger();
        return new Mappable<T>(){

            @Override
            public void mapInternal(LambdaVoid<T> body, MapInternalContext ctx) {
                int i = cur.getAndAdd(chunkSize);
                while (i < size) {
                    int j = 0;
                    while (j < chunkSize) {
                        int index = i + j;
                        if (index >= size) break;
                        while (true) {
                            try {
                                Object item = list.get(index);
                                ctx.begin();
                                body.call(item);
                                ctx.commit(item);
                            }
                            catch (IterationAbortException iae) {
                                ctx.abort();
                                continue;
                            }
                            break;
                        }
                        ++j;
                    }
                    i = cur.getAndAdd(chunkSize);
                }
            }

            @Override
            public <A1> void mapInternal(Lambda2Void<T, A1> body, MapInternalContext ctx, A1 arg1) {
                int i = cur.getAndAdd(chunkSize);
                while (i < size) {
                    int j = 0;
                    while (j < chunkSize) {
                        int index = i + j;
                        if (index >= size) break;
                        while (true) {
                            try {
                                Object item = list.get(index);
                                ctx.begin();
                                body.call(item, arg1);
                                ctx.commit(item);
                            }
                            catch (IterationAbortException iae) {
                                ctx.abort();
                                continue;
                            }
                            break;
                        }
                        ++j;
                    }
                    i = cur.getAndAdd(chunkSize);
                }
            }

            @Override
            public <A1, A2> void mapInternal(Lambda3Void<T, A1, A2> body, MapInternalContext ctx, A1 arg1, A2 arg2) {
                int i = cur.getAndAdd(chunkSize);
                while (i < size) {
                    int j = 0;
                    while (j < chunkSize) {
                        int index = i + j;
                        if (index >= size) break;
                        while (true) {
                            try {
                                Object item = list.get(index);
                                ctx.begin();
                                body.call(item, arg1, arg2);
                                ctx.commit(item);
                            }
                            catch (IterationAbortException iae) {
                                ctx.abort();
                                continue;
                            }
                            break;
                        }
                        ++j;
                    }
                    i = cur.getAndAdd(chunkSize);
                }
            }

            @Override
            public final void map(LambdaVoid<T> body) {
                this.map(body, (byte)-1);
            }

            @Override
            public void map(LambdaVoid<T> body, byte flags) {
                int i = 0;
                while (i < size) {
                    body.call(list.get(i));
                    ++i;
                }
            }

            @Override
            public final <A1> void map(Lambda2Void<T, A1> body, A1 arg1) {
                this.map(body, arg1, (byte)-1);
            }

            @Override
            public <A1> void map(Lambda2Void<T, A1> body, A1 arg1, byte flags) {
                int i = 0;
                while (i < size) {
                    body.call(list.get(i), arg1);
                    ++i;
                }
            }

            @Override
            public final <A1, A2> void map(Lambda3Void<T, A1, A2> body, A1 arg1, A2 arg2) {
                this.map(body, arg1, arg2, (byte)-1);
            }

            @Override
            public <A1, A2> void map(Lambda3Void<T, A1, A2> body, A1 arg1, A2 arg2, byte flags) {
                int i = 0;
                while (i < size) {
                    body.call(list.get(i), arg1, arg2);
                    ++i;
                }
            }

            @Override
            public void mapInternalDone() {
                cur.set(0);
            }
        };
    }
}

