/*
 * Decompiled with CFR 0.152.
 */
package galois.objects;

import galois.objects.AbstractCounter;
import galois.objects.Counter;
import galois.runtime.Features;
import galois.runtime.ForeachContext;
import galois.runtime.GaloisRuntime;
import util.fn.LambdaVoid;

public class CounterToSuspendWithBuilder {
    public <T> Counter<T> create(int countTo, boolean exact, LambdaVoid<ForeachContext<T>> callback) {
        if (GaloisRuntime.getRuntime().useSerial()) {
            return new SerialCounterToSuspendWith<T>(countTo, exact, callback);
        }
        return new ConcurrentCounterToSuspendWith<T>(countTo, exact, callback);
    }

    private static class ConcurrentCounterToSuspendWith<T>
    extends AbstractCounter.AbstractConcurrentCounter<T> {
        private final LambdaVoid<ForeachContext<T>> callback;
        private final boolean exact;

        protected ConcurrentCounterToSuspendWith(int countTo, boolean exact, LambdaVoid<ForeachContext<T>> callback) {
            super(countTo);
            this.callback = callback;
            this.exact = exact;
            Features.getReplayFeature().registerCallback(this.getRid(), callback);
        }

        private boolean compare(int a, int b) {
            return this.exact ? a == b : a >= b;
        }

        @Override
        protected void body(ForeachContext<T> ctx, int delta) {
            if (!Features.getReplayFeature().isCallbackControlled() && this.compare(this.counterAddAndGet(delta), this.countTo)) {
                ctx.suspendWith(new MyCallback(ctx));
            }
        }

        private class MyCallback
        extends AbstractCounter.OnlyAddCallback {
            private MyCallback(ForeachContext<T> ctx) {
                super(ctx);
            }

            @Override
            public void call() {
                if (!ConcurrentCounterToSuspendWith.this.compare(ConcurrentCounterToSuspendWith.this.counterGet(), ConcurrentCounterToSuspendWith.this.countTo)) {
                    return;
                }
                ConcurrentCounterToSuspendWith.this.reset();
                Features.getReplayFeature().onCallbackExecute(this.getRid());
                ConcurrentCounterToSuspendWith.this.callback.call(this);
            }
        }
    }

    private static class SerialCounterToSuspendWith<T>
    extends AbstractCounter.AbstractSerialCounter<T> {
        private final LambdaVoid<ForeachContext<T>> callback;
        private final boolean exact;

        protected SerialCounterToSuspendWith(int countTo, boolean exact, LambdaVoid<ForeachContext<T>> callback) {
            super(countTo);
            this.callback = callback;
            this.exact = exact;
            Features.getReplayFeature().registerCallback(this.getRid(), callback);
        }

        private boolean compare(int a, int b) {
            return this.exact ? a == b : a >= b;
        }

        @Override
        protected void body(ForeachContext<T> ctx, int delta) {
            if (!Features.getReplayFeature().isCallbackControlled() && this.compare(this.counterAddAndGet(delta), this.countTo)) {
                ctx.suspendWith(new MyCallback(ctx));
            }
        }

        private class MyCallback
        extends AbstractCounter.OnlyAddCallback {
            private MyCallback(ForeachContext<T> ctx) {
                super(ctx);
            }

            @Override
            public void call() {
                if (!SerialCounterToSuspendWith.this.compare(SerialCounterToSuspendWith.this.counterGet(), SerialCounterToSuspendWith.this.countTo)) {
                    return;
                }
                SerialCounterToSuspendWith.this.reset();
                Features.getReplayFeature().onCallbackExecute(this.getRid());
                SerialCounterToSuspendWith.this.callback.call(this);
            }
        }
    }
}

