/*
 * Decompiled with CFR 0.152.
 */
package galois.objects;

import galois.objects.AbstractCounter;
import galois.objects.Counter;
import galois.runtime.ForeachContext;
import galois.runtime.GaloisRuntime;

public class CounterToFinishBuilder {
    public <T> Counter<T> create(int countTo) {
        if (GaloisRuntime.getRuntime().useSerial()) {
            return new SerialCounterToFinish(countTo);
        }
        return new ConcurrentCounterToFinish(countTo);
    }

    private static class ConcurrentCounterToFinish<T>
    extends AbstractCounter.AbstractConcurrentCounter<T> {
        public ConcurrentCounterToFinish(int countTo) {
            super(countTo);
        }

        @Override
        protected void body(ForeachContext<T> ctx, int delta) {
            if (this.counterAddAndGet(delta) >= this.countTo) {
                ctx.finish();
            }
        }
    }

    private static class SerialCounterToFinish<T>
    extends AbstractCounter.AbstractSerialCounter<T> {
        public SerialCounterToFinish(int countTo) {
            super(countTo);
        }

        @Override
        protected void body(ForeachContext<T> ctx, int delta) {
            if (this.counterAddAndGet(delta) >= this.countTo) {
                ctx.finish();
            }
        }
    }
}

