/*
 * Decompiled with CFR 0.152.
 */
package evacSim.vehiclecontext;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import evacSim.ContextCreator;
import evacSim.GlobalVariables;
import evacSim.citycontext.House;
import evacSim.citycontext.Road;
import evacSim.citycontext.Zone;
import evacSim.vehiclecontext.Vehicle;
import evacSim.vehiclecontext.Vehicle_less_frequent_routing;
import evacSim.vehiclecontext.Vehicle_predefinedroutes;
import org.apache.log4j.Logger;
import repast.simphony.context.Context;
import repast.simphony.context.DefaultContext;
import repast.simphony.context.space.gis.GeographyFactoryFinder;
import repast.simphony.space.gis.Geography;
import repast.simphony.space.gis.GeographyParameters;

public class VehicleContext
extends DefaultContext<Vehicle> {
    public VehicleContext() {
        super((Object)"VehicleContext");
        Logger logger = ContextCreator.logger;
        logger.info((Object)"VehicleContext creation");
        GeographyParameters geoParams = new GeographyParameters();
        geoParams.setCrs("EPSG:32618");
        Geography vehicleGeography = GeographyFactoryFinder.createGeographyFactory(null).createGeography("VehicleGeography", (Context)this, geoParams);
        this.createVehicleContextFromActivityModels();
    }

    public void createVehicleContextFromActivityModels() {
        Geography<Zone> zoneGeography = ContextCreator.getZoneGeography();
        double propPreDetermined = GlobalVariables.PROPORTION_OF_PREDEFINED_ROUTING_VEHICLES;
        double propLessFreq = GlobalVariables.PROPORTION_OF_LESS_FREQUENT_ROUTING_VEHICLES;
        for (Zone z : zoneGeography.getAllObjects()) {
            Geometry hgeom = zoneGeography.getGeometry((Object)z);
            Coordinate coord = hgeom.getCoordinate();
            for (House h : z.getHouses()) {
                Vehicle v = GlobalVariables.ENABLE_MULTICLASS_ROUTING ? (Math.random() > propPreDetermined + propLessFreq ? new Vehicle(h) : (Math.random() < propPreDetermined / (propPreDetermined + propLessFreq) ? new Vehicle_predefinedroutes(h) : new Vehicle_less_frequent_routing(h))) : new Vehicle(h);
                v.setOriginalCoord(coord);
                v.setCurrentCoord(coord);
                Road road = z.getdepartureRoad();
                if (road.getLinkid() == 104819) {
                    road = ContextCreator.getCityContext().findRoadWithLinkID(104818);
                }
                if (road.getLinkid() == 101235) {
                    road = ContextCreator.getCityContext().findRoadWithLinkID(101236);
                }
                road.addVehicleToNewQueue(v);
            }
        }
    }
}

