/*
 * Decompiled with CFR 0.152.
 */
package evacSim.vehiclecontext;

import com.vividsolutions.jts.geom.Coordinate;
import evacSim.ContextCreator;
import evacSim.GlobalVariables;
import evacSim.citycontext.CityContext;
import evacSim.citycontext.House;
import evacSim.citycontext.Junction;
import evacSim.citycontext.Lane;
import evacSim.citycontext.Plan;
import evacSim.citycontext.Road;
import evacSim.citycontext.Zone;
import evacSim.data.DataCollector;
import evacSim.routing.RouteV;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.apache.log4j.Logger;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.opengis.referencing.operation.MathTransformFactory;
import repast.simphony.engine.environment.RunEnvironment;
import repast.simphony.essentials.RepastEssentials;
import repast.simphony.space.gis.Geography;

public class Vehicle {
    private Logger logger = ContextCreator.logger;
    private int id;
    protected int vehicleID_;
    private int deptime;
    private int endTime;
    private int destinationZoneId;
    protected int destRoadID;
    protected int lastRouteTime;
    private Coordinate originalCoord;
    protected Coordinate destCoord;
    private Coordinate previousEpochCoord;
    private Coordinate currentCoord_;
    private float length;
    private float distance_;
    private float nextDistance_;
    private float currentSpeed_;
    private float accRate_;
    private float bearing_;
    private float desiredSpeed_;
    private int regime_;
    protected float maxAcceleration_;
    private float normalDeceleration_;
    protected float maxDeceleration_;
    private float distanceToNormalStop_;
    private float lastStepMove_;
    public float accummulatedDistance_;
    private float travelPerTurn;
    private boolean reachDest;
    private boolean reachActLocation;
    private int lastMoveTick = -1;
    private boolean onlane = false;
    protected boolean atOrigin = true;
    private House house;
    protected Road road;
    protected Road nextRoad_;
    private Lane lane;
    private Lane nextLane_;
    protected Zone destZone;
    protected Queue<Road> roadPath;
    private List<Coordinate> coordMap;
    private Geography<Lane> laneGeography;
    private Vehicle leading_;
    private Vehicle trailing_;
    private Vehicle macroLeading_;
    private Vehicle macroTrailing_;
    private Lane targetLane_;
    private boolean correctLane;
    private boolean nosingFlag;
    private boolean yieldingFlag;
    GeodeticCalculator calculator = new GeodeticCalculator(ContextCreator.getLaneGeography().getCRS());
    MathTransformFactory mtFactory = ReferencingFactoryFinder.getMathTransformFactory(null);
    private int Nshadow;
    private ArrayList<Road> futureRoutingRoad;
    private int vehicleClass;
    protected float travelTimeForPreviousRoute;
    protected int previousTick;
    protected float indiffBand;
    protected HashMap<Integer, Integer> visitedShelters;
    protected int stuck_time = 0;
    protected boolean movingFlag = false;
    protected ArrayList<Integer> linkHistory;
    protected ArrayList<Integer> linkTimeHistory;

    public Vehicle(House h) {
        this.id = ContextCreator.generateAgentID();
        this.house = h;
        this.currentCoord_ = new Coordinate();
        this.length = GlobalVariables.DEFAULT_VEHICLE_LENGTH;
        this.travelPerTurn = GlobalVariables.TRAVEL_PER_TURN;
        this.maxAcceleration_ = GlobalVariables.MAX_ACCELERATION;
        this.maxDeceleration_ = GlobalVariables.MAX_DECELERATION;
        this.normalDeceleration_ = -0.5f;
        this.previousEpochCoord = new Coordinate();
        this.endTime = 0;
        this.reachDest = false;
        this.reachActLocation = true;
        this.accRate_ = 0.0f;
        this.nextLane_ = null;
        this.nosingFlag = false;
        this.yieldingFlag = false;
        this.macroLeading_ = null;
        this.macroTrailing_ = null;
        this.leading_ = null;
        this.trailing_ = null;
        this.nextRoad_ = null;
        this.laneGeography = ContextCreator.getLaneGeography();
        this.coordMap = new ArrayList<Coordinate>();
        this.destRoadID = 0;
        this.lastStepMove_ = 0.0f;
        this.vehicleID_ = h.getId();
        this.accummulatedDistance_ = 0.0f;
        this.roadPath = null;
        this.lastRouteTime = -1;
        this.setNextPlan();
        this.Nshadow = 0;
        this.futureRoutingRoad = new ArrayList();
        this.setVehicleClass(1);
        this.travelTimeForPreviousRoute = Float.MAX_VALUE;
        this.previousTick = 0;
        this.indiffBand = this.assignIndiffBand();
        this.visitedShelters = new HashMap();
        Plan startPlan = this.house.getActivityPlan().get(0);
        this.visitedShelters.put(startPlan.getLocation(), startPlan.getDuration());
        this.linkHistory = new ArrayList();
        this.linkTimeHistory = new ArrayList();
        ++GlobalVariables.NUM_GENERATED_VEHICLES;
    }

    public Vehicle(House h, float maximumAcceleration, float maximumDeceleration) {
        this(h);
        this.maxAcceleration_ = maximumAcceleration;
        this.maxDeceleration_ = maximumDeceleration;
        this.setVehicleClass(-1);
    }

    public void setNextPlan() {
        int destinationZone;
        Plan current = this.house.getActivityPlan().get(0);
        Plan next = this.house.getActivityPlan().get(1);
        this.destinationZoneId = destinationZone = next.getLocation().intValue();
        float duration = current.getDuration();
        int deptime = (int)(duration * 60.0f / GlobalVariables.SIMULATION_STEP_SIZE);
        this.setDepTime(deptime);
        CityContext cityContext = ContextCreator.getCityContext();
        this.destZone = cityContext.findHouseWithDestID(this.destinationZoneId);
        if (this.destZone == null) {
            this.logger.info((Object)"helloooo");
        }
        this.destCoord = this.destZone.getCoord();
        this.originalCoord = cityContext.findHouseWithDestID(current.getLocation()).getCoord();
        this.destRoadID = cityContext.findRoadAtCoordinates(this.destCoord, true).getLinkid();
        this.atOrigin = true;
    }

    public int enterNetwork(Road road) {
        Lane firstlane = road.firstLane();
        float gap = this.entranceGap(firstlane);
        int tickcount = (int)RepastEssentials.GetTickCount();
        if ((double)gap >= 1.2 * (double)this.length() && tickcount > firstlane.getLastEnterTick()) {
            float capspd;
            firstlane.updateLastEnterTick(tickcount);
            this.updateLastMoveTick(tickcount);
            this.currentSpeed_ = capspd = road.getFreeSpeed();
            this.desiredSpeed_ = this.road.getFreeSpeed();
            this.road.removeVehicleFromNewQueue(this);
            this.setRoad(road);
            this.setCoordMap(firstlane);
            this.append(firstlane);
            this.appendToRoad(this.road);
            this.linkHistory.add(this.road.getLinkid());
            this.linkTimeHistory.add(tickcount);
            this.setNextRoad();
            this.assignNextLane();
            ++GlobalVariables.NUM_VEHICLES_ENTERED_ROAD_NETWORK;
            return 1;
        }
        return 0;
    }

    public Road nextRoad() {
        return this.nextRoad_;
    }

    public void clearShadowImpact() {
        if (this.roadPath != null) {
            if (this.Nshadow > this.roadPath.size()) {
                this.Nshadow = this.roadPath.size();
            }
            if (this.Nshadow > 0) {
                Iterator itr = this.roadPath.iterator();
                int i = 0;
                while (i < this.Nshadow) {
                    Road r = (Road)itr.next();
                    r.decreaseShadowVehicleNum();
                    ++i;
                }
            }
            this.Nshadow = 0;
            for (Road r : this.futureRoutingRoad) {
                r.decreaseFutureRoutingVehNum();
            }
            this.futureRoutingRoad.clear();
        }
    }

    public void removeShadowCount(Road r) {
        if (this.Nshadow > 0) {
            r.decreaseShadowVehicleNum();
            --this.Nshadow;
        }
        if (this.futureRoutingRoad.contains(r)) {
            r.decreaseFutureRoutingVehNum();
            this.futureRoutingRoad.remove(r);
        }
    }

    public void setShadowImpact() {
        this.Nshadow = GlobalVariables.N_SHADOW;
        if (this.roadPath.size() < this.Nshadow) {
            this.Nshadow = this.roadPath.size();
        }
        if (this.Nshadow > 0) {
            int shadowCount = 1;
            double cumlativeTT_Nshadow = 0.0;
            double cumulativeTT = 0.0;
            int foundFutureRoutingRoad = 0;
            Iterator itr = this.roadPath.iterator();
            int i = 0;
            while (i < this.Nshadow) {
                Road r = (Road)itr.next();
                if (i < 1) {
                    r.incrementShadowVehicleNum();
                } else if (cumlativeTT_Nshadow <= (double)((float)GlobalVariables.SIMULATION_PARTITION_REFRESH_INTERVAL * GlobalVariables.SIMULATION_STEP_SIZE)) {
                    r.incrementShadowVehicleNum();
                    cumlativeTT_Nshadow += r.getTravelTime();
                    ++shadowCount;
                }
                cumulativeTT += r.getTravelTime();
                if (foundFutureRoutingRoad < GlobalVariables.PART_REFRESH_MULTIPLIER && cumulativeTT >= (double)((float)GlobalVariables.SIMULATION_NETWORK_REFRESH_INTERVAL * GlobalVariables.SIMULATION_STEP_SIZE)) {
                    this.futureRoutingRoad.add(r);
                    r.incrementFutureRoutingVehNum();
                    ++foundFutureRoutingRoad;
                    cumulativeTT = 0.0;
                }
                ++i;
            }
            this.Nshadow = shadowCount;
        } else {
            this.Nshadow = 0;
        }
    }

    public void setNextRoad() {
        try {
            if (!this.atOrigin) {
                if (this.road.getLinkid() == this.destRoadID) {
                    this.nextRoad_ = null;
                    return;
                }
                boolean flag = false;
                if (this.lastRouteTime < RouteV.getValidTime()) {
                    Map<Float, Queue<Road>> tempPathMap = RouteV.vehicleRoute(this, this.destZone);
                    for (Map.Entry<Float, Queue<Road>> entry : tempPathMap.entrySet()) {
                        float pathTimeNew = entry.getKey().floatValue();
                        Queue<Road> tempPathNew = entry.getValue();
                        if ((double)pathTimeNew == 0.0) break;
                        int currentTick = (int)RepastEssentials.GetTickCount();
                        Queue<Road> tempPath = entry.getValue();
                        double pathTimeOldPath = this.travelTimeForPreviousRoute - (float)(currentTick - this.previousTick) * GlobalVariables.SIMULATION_STEP_SIZE;
                        if (pathTimeOldPath - (double)pathTimeNew > (double)this.indiffBand * pathTimeOldPath && pathTimeOldPath - (double)pathTimeNew > (double)GlobalVariables.TAU) {
                            tempPath = tempPathNew;
                            this.travelTimeForPreviousRoute = pathTimeNew;
                            this.previousTick = currentTick;
                        }
                        Iterator iter = tempPath.iterator();
                        iter.next();
                        if (!this.checkNextLaneConnected((Road)iter.next())) continue;
                        this.clearShadowImpact();
                        this.roadPath = tempPath;
                        this.setShadowImpact();
                        this.lastRouteTime = (int)RepastEssentials.GetTickCount();
                        Iterator itr = this.roadPath.iterator();
                        itr.next();
                        this.nextRoad_ = (Road)itr.next();
                        flag = true;
                    }
                }
                if (!flag) {
                    this.removeShadowCount(this.roadPath.poll());
                    if (this.roadPath.size() == 1) {
                        this.nextRoad_ = null;
                        return;
                    }
                    Iterator itr = this.roadPath.iterator();
                    itr.next();
                    this.nextRoad_ = (Road)itr.next();
                }
            } else {
                this.clearShadowImpact();
                Map<Float, Queue<Road>> tempPathMap = RouteV.vehicleRoute(this, this.destZone);
                for (Map.Entry<Float, Queue<Road>> entry : tempPathMap.entrySet()) {
                    double dist = entry.getKey().floatValue();
                    Queue<Road> path = entry.getValue();
                    this.roadPath = path;
                    this.setShadowImpact();
                    this.lastRouteTime = (int)RepastEssentials.GetTickCount();
                    this.atOrigin = false;
                    if (dist != 0.0) {
                        Iterator itr = this.roadPath.iterator();
                        itr.next();
                        this.nextRoad_ = (Road)itr.next();
                        continue;
                    }
                    this.logger.info((Object)(this + " same road" + this.road.getLinkid() + " for next dest"));
                    this.nextRoad_ = null;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info((Object)("No next road found for Vehicle " + this.vehicleID_ + " on Road " + this.road.getLinkid()));
            ++GlobalVariables.NUM_FAILED_VEHICLES;
            this.nextRoad_ = null;
        }
    }

    public void append(Lane plane) {
        this.lane = plane;
        Vehicle v = plane.lastVehicle();
        plane.addVehicles();
        if (v != null) {
            this.leading(v);
            v.trailing(this);
        } else {
            plane.firstVehicle(this);
            this.leading(null);
        }
        this.trailing(null);
        plane.lastVehicle(this);
        this.onlane = true;
    }

    public void setCoordMap(Lane plane) {
        if (plane != null) {
            Coordinate[] coords = this.laneGeography.getGeometry((Object)plane).getCoordinates();
            this.coordMap.clear();
            Coordinate[] coordinateArray = coords;
            int n = coords.length;
            int n2 = 0;
            while (n2 < n) {
                Coordinate coord = coordinateArray[n2];
                this.coordMap.add(coord);
                ++n2;
            }
            this.setCurrentCoord(this.coordMap.get(0));
            this.coordMap.remove(0);
            this.distance_ = plane.getLength();
            float[] distAndAngle = new float[2];
            this.distance2(this.getCurrentCoord(), this.coordMap.get(0), distAndAngle);
            this.nextDistance_ = distAndAngle[0];
            this.setBearing(distAndAngle[1]);
        } else {
            this.logger.error((Object)"There is no target lane to set!");
        }
        if (Double.isNaN(this.distance_)) {
            this.logger.error((Object)("distance_ is NaN in setCoordMap for " + this));
        }
    }

    private void updateCoordMap(Lane lane) {
        Coordinate[] coords = this.laneGeography.getGeometry((Object)lane).getCoordinates();
        this.coordMap.clear();
        float accDist = lane.getLength();
        int i = 0;
        while (i < coords.length - 1) {
            if (this.distance_ >= (accDist -= this.distance(coords[i], coords[i + 1]))) {
                float[] distAndAngle = new float[2];
                this.distance2(coords[i], coords[i + 1], distAndAngle);
                this.move2(coords[i], coords[i + 1], distAndAngle[0], distAndAngle[0] - (this.distance_ - accDist));
                this.nextDistance_ = this.distance_ - accDist;
                this.setBearing(distAndAngle[1]);
                int j = i + 1;
                while (j < coords.length) {
                    this.coordMap.add(coords[j]);
                    ++j;
                }
                break;
            }
            ++i;
        }
        if (this.coordMap.size() == 0) {
            float[] distAndAngle = new float[2];
            this.distance2(coords[coords.length - 2], coords[coords.length - 1], distAndAngle);
            this.move2(coords[coords.length - 2], coords[coords.length - 1], distAndAngle[0], distAndAngle[0] - this.distance_);
            this.nextDistance_ = this.distance_;
            this.setBearing(distAndAngle[1]);
            this.coordMap.add(coords[coords.length - 1]);
        }
    }

    public boolean calcState() {
        if (this.road == null || this == null) {
            return false;
        }
        this.makeAcceleratingDecision();
        if (this.road.getnLanes() > 1 && this.onlane && this.distance_ >= GlobalVariables.NO_LANECHANGING_LENGTH) {
            this.makeLaneChangingDecision();
        }
        return true;
    }

    public void makeAcceleratingDecision() {
        Vehicle front = this.vehicleAhead();
        float aZ = this.accRate_;
        float acc = this.maxAcceleration();
        if (!this.nosingFlag && !this.yieldingFlag) {
            aZ = this.calcCarFollowingRate(front);
        } else if (this.nosingFlag) {
            aZ = this.nosing();
        } else if (this.yieldingFlag) {
            aZ = this.yielding();
        }
        if (aZ < acc) {
            acc = aZ;
        }
        if (acc < this.maxDeceleration_) {
            acc = this.maxDeceleration_;
        }
        this.accRate_ = acc;
        if (Double.isNaN(this.accRate_)) {
            this.logger.error((Object)("Vehicle.makeAcceleratingDecision: acc=NaN for " + this));
        }
    }

    public float calcCarFollowingRate(Vehicle front) {
        float acc;
        if (front == null) {
            this.regime_ = 0;
            return this.maxAcceleration_;
        }
        float space = this.gapDistance(front);
        float speed = this.currentSpeed_ == 0.0f ? 1.0E-5f : this.currentSpeed_;
        float headway = 2.0f * space / (speed + this.currentSpeed_);
        float AlphaDec = GlobalVariables.ALPHA_DEC;
        float BetaDec = GlobalVariables.BETA_DEC;
        float GammaDec = GlobalVariables.GAMMA_DEC;
        float AlphaAcc = GlobalVariables.ALPHA_ACC;
        float BetaAcc = GlobalVariables.BETA_ACC;
        float GammaAcc = GlobalVariables.GAMMA_ACC;
        float hupper = GlobalVariables.H_UPPER;
        float hlower = GlobalVariables.H_LOWER;
        if (headway < hlower) {
            float dv = this.currentSpeed_ - front.currentSpeed_;
            if (dv < GlobalVariables.SPEED_EPSILON) {
                acc = front.accRate_ + 0.25f * this.normalDeceleration_;
            } else if ((double)space > 0.01) {
                acc = front.accRate_ - 0.5f * dv * dv / space;
            } else {
                float dt = GlobalVariables.SIMULATION_STEP_SIZE;
                float v = front.currentSpeed_ + front.accRate_ * dt;
                acc = this.brakeToTargetSpeed(space += 0.5f * (front.currentSpeed_ + v) * dt, v);
            }
            acc = Math.min(this.normalDeceleration_, acc);
            this.regime_ = 256;
        } else if (headway > hupper) {
            if (space > this.distanceToNormalStop_) {
                acc = this.maxAcceleration_;
                this.regime_ = 0;
            } else {
                float dt = GlobalVariables.SIMULATION_STEP_SIZE;
                float v = front.currentSpeed_ + front.accRate_ * dt;
                space = (float)((double)space + 0.5 * (double)(front.currentSpeed_ + v) * (double)dt);
                acc = this.brakeToTargetSpeed(space, v);
                this.regime_ = 0;
            }
        } else {
            float dv = front.currentSpeed_ - this.currentSpeed_;
            acc = dv < 0.0f ? dv * AlphaDec * (float)Math.pow(this.currentSpeed_, BetaDec) / (float)Math.pow(space, GammaDec) : (dv > 0.0f ? dv * AlphaAcc * (float)Math.pow(this.currentSpeed_, BetaAcc) / (float)Math.pow(space, GammaAcc) : 0.0f);
            this.regime_ = 128;
        }
        if (Double.isNaN(acc)) {
            this.logger.error((Object)("Vehicle.calcCarFollowingRate():  acc=NaN for " + this));
        }
        return acc;
    }

    public float brakeToTargetSpeed(float space, float v) {
        if ((double)space > 2.938736052218037E-39) {
            float v2 = v * v;
            float u2 = this.currentSpeed_ * this.currentSpeed_;
            float acc = (v2 - u2) / space * 0.5f;
            return acc;
        }
        float dt = GlobalVariables.SIMULATION_STEP_SIZE;
        if ((double)dt <= 0.0) {
            return this.maxAcceleration_;
        }
        return (v - this.currentSpeed_) / dt;
    }

    public Vehicle vehicleAhead() {
        if (this.leading_ != null) {
            return this.leading_;
        }
        if (this.nextLane_ != null) {
            if (this.nextLane_.lastVehicle() != null) {
                return this.nextLane_.lastVehicle();
            }
            return null;
        }
        return null;
    }

    public Junction nextJuction() {
        if (this.nextRoad() == null) {
            return null;
        }
        Junction nextJunction = this.nextRoad().getJunctions().get(0).getID() == this.road.getJunctions().get(1).getID() ? this.road.getJunctions().get(1) : this.road.getJunctions().get(0);
        return nextJunction;
    }

    public float gapDistance(Vehicle front) {
        float headwayDistance = front != null ? (front.lane == null ? this.distance_ - front.length() : (this.lane.getID() == front.lane.getID() ? this.distance_ - front.distance() - front.length() : this.distance_ + front.lane.getLength() - front.distance())) : Float.MAX_VALUE;
        if (Double.isNaN(headwayDistance)) {
            this.logger.error((Object)("Vehicle.gapDistance(): headway=NaN for " + this));
        }
        return headwayDistance;
    }

    public void makeLaneChangingDecision() {
        if ((double)this.distFraction() < 0.5) {
            Lane plane;
            if (!this.isCorrectLane() && (plane = this.tempLane()) != null) {
                this.mandatoryLC(plane);
            }
        } else if ((double)this.distFraction() > 0.75) {
            double laneChangeProb1 = GlobalVariables.RandomGenerator.nextDouble();
            Lane tarLane = this.findBetterCorrectLane();
            if (tarLane != null && laneChangeProb1 < 1.0) {
                this.discretionaryLC(tarLane);
            }
        } else {
            double laneChangeProb2 = GlobalVariables.RandomGenerator.nextDouble();
            Lane tarLane = this.findBetterCorrectLane();
            if (tarLane != null && laneChangeProb2 < 1.0) {
                this.discretionaryLC(tarLane);
            }
        }
    }

    public void makeLaneChangingDecision_oldCode() {
        if ((double)this.distFraction() > 0.7) {
            double laneChangeProb = GlobalVariables.RandomGenerator.nextDouble();
            Lane tarLane = this.findBetterLane();
            if (tarLane != null && laneChangeProb > 0.5) {
                this.discretionaryLC(tarLane);
            }
        } else if ((double)this.distFraction() > 0.5) {
            if (!this.isCorrectLane()) {
                Lane plane = this.tempLane();
                if (plane != null) {
                    this.mandatoryLC(plane);
                } else {
                    this.logger.info((Object)("Vehicle " + this.getId() + "has no lane to change"));
                }
            } else {
                Lane tarLane = this.findBetterCorrectLane();
                if (tarLane != null) {
                    this.discretionaryLC(tarLane);
                }
            }
        } else if (!this.isCorrectLane()) {
            Lane plane = this.tempLane();
            if (plane != null) {
                this.mandatoryLC(plane);
            } else {
                this.logger.info((Object)("Vehicle " + this.getId() + "has no lane to change"));
            }
        }
    }

    public void recVehSnaphotForVisInterp() {
        Coordinate currentCoord = this.getCurrentCoord();
        if (currentCoord != null) {
            try {
                DataCollector.getInstance().recordVehicleTickSnapshot(this, currentCoord);
            }
            catch (Throwable t) {
                DataCollector.printDebug("ERR" + t.getMessage());
            }
            this.setPreviousEpochCoord(currentCoord);
        }
    }

    public Coordinate getPreviousEpochCoord() {
        return this.previousEpochCoord;
    }

    private void setPreviousEpochCoord(Coordinate newCoord) {
        this.previousEpochCoord.x = newCoord.x;
        this.previousEpochCoord.y = newCoord.y;
    }

    public void travel() {
        ++this.endTime;
        try {
            if (!this.reachDest && !this.reachActLocation) {
                this.move();
                this.advanceInMacroList();
                if (this.nextRoad() == null) {
                    this.checkAtDestination();
                }
            }
        }
        catch (Exception e) {
            try {
                this.logger.error((Object)("Vehicle " + this.getVehicleID() + " had an error while travelling on road: " + this.road.getLinkid() + "with next road: " + this.nextRoad().getLinkid()));
                e.printStackTrace();
                RunEnvironment.getInstance().pauseRun();
            }
            catch (NullPointerException exc) {
                this.logger.error((Object)("Vehicle.travel(): " + this + " had an error while travelling on road: " + this.road.getLinkid() + " with next road: "));
                e.printStackTrace();
                RunEnvironment.getInstance().pauseRun();
            }
        }
    }

    public void move() {
        if (this.distance_ < 0.0f || Double.isNaN(this.distance_)) {
            this.logger.error((Object)("Vehicle.move(): distance_=" + this.distance_ + " " + this));
        }
        if (this.currentSpeed_ < 0.0f || Float.isNaN(this.currentSpeed_)) {
            this.logger.error((Object)("Vehicle.move(): currentSpeed_=" + this.currentSpeed_ + " " + this));
        }
        if (Double.isNaN(this.accRate_)) {
            this.logger.error((Object)("Vehicle.move(): accRate_=" + this.accRate_ + " " + this));
        }
        Coordinate currentCoord = null;
        Coordinate target = null;
        float dx = 0.0f;
        boolean travelledMaxDist = false;
        float distTravelled = 0.0f;
        float oldv = this.currentSpeed_;
        float step = GlobalVariables.SIMULATION_STEP_SIZE;
        float minSpeed = GlobalVariables.SPEED_EPSILON;
        float minAcc = GlobalVariables.ACC_EPSILON;
        float maxSpeed = this.road.getFreeSpeed();
        if (this.distance_ < GlobalVariables.INTERSECTION_BUFFER_LENGTH) {
            if (this.nextRoad() != null) {
                if (this.isOnLane()) {
                    this.coordMap.add(this.getCurrentCoord());
                    int canEnterNextRoad = this.appendToJunction(this.nextLane_);
                    if (canEnterNextRoad == 0) {
                        this.lastStepMove_ = 0.0f;
                        this.movingFlag = false;
                    } else {
                        this.lastStepMove_ = this.distance_;
                        this.accummulatedDistance_ += this.lastStepMove_;
                        this.movingFlag = true;
                    }
                    return;
                }
                if (this.changeRoad() == 0) {
                    ++this.stuck_time;
                    this.lastStepMove_ = 0.0f;
                    this.movingFlag = false;
                } else {
                    this.stuck_time = 0;
                    this.lastStepMove_ = this.distance_;
                    this.accummulatedDistance_ += this.lastStepMove_;
                    this.movingFlag = true;
                }
            }
            return;
        }
        double dv = this.accRate_ * step;
        if (dv > (double)(-this.currentSpeed_)) {
            dx = (float)((double)(this.currentSpeed_ * step) + 0.5 * dv * (double)step);
        } else {
            dx = -0.5f * this.currentSpeed_ * this.currentSpeed_ / this.accRate_;
            if (this.currentSpeed_ < minSpeed && this.accRate_ < minAcc) {
                dx = 0.0f;
            }
        }
        if (Double.isNaN(dx)) {
            this.logger.info((Object)("dx is NaN in move() for " + this));
        }
        float gap = this.gapDistance(this.vehicleAhead());
        dx = Math.max(0.0f, Math.min(dx, gap));
        this.accRate_ = 2.0f * (dx - oldv * step) / (step * step);
        this.currentSpeed_ += this.accRate_ * step;
        if (this.currentSpeed_ < minSpeed) {
            this.currentSpeed_ = 0.0f;
            this.accRate_ = 0.0f;
        } else if (this.currentSpeed_ > maxSpeed && this.accRate_ > minAcc) {
            this.currentSpeed_ = maxSpeed;
            this.accRate_ = (this.currentSpeed_ - oldv) / step;
        }
        if (dx < 0.0f) {
            this.lastStepMove_ = 0.0f;
            this.movingFlag = false;
            return;
        }
        float[] distAndAngle = new float[2];
        while (!travelledMaxDist) {
            target = this.coordMap.get(0);
            if (distTravelled + this.nextDistance_ <= dx) {
                distTravelled += this.nextDistance_;
                this.setCurrentCoord(target);
                this.coordMap.remove(0);
                if (this.coordMap.isEmpty()) {
                    this.distance_ -= this.nextDistance_;
                    this.nextDistance_ = 0.0f;
                    if (this.nextRoad() != null) {
                        if (this.isOnLane()) {
                            this.coordMap.add(this.getCurrentCoord());
                            this.stuck_time = this.appendToJunction(this.nextLane_) == 0 ? ++this.stuck_time : 0;
                            this.lastStepMove_ = distTravelled;
                            this.accummulatedDistance_ += distTravelled;
                            break;
                        }
                        this.stuck_time = this.changeRoad() == 0 ? ++this.stuck_time : 0;
                        this.lastStepMove_ = distTravelled;
                        this.accummulatedDistance_ += distTravelled;
                        break;
                    }
                    this.coordMap.clear();
                    this.coordMap.add(this.currentCoord_);
                    break;
                }
                currentCoord = this.getCurrentCoord();
                this.distance2(currentCoord, this.coordMap.get(0), distAndAngle);
                this.distance_ -= this.nextDistance_;
                this.nextDistance_ = distAndAngle[0];
                this.setBearing(distAndAngle[1]);
                continue;
            }
            float distanceToTarget = this.nextDistance_;
            this.distance_ -= dx - distTravelled;
            this.nextDistance_ -= dx - distTravelled;
            currentCoord = this.getCurrentCoord();
            this.move2(currentCoord, this.coordMap.get(0), distanceToTarget, dx - distTravelled);
            distTravelled = dx;
            this.accummulatedDistance_ += dx;
            this.lastStepMove_ = dx;
            travelledMaxDist = true;
        }
        this.movingFlag = distTravelled > 0.0f;
        if (this.distance_ < 0.0f) {
            this.distance_ = 0.0f;
        }
    }

    public void printGlobalVehicle(float dx) {
        if (this.vehicleID_ == GlobalVariables.Global_Vehicle_ID) {
            this.logger.info((Object)("Next Road ID for vhielc: " + this.vehicleID_ + " is: " + this.nextRoad().getLinkid() + " step size is: " + dx + " distance to downstream: " + this.distance_ + " next lane: " + this.nextLane_ + " current speed: " + this.currentSpeed_));
        }
    }

    public void primitiveMove() {
        Coordinate currentCoord = null;
        Coordinate target = null;
        if (this.atDestination()) {
            return;
        }
        currentCoord = this.getCurrentCoord();
        if (this.coordMap.size() > 0) {
            target = this.coordMap.get(0);
        } else {
            Coordinate[] coords;
            this.lane = this.road.firstLane();
            Coordinate[] coordinateArray = coords = this.laneGeography.getGeometry((Object)this.lane).getCoordinates();
            int n = coords.length;
            int n2 = 0;
            while (n2 < n) {
                Coordinate coord = coordinateArray[n2];
                this.coordMap.add(coord);
                ++n2;
            }
            target = this.coordMap.get(0);
        }
        float[] distAndAngle = new float[2];
        float distToTarget = this.distance2(currentCoord, target, distAndAngle);
        if (distToTarget <= this.travelPerTurn) {
            this.setCurrentCoord(target);
        } else {
            float distToTravel = this.travelPerTurn;
            this.accummulatedDistance_ += distToTravel;
            this.move2(currentCoord, target, distToTarget, distToTravel);
        }
    }

    public int changeRoad() {
        if (this.atDestination()) {
            this.clearShadowImpact();
            return 0;
        }
        if (this.nextRoad_ != null) {
            int tickcount = (int)RepastEssentials.GetTickCount();
            if ((double)this.entranceGap(this.nextLane_) >= 1.2 * (double)this.length() && tickcount > this.nextLane_.getLastEnterTick()) {
                this.nextLane_.updateLastEnterTick(tickcount);
                this.removeFromLane();
                this.removeFromMacroList();
                this.setCoordMap(this.nextLane_);
                this.appendToRoad(this.nextRoad());
                this.linkHistory.add(this.nextRoad().getLinkid());
                this.linkTimeHistory.add(tickcount);
                this.append(this.nextLane_);
                this.setNextRoad();
                this.assignNextLane();
                this.desiredSpeed_ = this.road.getFreeSpeed();
                if (this.currentSpeed_ > this.road.getFreeSpeed()) {
                    this.currentSpeed_ = this.road.getFreeSpeed();
                }
                return 1;
            }
            if (this.stuck_time > GlobalVariables.MAX_STUCK_TIME) {
                if (this.stuck_time <= GlobalVariables.MAX_STUCK_TIME2 && tickcount % (int)((float)GlobalVariables.REROUTE_FREQ / GlobalVariables.SIMULATION_STEP_SIZE) == 0) {
                    this.lastRouteTime = -1;
                    this.setNextRoad();
                    this.assignNextLane();
                } else {
                    for (Lane dnlane : this.lane.getDnLanes()) {
                        if (!((double)this.entranceGap(dnlane) >= 1.2 * (double)this.length()) || tickcount <= dnlane.getLastEnterTick()) continue;
                        dnlane.updateLastEnterTick(tickcount);
                        this.removeFromLane();
                        this.removeFromMacroList();
                        this.setCoordMap(dnlane);
                        this.appendToRoad(dnlane.road_());
                        this.append(dnlane);
                        this.linkHistory.add(dnlane.road_().getID());
                        this.linkTimeHistory.add(tickcount);
                        this.lastRouteTime = -1;
                        this.setNextRoad();
                        this.assignNextLane();
                        this.desiredSpeed_ = this.road.getFreeSpeed();
                        if (this.currentSpeed_ > this.road.getFreeSpeed()) {
                            this.currentSpeed_ = this.road.getFreeSpeed();
                        }
                        return 1;
                    }
                }
            }
        }
        this.coordMap.clear();
        this.coordMap.add(this.getCurrentCoord());
        return 0;
    }

    public int closeToRoad(Road road) {
        Coordinate currentCoord = this.getCurrentCoord();
        Coordinate nextCoord = null;
        if (this.coordMap == null) {
            return 0;
        }
        if (this.coordMap.size() == 0) {
            return 0;
        }
        nextCoord = this.coordMap.get(0);
        if (this.distance(currentCoord, nextCoord) < GlobalVariables.TRAVEL_PER_TURN) {
            return 1;
        }
        return 0;
    }

    public boolean atDestination() {
        return this.reachDest;
    }

    public boolean atActivityLocation() {
        return this.reachActLocation;
    }

    public boolean checkAtDestination() throws Exception {
        if (this.distance_ < GlobalVariables.INTERSECTION_BUFFER_LENGTH) {
            this.setReachDest();
            return true;
        }
        return false;
    }

    public float maxAcceleration() {
        return this.maxAcceleration_;
    }

    public void appendToRoad(Road road) {
        this.road = road;
        this.appendToMacroList(road);
        this.reachActLocation = false;
    }

    public void appendToMacroList(Road road) {
        this.macroTrailing_ = null;
        if (road.lastVehicle() != null) {
            road.lastVehicle().macroTrailing_ = this;
            this.macroLeading_ = road.lastVehicle();
        } else {
            this.macroLeading_ = null;
            road.firstVehicle(this);
        }
        road.lastVehicle(this);
        road.changeNumberOfVehicles(1);
    }

    public void leading(Vehicle v) {
        this.leading_ = v != null ? v : null;
    }

    public void clearMacroLeading() {
        this.macroLeading_ = null;
    }

    public Vehicle leading() {
        return this.leading_;
    }

    public Vehicle macroLeading() {
        return this.macroLeading_;
    }

    public Vehicle trailing() {
        return this.trailing_;
    }

    public Vehicle macroTrailing() {
        return this.macroTrailing_;
    }

    public void trailing(Vehicle v) {
        this.trailing_ = v != null ? v : null;
    }

    public void setDepTime(int time) {
        this.deptime = time;
    }

    public int getDepTime() {
        return this.deptime;
    }

    public int getEndTime() {
        return this.endTime;
    }

    public void setRoad(Road road) {
        this.road = road;
        this.currentSpeed_ = this.road.getFreeSpeed();
    }

    public Road getRoad() {
        return this.road;
    }

    public float distance() {
        return this.distance_;
    }

    public float distFraction() {
        if (this.distance_ > 0.0f) {
            return this.distance_ / this.lane.getLength();
        }
        return 0.0f;
    }

    public float length() {
        return this.length;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Lane getLane() {
        return this.lane;
    }

    public int getVehicleID() {
        return this.vehicleID_;
    }

    public int getDestinationID() {
        return this.destZone.getIntegerId();
    }

    public House getHouse() {
        return this.house;
    }

    public void setHouse(House h) {
        this.house = h;
    }

    public Coordinate getOriginalCoord() {
        return this.originalCoord;
    }

    public Coordinate getDestCoord() {
        return this.destCoord;
    }

    public void setOriginalCoord(Coordinate coord) {
        this.originalCoord = coord;
    }

    public Coordinate getCurrentCoord() {
        Coordinate coord = new Coordinate();
        coord.x = this.currentCoord_.x;
        coord.y = this.currentCoord_.y;
        coord.z = this.currentCoord_.z;
        return coord;
    }

    public void setCurrentCoord(Coordinate coord) {
        this.currentCoord_.x = coord.x;
        this.currentCoord_.y = coord.y;
        this.currentCoord_.z = coord.z;
    }

    public int nearlyArrived() {
        if (this.nextRoad_ == null) {
            return 1;
        }
        return 0;
    }

    public void setReachDest() throws Exception {
        Zone destinationZone = ContextCreator.getCityContext().findHouseWithDestID(this.getDestinationID());
        if (destinationZone.getType() == 1) {
            this.findNextShelter(destinationZone);
        } else {
            this.removeFromLane();
            this.removeFromMacroList();
            this.setCurrentCoord(this.destCoord);
            this.endTime = (int)RepastEssentials.GetTickCount();
            this.reachActLocation = false;
            this.reachDest = true;
            String formated_msg = String.valueOf(this.getVehicleID()) + ";" + 0 + ";" + this.getDepTime() + ";" + this.getEndTime() + ";" + this.getHouse().getZoneId() + ";" + this.getDestinationID() + ";" + this.accummulatedDistance_ + ";" + this.visitedShelters.size() + ";" + this.linkHistory.toString() + ";" + this.linkTimeHistory.toString();
            try {
                ContextCreator.bw.write(formated_msg);
                ContextCreator.bw.newLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.killVehicle();
        }
    }

    public void setLastRouteTime(int routeTime) {
        this.lastRouteTime = routeTime;
    }

    public float currentSpeed() {
        return this.currentSpeed_;
    }

    public void resetVehicle() {
        this.setNextPlan();
        CityContext cityContext = ContextCreator.getCityContext();
        Coordinate currentCoord = this.getCurrentCoord();
        Road road = cityContext.findRoadAtCoordinates(currentCoord, false);
        road.addVehicleToNewQueue(this);
        this.nextLane_ = null;
        this.nosingFlag = false;
        this.yieldingFlag = false;
        this.macroLeading_ = null;
        this.macroTrailing_ = null;
        this.leading_ = null;
        this.trailing_ = null;
        this.coordMap = new ArrayList<Coordinate>();
        this.accummulatedDistance_ = 0.0f;
    }

    public void killVehicle() {
        this.road = null;
        this.lane = null;
        this.laneGeography = null;
        this.nextLane_ = null;
        this.nosingFlag = false;
        this.yieldingFlag = false;
        this.macroLeading_ = null;
        this.macroTrailing_ = null;
        this.leading_ = null;
        this.trailing_ = null;
        this.coordMap = null;
        this.currentSpeed_ = 0.0f;
        this.targetLane_ = null;
        this.currentCoord_ = null;
        this.clearShadowImpact();
        ++GlobalVariables.NUM_KILLED_VEHICLES;
    }

    public Vehicle findFrontBumperLeaderInSameRoad(Lane plane) {
        Vehicle front = this.macroLeading_;
        while (front != null && front.lane != plane) {
            front = front.macroLeading_;
        }
        return front;
    }

    public void removeFromLane() {
        this.lane.removeVehicles();
        this.leading_ = null;
        if (this.trailing_ != null) {
            this.lane.firstVehicle(this.trailing_);
            this.trailing_.leading(null);
        } else {
            this.lane.firstVehicle(null);
            this.lane.lastVehicle(null);
        }
        this.trailing_ = null;
    }

    public void updateLastMoveTick(int current_tick) {
        this.lastMoveTick = current_tick;
    }

    public int getLastMoveTick() {
        return this.lastMoveTick;
    }

    public void removeFromMacroList() {
        Road pr = this.getRoad();
        if (this.macroLeading_ != null) {
            this.macroLeading_.macroTrailing_ = this.macroTrailing_;
        } else {
            pr.firstVehicle(this.macroTrailing_);
        }
        if (this.macroTrailing_ != null) {
            this.macroTrailing_.macroLeading_ = this.macroLeading_;
        } else {
            pr.lastVehicle(this.macroLeading_);
        }
        pr.changeNumberOfVehicles(-1);
    }

    public void advanceInMacroList() {
        Road pr = this.road;
        if (this.macroLeading_ == null || this.distance_ >= this.macroLeading_.distance_) {
            return;
        }
        Vehicle front = this.macroLeading_;
        while (front != null && this.distance_ < front.distance_) {
            front = front.macroLeading_;
        }
        this.macroLeading_.macroTrailing_ = this.macroTrailing_;
        if (this.macroTrailing_ != null) {
            this.macroTrailing_.macroLeading_ = this.macroLeading_;
        } else {
            pr.lastVehicle(this.macroLeading_);
        }
        this.macroLeading_ = front;
        if (this.macroLeading_ != null) {
            this.macroTrailing_ = this.macroLeading_.macroTrailing_;
            this.macroLeading_.macroTrailing_ = this;
        } else {
            this.macroTrailing_ = pr.firstVehicle();
            pr.firstVehicle(this);
        }
        if (this.macroTrailing_ != null) {
            this.macroTrailing_.macroLeading_ = this;
        } else {
            pr.lastVehicle(this);
        }
    }

    public boolean isCorrectLane() {
        if (this.nextRoad() == null) {
            return true;
        }
        Lane nextLane = this.getNextLane();
        this.correctLane = false;
        if (nextLane.getUpLanes().size() > 0) {
            for (Lane pl : nextLane.getUpLanes()) {
                if (!pl.equals(this.lane)) continue;
                this.correctLane = true;
                break;
            }
        }
        return this.correctLane;
    }

    public boolean checkNextLaneConnected(Road nextRoad) {
        boolean connected = false;
        Lane curLane = this.lane;
        if (nextRoad != null) {
            for (Lane dl : curLane.getDnLanes()) {
                if (!dl.road_().equals(nextRoad)) continue;
                connected = true;
                break;
            }
        }
        return connected;
    }

    public void assignNextLane() {
        boolean connected = false;
        Lane curLane = this.lane;
        Road curRoad = this.getRoad();
        if (this.nextRoad() == null) {
            if (this.getVehicleID() == GlobalVariables.Global_Vehicle_ID) {
                this.logger.info((Object)("Assign next lane: current link ID= " + curRoad.getLinkid() + " current lane ID: " + curLane.getLaneid() + " next link ID=" + this.nextRoad()));
            }
            this.nextLane_ = null;
            return;
        }
        for (Lane dl : curLane.getDnLanes()) {
            if (!dl.road_().equals(this.nextRoad())) continue;
            this.nextLane_ = dl;
            connected = true;
            break;
        }
        if (!connected) {
            block1: for (Lane pl : this.nextRoad().getLanes()) {
                for (Lane ul : pl.getUpLanes()) {
                    if (ul.road_().getID() != curRoad.getID()) continue;
                    this.nextLane_ = pl;
                    continue block1;
                }
            }
            this.nextLane_ = this.nextRoad().getLane(0);
        }
        if (this.nextLane_ == null) {
            this.logger.error((Object)("No next lane found for vehicle: " + this.vehicleID_ + " moving on the road: " + this.getRoad().getLinkid() + " lane: " + this.getLane().getLaneid() + " heading to location " + this.getDestinationID() + " while looking for next lane on road: " + this.nextRoad().getLinkid() + " that has " + this.nextRoad().getnLanes() + " lanes"));
        }
    }

    public Lane getNextLane() {
        return this.nextLane_;
    }

    public Lane targetLane() {
        Road curRoad = this.getRoad();
        Lane nextLane = this.getNextLane();
        if (nextLane != null) {
            for (Lane pl : nextLane.getUpLanes()) {
                if (!pl.road_().equals(curRoad)) continue;
                this.targetLane_ = pl;
                break;
            }
        }
        return this.targetLane_;
    }

    public Lane tempLane() {
        Lane plane = this.targetLane();
        Lane tempLane_ = null;
        if (this.road.getLaneIndex(plane) > this.road.getLaneIndex(this.lane)) {
            tempLane_ = this.rightLane();
        }
        if (this.road.getLaneIndex(plane) < this.road.getLaneIndex(this.lane)) {
            tempLane_ = this.leftLane();
        }
        return tempLane_;
    }

    public Lane leftLane() {
        Lane leftLane = null;
        if (this.road.getLaneIndex(this.lane) > 0) {
            leftLane = this.road.getLane(this.road.getLaneIndex(this.lane) - 1);
        }
        return leftLane;
    }

    public Lane rightLane() {
        Lane rightLane = null;
        if (this.road.getLaneIndex(this.lane) < this.road.getnLanes() - 1) {
            rightLane = this.road.getLane(this.road.getLaneIndex(this.lane) + 1);
        }
        return rightLane;
    }

    public void changeLane(Lane plane, Vehicle leadVehicle, Vehicle lagVehicle) {
        Vehicle curLeading = this.leading();
        Vehicle curTrailing = this.trailing();
        if (curTrailing != null) {
            if (curLeading != null) {
                curLeading.trailing(curTrailing);
                curTrailing.leading(curLeading);
            } else {
                curTrailing.leading(null);
                this.lane.firstVehicle(curTrailing);
            }
        } else if (curLeading != null) {
            this.lane.lastVehicle(curLeading);
            curLeading.trailing(null);
        } else {
            this.lane.firstVehicle(null);
            this.lane.lastVehicle(null);
        }
        this.lane.removeVehicles();
        this.lane = plane;
        if (leadVehicle != null) {
            if (this.distance_ < leadVehicle.distance_) {
                this.logger.error((Object)("Vehicle.changeLane(): distance_=" + this.distance_ + " is less than leadVehicle.distance_=" + leadVehicle.distance_ + " on lane=" + this.lane.getLaneid() + " with length=" + this.lane.getLength()));
            }
            this.leading_ = leadVehicle;
            this.leading_.trailing(this);
            if (lagVehicle != null) {
                if (lagVehicle.distance_ < this.distance_) {
                    this.logger.error((Object)("Vehicle.changeLane(): distance_=" + this.distance_ + " is greater than lagVehicle.distance_=" + lagVehicle.distance_ + " on lane=" + this.lane.getLaneid() + " with length=" + this.lane.getLength()));
                }
                this.trailing_ = lagVehicle;
                this.trailing_.leading(this);
            } else {
                this.trailing(null);
                this.lane.lastVehicle(this);
            }
        } else if (lagVehicle != null) {
            if (lagVehicle.distance_ < this.distance_) {
                this.logger.error((Object)("Vehicle.changeLane(): distance_=" + this.distance_ + " is greater than leadVehicle.distance_=" + lagVehicle.distance_ + " (when leadVehicle is null), $this on lane=" + this.lane.getLaneid() + " with length=" + this.lane.getLength()));
            }
            this.lane.firstVehicle(this);
            this.leading(null);
            this.trailing_ = lagVehicle;
            this.trailing_.leading(this);
        } else {
            this.lane.firstVehicle(this);
            this.lane.lastVehicle(this);
            this.leading(null);
            this.trailing(null);
        }
        this.lane.addVehicles();
        this.updateCoordMap(this.lane);
    }

    public void mandatoryLC(Lane plane) {
        Vehicle leadVehicle = this.leadVehicle(plane);
        Vehicle lagVehicle = this.lagVehicle(plane);
        if (leadVehicle != null) {
            if (lagVehicle != null) {
                if (this.leadGap(leadVehicle) > (double)this.critLeadGapMLC(leadVehicle) && this.lagGap(lagVehicle) > this.critLagGapMLC(lagVehicle)) {
                    this.changeLane(this.tempLane(), leadVehicle, lagVehicle);
                    this.nosingFlag = false;
                } else if (this.distFraction() < 0.6f) {
                    this.nosingFlag = true;
                }
            } else if (this.leadGap(leadVehicle) >= (double)this.critLeadGapMLC(leadVehicle)) {
                this.changeLane(this.tempLane(), leadVehicle, null);
            } else if (this.distFraction() < 0.6f) {
                this.nosingFlag = true;
            }
        } else if (lagVehicle != null) {
            if (this.lagGap(lagVehicle) >= this.critLagGapMLC(lagVehicle)) {
                this.changeLane(this.tempLane(), null, lagVehicle);
            } else if (this.distFraction() < 0.6f) {
                this.nosingFlag = true;
            }
        } else {
            this.changeLane(this.tempLane(), null, null);
        }
    }

    public float nosing() {
        float acc = 0.0f;
        Lane tarLane = this.tempLane();
        Vehicle leadVehicle = this.leadVehicle(tarLane);
        Vehicle lagVehicle = this.lagVehicle(tarLane);
        if (lagVehicle != null && this.lagGap(lagVehicle) < 5.0) {
            this.yieldingFlag = true;
        }
        Vehicle front = this.leading();
        acc = leadVehicle != null ? (this.leadGap(leadVehicle) < (double)this.critLeadGapMLC(leadVehicle) ? (this.currentSpeed_ > 12.2f ? -1.47f : (this.currentSpeed_ > 6.1f ? -2.04f : -2.4f)) : (front != null ? this.calcCarFollowingRate(front) : this.maxAcceleration_)) : (front != null ? this.calcCarFollowingRate(front) : this.maxAcceleration_);
        this.nosingFlag = false;
        if (Float.isNaN(acc)) {
            this.logger.error((Object)("Vehicle.nosing(): acceleration=NaN for " + this));
        }
        return acc;
    }

    public float yielding() {
        float acc = 0.0f;
        acc = this.currentSpeed_ > 24.3f ? -2.44f : (this.currentSpeed_ > 18.3f ? -2.6f : (this.currentSpeed_ > 12.2f ? -2.74f : (this.currentSpeed_ > 6.1f ? -2.9f : -3.05f)));
        this.yieldingFlag = false;
        return acc;
    }

    public float critLeadGapMLC(Vehicle leadVehicle) {
        float critLead = 0.0f;
        float minLead_ = 3.0f;
        float betaLead01 = 0.05f;
        float betaLead02 = 0.15f;
        float gama = 2.5E-5f;
        if (leadVehicle != null) {
            critLead = (float)((double)minLead_ + (double)(betaLead01 * this.currentSpeed() + betaLead02 * (this.currentSpeed() - leadVehicle.currentSpeed())) * (1.0 - Math.exp(-gama * this.distance())));
        }
        if (critLead < minLead_) {
            critLead = minLead_;
        }
        return critLead;
    }

    public double leadGap(Vehicle leadVehicle) {
        double leadGap = 0.0;
        leadGap = leadVehicle != null ? (double)(this.distance() - leadVehicle.distance() - leadVehicle.length()) : (double)this.distance();
        return leadGap;
    }

    public double critLagGapMLC(Vehicle lagVehicle) {
        double critLag = 0.0;
        double betaLag01 = 0.15f;
        double betaLag02 = 0.4f;
        double gama = 2.5E-5f;
        double minLag_ = 5.0;
        if (lagVehicle != null) {
            critLag = minLag_ + (betaLag01 * (double)this.currentSpeed() + betaLag02 * (double)(this.currentSpeed() - lagVehicle.currentSpeed())) * (1.0 - Math.exp(-gama * (double)this.distance()));
        }
        if (critLag < minLag_) {
            critLag = minLag_;
        }
        return critLag;
    }

    public double lagGap(Vehicle lagVehicle) {
        double lagGap = 0.0;
        lagGap = lagVehicle != null ? (double)(lagVehicle.distance() - this.distance() - this.length()) : (double)(this.lane.getLength() - this.distance() - this.length());
        return lagGap;
    }

    public Vehicle leadVehicle(Lane plane) {
        Vehicle leadVehicle = this.macroLeading_;
        while (leadVehicle != null && leadVehicle.lane != plane) {
            leadVehicle = leadVehicle.macroLeading_;
        }
        return leadVehicle;
    }

    public Vehicle lagVehicle(Lane plane) {
        Vehicle lagVehicle = this.macroTrailing_;
        while (lagVehicle != null && lagVehicle.lane != plane) {
            lagVehicle = lagVehicle.macroTrailing_;
        }
        return lagVehicle;
    }

    public Lane findBetterLane() {
        Lane curLane = this.lane;
        Lane targetLane = null;
        Lane rightLane = this.rightLane();
        Lane leftLane = this.leftLane();
        if (this.equals(curLane.firstVehicle())) {
            return null;
        }
        if (leftLane != null && rightLane != null) {
            Lane tempLane = leftLane.betterLane(rightLane);
            targetLane = curLane.betterLane(tempLane);
        } else if (leftLane != null) {
            targetLane = curLane.betterLane(leftLane);
        } else if (rightLane != null) {
            targetLane = curLane.betterLane(rightLane);
        }
        if (targetLane != null && !targetLane.equals(curLane)) {
            Vehicle front = this.findFrontBumperLeaderInSameRoad(targetLane);
            if (front == null) {
                return targetLane;
            }
            if (this.leading_ != null && this.leading_.currentSpeed_ < this.desiredSpeed_ && this.currentSpeed_ < this.desiredSpeed_) {
                if (front.currentSpeed_ > this.currentSpeed_ && front.accRate_ > 0.0f) {
                    return targetLane;
                }
            } else if (this.leading_ == null) {
                this.logger.error((Object)("Vehicle.findBetterLane(): this.leading_=null for" + this));
            }
        }
        return null;
    }

    public Lane findBetterCorrectLane() {
        Lane curLane = this.lane;
        Object targetLane = null;
        Lane rightLane = this.rightLane();
        Lane leftLane = this.leftLane();
        if (this.equals(curLane.firstVehicle())) {
            return null;
        }
        if (leftLane != null && rightLane != null) {
            if (leftLane.isConnectToLane(this.nextLane_) && rightLane.isConnectToLane(this.nextLane_)) {
                Lane tempLane = leftLane.betterLane(rightLane);
                targetLane = curLane.betterLane(tempLane);
            } else if (leftLane.isConnectToLane(this.nextLane_)) {
                targetLane = curLane.betterLane(leftLane);
            } else if (rightLane.isConnectToLane(this.nextLane_)) {
                targetLane = curLane.betterLane(rightLane);
            }
        } else if (leftLane != null && leftLane.isConnectToLane(this.nextLane_)) {
            targetLane = curLane.betterLane(leftLane);
        } else if (rightLane != null && rightLane.isConnectToLane(this.nextLane_)) {
            targetLane = curLane.betterLane(rightLane);
        }
        if (targetLane != null && !targetLane.equals(curLane)) {
            Vehicle front = this.findFrontBumperLeaderInSameRoad((Lane)targetLane);
            if (front == null) {
                return targetLane;
            }
            if (this.leading_ != null && this.leading_.currentSpeed_ < this.desiredSpeed_ && this.currentSpeed_ < this.desiredSpeed_ && front.currentSpeed_ > this.currentSpeed_ && front.accRate_ > 0.0f) {
                return targetLane;
            }
        }
        return null;
    }

    public void discretionaryLC(Lane plane) {
        Vehicle leadVehicle = this.leadVehicle(plane);
        Vehicle lagVehicle = this.lagVehicle(plane);
        double leadGap = this.leadGap(leadVehicle);
        double lagGap = this.lagGap(lagVehicle);
        double critLead = this.criticalLeadDLC(leadVehicle);
        double critLag = this.criticalLagDLC(lagVehicle);
        if (leadGap > critLead && lagGap > critLag) {
            this.changeLane(plane, leadVehicle, lagVehicle);
        }
    }

    public double criticalLeadDLC(Vehicle pv) {
        double critLead = 0.0;
        double minLead = 0.05f;
        if (pv != null) {
            critLead = minLead + (double)(0.05f * this.currentSpeed_) + (double)(0.15f * (this.currentSpeed_ - pv.currentSpeed_));
        }
        critLead = Math.max(minLead, critLead);
        return critLead;
    }

    public double criticalLagDLC(Vehicle pv) {
        double critLag = 0.0;
        double minLag = 0.05f;
        if (pv != null) {
            critLag = minLag + (double)(0.15f * this.currentSpeed_) + (double)(0.4f * (this.currentSpeed_ - pv.currentSpeed_));
        }
        critLag = Math.max(minLag, critLag);
        return critLag;
    }

    public void updateCoorMapWithNewLane() {
        Coordinate coor2;
        Coordinate coor1;
        if (!this.coordMap.isEmpty()) {
            int end = this.coordMap.size() - 1;
            coor1 = this.coordMap.get(end);
            if (this.vehicleID_ == GlobalVariables.Global_Vehicle_ID && !GlobalVariables.Debug_On_Road) {
                this.logger.error((Object)("Vehicle.updateCoordMapWithNewLane(): " + this + " already had its coordinate map but need to update " + "for moving through junction which connects to the " + "point: " + coor1));
            }
        } else {
            coor1 = this.getCurrentCoord();
        }
        if (this.nextLane_ != null) {
            Lane plane = this.nextLane_;
            Coordinate[] coords = this.laneGeography.getGeometry((Object)plane).getCoordinates();
            Coordinate c1 = coords[0];
            Coordinate c2 = coords[coords.length - 1];
            coor2 = this.getNearestCoordinate(coor1, c1, c2);
            if (this.vehicleID_ == GlobalVariables.Global_Vehicle_ID && !GlobalVariables.Debug_On_Road) {
                this.logger.info((Object)("The adding coordinate is from the lane: " + plane.getLaneid()));
            }
        } else {
            coor2 = this.destCoord;
        }
        if (!coor2.equals((Object)coor1)) {
            this.coordMap.add(coor2);
            if (this.vehicleID_ == GlobalVariables.Global_Vehicle_ID && !GlobalVariables.Debug_On_Road) {
                this.logger.info((Object)("Vehicle.updateCoorMapWithNewLane():  Added new coordinate " + this));
            }
        } else if (this.vehicleID_ == GlobalVariables.Global_Vehicle_ID && !GlobalVariables.Debug_On_Road) {
            this.logger.info((Object)("Vehicle.updateCoorMapWithNewLane():  No coordinate added " + this));
        }
        if (this.id == GlobalVariables.Global_Vehicle_ID && !GlobalVariables.Debug_On_Road) {
            int end = this.coordMap.size() - 1;
            this.logger.info((Object)("Vehicle.updateCoorMapWithNewLane():  Coordinate map after the next lane for " + this + ": "));
            this.logger.info((Object)("Distance to added point: " + this.distance(this.coordMap.get(end - 1), this.coordMap.get(end))));
        }
    }

    public int appendToJunction(Lane nextlane) {
        if (this.atDestination()) {
            return 0;
        }
        this.coordMap.clear();
        this.coordMap.add(this.getCurrentCoord());
        this.onlane = false;
        if (this.changeRoad() == 0) {
            return 0;
        }
        return 1;
    }

    public boolean isOnLane() {
        return this.onlane;
    }

    public float entranceGap(Lane nextlane) {
        float gap = 0.0f;
        if (nextlane != null) {
            Vehicle newleader = nextlane.lastVehicle();
            gap = newleader != null ? nextlane.getLength() - newleader.distance_ - newleader.length() : 9999999.0f;
        }
        return gap;
    }

    private Coordinate getNearestCoordinate(Coordinate c, Coordinate c1, Coordinate c2) {
        float dist2;
        float dist1 = this.distance(c, c1);
        if (dist1 < (dist2 = this.distance(c, c2))) {
            return c1;
        }
        return c2;
    }

    private float distance(Coordinate c1, Coordinate c2) {
        float distance;
        this.calculator.setStartingGeographicPoint(c1.x, c1.y);
        this.calculator.setDestinationGeographicPoint(c2.x, c2.y);
        try {
            distance = (float)this.calculator.getOrthodromicDistance();
        }
        catch (AssertionError ex) {
            this.logger.error((Object)"Error with finding distance");
            distance = 0.0f;
        }
        if (Double.isNaN(distance)) {
            this.logger.error((Object)("distance is NaN in Vehicle.distance() for " + this));
        }
        return distance;
    }

    private float distance2(Coordinate c1, Coordinate c2, float[] distAndAngle) {
        float radius;
        float distance;
        this.calculator.setStartingGeographicPoint(c1.x, c1.y);
        this.calculator.setDestinationGeographicPoint(c2.x, c2.y);
        try {
            distance = (float)this.calculator.getOrthodromicDistance();
            radius = (float)this.calculator.getAzimuth();
        }
        catch (AssertionError e) {
            this.logger.error((Object)("Error with finding distance: " + e));
            distance = 0.0f;
            radius = 0.0f;
        }
        if (distAndAngle != null && distAndAngle.length == 2) {
            distAndAngle[0] = distance;
            distAndAngle[1] = radius;
        }
        if (Double.isNaN(distance)) {
            this.logger.error((Object)("Geodetic distance is NaN for " + this));
            distance = 0.0f;
            radius = 0.0f;
        }
        return distance;
    }

    private void move2(Coordinate origin, Coordinate target, float distanceToTarget, float distanceTravelled) {
        float p = distanceTravelled / distanceToTarget;
        if (p < 1.0f) {
            this.setCurrentCoord(new Coordinate((double)(1.0f - p) * origin.x + (double)p * target.x, (double)(1.0f - p) * origin.y + (double)p * target.y));
        } else {
            this.logger.error((Object)("Vehicle.move2(): Cannot move " + this + "from " + origin + " by dist=" + distanceTravelled));
        }
    }

    public int getVehicleClass() {
        return this.vehicleClass;
    }

    public void setVehicleClass(int vehicleClass) {
        this.vehicleClass = vehicleClass;
    }

    public float assignIndiffBand() {
        float mean = GlobalVariables.ETA;
        float base = 0.5f * mean;
        float start = mean - 0.5f * base;
        float end = mean + 0.5f * base;
        float rand = GlobalVariables.RandomGenerator.nextFloat();
        float indiffbandvalue = (double)rand <= 0.5 ? (float)((double)start + (double)base * Math.sqrt(0.5f * rand)) : (float)((double)end - (double)base * Math.sqrt(0.5f * (1.0f - rand)));
        return indiffbandvalue;
    }

    public void findNextShelter(Zone curDest) throws Exception {
        ArrayList<Plan> plans = this.house.getActivityPlan();
        if (curDest.receiveEvacuee()) {
            int curTime = (int)RepastEssentials.GetTickCount();
            plans.get(plans.size() - 1).setDuration(curTime);
            Coordinate target = this.destCoord;
            this.removeFromLane();
            this.removeFromMacroList();
            this.setCurrentCoord(target);
            this.endTime = (int)RepastEssentials.GetTickCount();
            this.reachActLocation = false;
            this.reachDest = true;
            this.logger.info((Object)(this + " reached dest shelter " + curDest));
            String formatted_msg = String.valueOf(this.getVehicleID()) + ";" + 1 + ";" + this.getDepTime() + ";" + this.getEndTime() + ";" + this.getHouse().getZoneId() + ";" + this.getDestinationID() + ";" + this.accummulatedDistance_ + ";" + this.visitedShelters.size() + ";" + this.linkHistory.toString() + ";" + this.linkTimeHistory.toString();
            try {
                ContextCreator.bw.write(formatted_msg);
                ContextCreator.bw.newLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.killVehicle();
        } else {
            this.removeFromLane();
            this.removeFromMacroList();
            Coordinate target = this.destCoord;
            this.setCurrentCoord(target);
            CityContext cityContext = ContextCreator.getCityContext();
            Coordinate currentCoord = this.getCurrentCoord();
            Road road = cityContext.findRoadAtCoordinates(currentCoord, false);
            this.setRoad(road);
            this.visitedShelters.put(curDest.getIntegerId(), (int)RepastEssentials.GetTickCount());
            if (GlobalVariables.DYNAMIC_DEST_STRATEGY == 3) {
                curDest.addWaiting(this);
                return;
            }
            Zone nextShelter = ContextCreator.getCityContext().getClosestShelter(this);
            if (nextShelter != null) {
                this.setNewHouse(nextShelter.getIntegerId());
            } else {
                this.logger.info((Object)(this + ": All shelters exhausted; killing self"));
                this.killVehicle();
            }
        }
    }

    public void setNewHouse(int nextDestID) {
        ArrayList<Integer> locations = new ArrayList<Integer>();
        ArrayList<Integer> durations = new ArrayList<Integer>();
        int curDestID = this.getDestinationID();
        locations.add(curDestID);
        locations.add(nextDestID);
        durations.add(0);
        durations.add(0);
        House new_house = new House(this.getVehicleID(), this.getDestinationID());
        new_house.setActivityPlan(locations, durations);
        this.setHouse(new_house);
        int tick = (int)RepastEssentials.GetTickCount();
        this.logger.info((Object)("Rerouting" + this + "from " + locations.get(0) + " to " + locations.get(1) + " at t=" + tick + ": " + this.visitedShelters));
        this.resetVehicle();
    }

    public HashMap<Integer, Integer> getVisitedShelters() {
        return this.visitedShelters;
    }

    public int getRegime() {
        return this.regime_;
    }

    public String toString() {
        return "<Veh" + this.vehicleID_ + ">";
    }

    public boolean isAtOrigin() {
        return this.atOrigin;
    }

    public float getBearing() {
        return this.bearing_;
    }

    public void setBearing(float bearing_) {
        this.bearing_ = bearing_;
    }

    public boolean getMovingFlag() {
        return this.movingFlag;
    }
}

