/*
 * Decompiled with CFR 0.152.
 */
package evacSim.routing;

import edu.uci.ics.jung.graph.Graph;
import evacSim.ContextCreator;
import evacSim.GlobalVariables;
import evacSim.citycontext.CityContext;
import evacSim.citycontext.Junction;
import evacSim.citycontext.Road;
import evacSim.routing.JungToJgraph;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.apache.log4j.Logger;
import org.jgrapht.GraphPath;
import org.jgrapht.WeightedGraph;
import org.jgrapht.alg.DijkstraShortestPath;
import org.jgrapht.alg.KShortestPaths;
import repast.simphony.context.space.graph.ContextJungNetwork;
import repast.simphony.space.graph.JungNetwork;
import repast.simphony.space.graph.Network;
import repast.simphony.space.graph.RepastEdge;

public class VehicleRouting {
    Logger logger = ContextCreator.logger;
    private Network<Junction> network;
    private WeightedGraph<Junction, RepastEdge<Junction>> transformedNetwork = null;
    private CityContext cityContext = ContextCreator.getCityContext();

    public VehicleRouting(Network<Junction> network) {
        this.network = network;
        Graph graphA = null;
        if (network instanceof JungNetwork) {
            graphA = ((JungNetwork)network).getGraph();
        } else if (network instanceof ContextJungNetwork) {
            graphA = ((ContextJungNetwork)network).getGraph();
        }
        JungToJgraph converter = new JungToJgraph();
        this.transformedNetwork = converter.convertToJgraph(graphA);
    }

    public void calcRoute() {
        Graph graphA = null;
        if (this.network instanceof JungNetwork) {
            graphA = ((JungNetwork)this.network).getGraph();
        } else if (this.network instanceof ContextJungNetwork) {
            graphA = ((ContextJungNetwork)this.network).getGraph();
        }
        JungToJgraph converter = new JungToJgraph();
        this.transformedNetwork = converter.convertToJgraph(graphA);
    }

    public Map<Float, Queue<Road>> computeRoute(Road currentRoad, Road destRoad, Junction currJunc, Junction destJunc) {
        HashMap<Float, Queue<Road>> computeRouteResult = new HashMap<Float, Queue<Road>>();
        List shortestPath = null;
        int K = GlobalVariables.K_VALUE;
        double theta = GlobalVariables.THETA_LOGIT;
        if (GlobalVariables.K_SHORTEST_PATH) {
            KShortestPaths ksp = new KShortestPaths(this.transformedNetwork, (Object)currJunc, K);
            List kshortestPath = ksp.getPaths((Object)destJunc);
            ArrayList<Double> pathLength = new ArrayList<Double>();
            ArrayList<Double> pathProb = new ArrayList<Double>();
            ArrayList<Double> cumProb = new ArrayList<Double>();
            double total = 0.0;
            for (GraphPath kpath : kshortestPath) {
                pathLength.add(kpath.getWeight());
            }
            int i = 0;
            while (i < kshortestPath.size()) {
                total += Math.exp(-theta * (Double)pathLength.get(i));
                ++i;
            }
            i = 0;
            while (i < kshortestPath.size()) {
                double prob = Math.exp(-theta * (Double)pathLength.get(i)) / total;
                pathProb.add(prob);
                if (i == 0) {
                    cumProb.add(i, prob);
                } else {
                    cumProb.add(i, (Double)cumProb.get(i - 1) + prob);
                }
                ++i;
            }
            int k = 0;
            double random = GlobalVariables.RandomGenerator.nextDouble();
            int i2 = 0;
            while (i2 < kshortestPath.size()) {
                if (random < (Double)cumProb.get(i2)) {
                    k = i2;
                    break;
                }
                ++i2;
            }
            shortestPath = ((GraphPath)kshortestPath.get(k)).getEdgeList();
        } else if (GlobalVariables.SINGLE_SHORTEST_PATH) {
            DijkstraShortestPath sp = new DijkstraShortestPath(this.transformedNetwork, (Object)currJunc, (Object)destJunc);
            shortestPath = sp.getPathEdgeList();
        }
        Float shortestPathLength = Float.valueOf(0.0f);
        ArrayDeque<Road> roadPath_ = new ArrayDeque<Road>();
        roadPath_.add(currentRoad);
        for (RepastEdge edge : shortestPath) {
            int linkID = this.cityContext.getLinkIDFromEdge((RepastEdge<Junction>)edge);
            Road road = this.cityContext.findRoadWithLinkID(linkID);
            roadPath_.offer(road);
            shortestPathLength = Float.valueOf((float)((double)shortestPathLength.floatValue() + edge.getWeight()));
        }
        computeRouteResult.put(shortestPathLength, roadPath_);
        return computeRouteResult;
    }
}

