/*
 * Decompiled with CFR 0.152.
 */
package evacSim.routing;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.operation.distance.DistanceOp;
import evacSim.ContextCreator;
import evacSim.GlobalVariables;
import evacSim.citycontext.CityContext;
import evacSim.citycontext.Junction;
import evacSim.citycontext.Road;
import evacSim.citycontext.RoadContext;
import evacSim.citycontext.Zone;
import evacSim.routing.VehicleRouting;
import evacSim.vehiclecontext.Vehicle;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.apache.log4j.Logger;
import repast.simphony.essentials.RepastEssentials;
import repast.simphony.space.gis.Geography;
import repast.simphony.space.graph.Network;
import repast.simphony.space.graph.RepastEdge;

public class RouteV {
    private static Logger logger = ContextCreator.logger;
    public static Geography<Vehicle> vehicleGeography;
    public static Geography<Junction> junctionGeography;
    public static Network<Junction> roadNetwork;
    public static Geography<Road> roadGeography;
    public static CityContext cityContext;
    public static GeometryFactory geomFac;
    public static VehicleRouting vbr;
    public static int validRouteTime;
    public static double little_buffer_distance;
    public static double big_buffer_distance;

    public static void createRoute() throws Exception {
        vehicleGeography = ContextCreator.getVehicleGeography();
        junctionGeography = ContextCreator.getJunctionGeography();
        roadNetwork = ContextCreator.getRoadNetwork();
        roadGeography = ContextCreator.getRoadGeography();
        cityContext = ContextCreator.getCityContext();
        geomFac = new GeometryFactory();
        vbr = new VehicleRouting(roadNetwork);
        little_buffer_distance = 1.0E-4;
        big_buffer_distance = 100.0;
        validRouteTime = (int)RepastEssentials.GetTickCount();
    }

    public static void updateRoute() throws Exception {
        vbr.calcRoute();
        validRouteTime = (int)RepastEssentials.GetTickCount();
    }

    public static int getValidTime() {
        return validRouteTime;
    }

    public static Map<Float, Queue<Road>> vehicleRoute(Vehicle veh, Zone destZone) throws Exception {
        Road currentRoad = veh.getRoad();
        Road destRoad = destZone.getRoad();
        Junction curDownJunc = currentRoad.getJunctions().get(1);
        Junction destDownJunc = RouteV.getNearestDownStreamJunction(destRoad);
        if (curDownJunc.getID() == destDownJunc.getID()) {
            if (veh.getVehicleID() == GlobalVariables.Global_Vehicle_ID) {
                logger.info((Object)("Destination road reached " + destRoad.getLinkid() + " from current road: " + currentRoad.getLinkid()));
            }
            HashMap<Float, Queue<Road>> empty = new HashMap<Float, Queue<Road>>();
            empty.put(Float.valueOf(0.0f), new ArrayDeque());
            return empty;
        }
        veh.setLastRouteTime((int)RepastEssentials.GetTickCount());
        return vbr.computeRoute(currentRoad, destRoad, curDownJunc, destDownJunc);
    }

    public static Map<Float, Queue<Road>> nonVehicleRouting(Coordinate origCoord, Coordinate destCoord) {
        Road origRoad = cityContext.findRoadAtCoordinates(origCoord);
        Road destRoad = cityContext.findRoadAtCoordinates(destCoord);
        Junction origDownJunc = RouteV.getNearestDownStreamJunction(origRoad);
        Junction destDownJunc = RouteV.getNearestDownStreamJunction(destRoad);
        return vbr.computeRoute(origRoad, destRoad, origDownJunc, destDownJunc);
    }

    public static void printRoute(List<Road> path) {
        System.out.print("Route:");
        for (Road r : path) {
            System.out.print(" " + r.getLinkid());
        }
    }

    public static Coordinate getNearestRoadCoord(Coordinate coord) {
        double minDist = Double.MAX_VALUE;
        Coordinate nearestPoint = null;
        Point coordGeom = geomFac.createPoint(coord);
        block0: for (Road road : roadGeography.getObjectsWithin(coordGeom.buffer(big_buffer_distance).getEnvelopeInternal())) {
            DistanceOp distOp = new DistanceOp((Geometry)coordGeom, roadGeography.getGeometry((Object)road));
            double thisDist = distOp.distance();
            if (!(thisDist < minDist)) continue;
            minDist = thisDist;
            Coordinate[] coordinateArray = distOp.nearestPoints();
            int n = coordinateArray.length;
            int n2 = 0;
            while (n2 < n) {
                Coordinate c = coordinateArray[n2];
                if (!c.equals((Object)coord)) {
                    nearestPoint = c;
                    continue block0;
                }
                ++n2;
            }
        }
        return nearestPoint;
    }

    public static Junction getNearestJunction(Coordinate coord, Road road) {
        Junction j1 = null;
        Junction j2 = null;
        RepastEdge<?> edge = cityContext.getEdgeFromIDNum(road.getID());
        j1 = (Junction)edge.getSource();
        j2 = (Junction)edge.getTarget();
        Point coordGeom = geomFac.createPoint(coord);
        Point geom1 = geomFac.createPoint(junctionGeography.getGeometry((Object)j1).getCoordinate());
        Point geom2 = geomFac.createPoint(junctionGeography.getGeometry((Object)j2).getCoordinate());
        DistanceOp dist1 = new DistanceOp((Geometry)geom1, (Geometry)coordGeom);
        DistanceOp dist2 = new DistanceOp((Geometry)geom2, (Geometry)coordGeom);
        if (dist1.distance() < dist2.distance()) {
            return j1;
        }
        return j2;
    }

    public static Junction getNearestUpStreamJunction(Road road) {
        Junction j1 = null;
        RepastEdge<?> edge = cityContext.getEdgeFromIDNum(road.getID());
        j1 = (Junction)edge.getSource();
        return j1;
    }

    public static Junction getNearestDownStreamJunction(Road road) {
        Junction j1 = null;
        RepastEdge<?> edge = cityContext.getEdgeFromIDNum(road.getID());
        j1 = (Junction)edge.getTarget();
        return j1;
    }

    private static boolean onRoad(Coordinate coord) {
        return RoadContext.onRoad(coord);
    }
}

