/*
 * Decompiled with CFR 0.152.
 */
package evacSim.partition;

import evacSim.partition.MetisGraph;
import evacSim.partition.MetisNode;
import galois.objects.graph.GNode;
import galois.objects.graph.IntGraph;
import galois.objects.graph.MorphGraph;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.zip.GZIPInputStream;

public class Utility {
    public static IntGraph<MetisNode> getAllNodes(IntGraph<MetisNode> graph) {
        return graph;
    }

    private static Scanner getScanner(String filename) throws Exception {
        try {
            return new Scanner(new GZIPInputStream(new FileInputStream(String.valueOf(filename) + ".gz")));
        }
        catch (FileNotFoundException fnfe) {
            return new Scanner(new FileInputStream(filename));
        }
    }

    public static MetisGraph readGraph(String file) {
        try {
            Scanner scanner = Utility.getScanner(file);
            String line = scanner.nextLine().trim();
            String[] segs = line.split(" ");
            int nodeNum = Integer.valueOf(segs[0]);
            IntGraph<MetisNode> graph = new MorphGraph.IntGraphBuilder().backedByVector(true).directed(true).create();
            assert (graph != null);
            ArrayList<GNode<MetisNode>> nodes = new ArrayList<GNode<MetisNode>>();
            int i = 0;
            while (i < nodeNum) {
                GNode<MetisNode> n = graph.createNode(new MetisNode(i, 1));
                nodes.add(n);
                graph.add(n);
                ++i;
            }
            int numEdges = 0;
            int i2 = 0;
            while (i2 < nodeNum) {
                line = scanner.nextLine().trim();
                GNode n1 = (GNode)nodes.get(i2);
                segs = line.split(" ");
                int j = 0;
                while (j < segs.length) {
                    GNode n2 = (GNode)nodes.get(Integer.valueOf(segs[j]) - 1);
                    graph.addEdge(n1, n2, 1);
                    ((MetisNode)n1.getData()).addEdgeWeight(1);
                    ((MetisNode)n1.getData()).incNumEdges();
                    ++numEdges;
                    ++j;
                }
                ++i2;
            }
            MetisGraph metisGraph = new MetisGraph();
            metisGraph.setNumEdges(numEdges / 2);
            metisGraph.setGraph(graph);
            System.out.println("finished reading graph " + graph.size() + " " + metisGraph.getNumEdges());
            scanner.close();
            return metisGraph;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

