/*
 * Decompiled with CFR 0.152.
 */
package evacSim.partition;

import evacSim.partition.Balancer;
import evacSim.partition.FMTwoWayRefiner;
import evacSim.partition.MetisGraph;
import evacSim.partition.MetisNode;
import galois.objects.graph.GNode;
import galois.objects.graph.IntGraph;
import util.fn.Lambda2Void;
import util.fn.LambdaVoid;

public class Refiner {
    public static void refineTwoWay(MetisGraph metisGraph, MetisGraph orgGraph, int[] tpwgts) {
        metisGraph.computeTwoWayPartitionParams();
        while (!metisGraph.equals(orgGraph)) {
            Balancer.balanceTwoWay(metisGraph, tpwgts);
            FMTwoWayRefiner.fmTwoWayEdgeRefine(metisGraph, tpwgts, 8);
            Refiner.projectTwoWayPartition(metisGraph);
            metisGraph = metisGraph.getFinerGraph();
        }
        Balancer.balanceTwoWay(metisGraph, tpwgts);
        FMTwoWayRefiner.fmTwoWayEdgeRefine(metisGraph, tpwgts, 8);
    }

    private static void projectTwoWayPartition(MetisGraph metisGraph) {
        final MetisGraph finer = metisGraph.getFinerGraph();
        finer.setMinCut(metisGraph.getMinCut());
        finer.initPartWeight();
        finer.setPartWeight(0, metisGraph.getPartWeight(0));
        finer.setPartWeight(1, metisGraph.getPartWeight(1));
        final IntGraph<MetisNode> finerGraph = finer.getGraph();
        finerGraph.map(new LambdaVoid<GNode<MetisNode>>(){

            @Override
            public void call(GNode<MetisNode> node) {
                MetisNode nodeData = node.getData();
                nodeData.setPartition(nodeData.getMapTo().getData().getPartition());
                nodeData.setEdegree(0);
                nodeData.setIdegree(0);
                finer.unsetBoundaryNode(node);
            }
        });
        finerGraph.map(new LambdaVoid<GNode<MetisNode>>(){

            @Override
            public void call(GNode<MetisNode> node) {
                final MetisNode nodeData = node.getData();
                nodeData.setIdegree(nodeData.getAdjWgtSum());
                if (finerGraph.outNeighborsSize(node) != 0 && nodeData.getMapTo().getData().isBoundary()) {
                    node.map(new Lambda2Void<GNode<MetisNode>, GNode<MetisNode>>(){

                        @Override
                        public void call(GNode<MetisNode> neighbor, GNode<MetisNode> node) {
                            MetisNode neighborData = neighbor.getData();
                            if (nodeData.getPartition() != neighborData.getPartition()) {
                                nodeData.setEdegree(nodeData.getEdegree() + finerGraph.getEdgeData(node, neighbor));
                            }
                        }
                    }, node);
                }
                if (finerGraph.outNeighborsSize(node) != 0) {
                    nodeData.setIdegree(nodeData.getIdegree() - nodeData.getEdegree());
                }
                if (finerGraph.outNeighborsSize(node) == 0 || nodeData.getEdegree() > 0) {
                    finer.setBoundaryNode(node);
                }
            }
        });
    }
}

