/*
 * Decompiled with CFR 0.152.
 */
package evacSim.partition;

import evacSim.partition.MetisGraph;
import evacSim.partition.MetisNode;
import galois.objects.graph.GNode;
import galois.objects.graph.IntGraph;
import galois.runtime.ForeachContext;
import galois.runtime.GaloisRuntime;
import galois.runtime.wl.Priority;
import galois.runtime.wl.RandomPermutation;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.concurrent.ExecutionException;
import util.fn.Lambda2Void;
import util.fn.LambdaVoid;

public class RandomKwayEdgeRefiner {
    private float[] tpwgts;
    private float ubfactor;
    private float npasses;
    private int ffactor;
    private int nparts;
    private int[] minwgts;
    private int[] maxwgts;
    private int[] itpwgts;

    public RandomKwayEdgeRefiner(float[] tpwgts, int nparts, float ubfactor, int npasses, int ffactor) {
        this.tpwgts = tpwgts;
        this.nparts = nparts;
        this.ubfactor = ubfactor;
        this.npasses = npasses;
        this.ffactor = ffactor;
        this.minwgts = new int[nparts];
        this.maxwgts = new int[nparts];
        this.itpwgts = new int[nparts];
    }

    public void refine(final MetisGraph metisGraph) throws ExecutionException {
        int tvwgt = 0;
        int i = 0;
        while (i < this.nparts) {
            tvwgt += metisGraph.getPartWeight(i);
            ++i;
        }
        i = 0;
        while (i < this.nparts) {
            this.itpwgts[i] = (int)(this.tpwgts[i] * (float)tvwgt);
            this.maxwgts[i] = (int)(this.tpwgts[i] * (float)tvwgt * this.ubfactor);
            this.minwgts[i] = (int)((double)(this.tpwgts[i] * (float)tvwgt) * (1.0 / (double)this.ubfactor));
            ++i;
        }
        int pass = 0;
        while ((float)pass < this.npasses) {
            int oldcut = metisGraph.getMinCut();
            LinkedHashSet<GNode<MetisNode>> boundary = new LinkedHashSet<GNode<MetisNode>>();
            boundary.addAll(metisGraph.getBoundaryNodes());
            GaloisRuntime.foreach(boundary, new Lambda2Void<GNode<MetisNode>, ForeachContext<GNode<MetisNode>>>(){

                @Override
                public void call(GNode<MetisNode> node, ForeachContext<GNode<MetisNode>> ctx) {
                    RandomKwayEdgeRefiner.this.refineOneNode(metisGraph, node);
                }
            }, Priority.first(RandomPermutation.class, new Object[0]));
            if (metisGraph.getMinCut() == oldcut) break;
            ++pass;
        }
    }

    private void refineOneNode(final MetisGraph metisGraph, GNode<MetisNode> n) {
        final IntGraph<MetisNode> graph = metisGraph.getGraph();
        MetisNode nodeData = n.getData((byte)1, (byte)0);
        if (nodeData.getEdegree() >= nodeData.getIdegree()) {
            int from = nodeData.getPartition();
            int from_weight = metisGraph.getPartWeight(from, (byte)1);
            int vwgt = nodeData.getWeight();
            if (nodeData.getIdegree() > 0 && from_weight - vwgt < this.minwgts[from]) {
                return;
            }
            int k = 0;
            int to = 0;
            long id = nodeData.getIdegree();
            k = 0;
            while (k < nodeData.getNDegrees()) {
                long gain = (long)nodeData.partEd[k] - id;
                if (gain >= 0L && (long)(metisGraph.getPartWeight(to = nodeData.partIndex[k], (byte)1) + vwgt) <= (long)this.maxwgts[to] + (long)this.ffactor * gain && gain >= 0L) break;
                ++k;
            }
            if (k == nodeData.getNDegrees()) {
                return;
            }
            int j = k + 1;
            while (j < nodeData.getNDegrees()) {
                to = nodeData.partIndex[j];
                int to_weight = metisGraph.getPartWeight(to, (byte)1);
                if (nodeData.partEd[j] > nodeData.partEd[k] && to_weight + vwgt <= this.maxwgts[to] || nodeData.partEd[j] == nodeData.partEd[k] && this.itpwgts[nodeData.partIndex[k]] * to_weight < this.itpwgts[to] * metisGraph.getPartWeight(nodeData.partIndex[k], (byte)1)) {
                    k = j;
                }
                ++j;
            }
            to = nodeData.partIndex[k];
            int to_weight = metisGraph.getPartWeight(to, (byte)1);
            boolean j2 = false;
            if (nodeData.partEd[k] - nodeData.getIdegree() > 0) {
                j2 = true;
            } else if (nodeData.partEd[k] - nodeData.getIdegree() == 0 && (from_weight >= this.maxwgts[from] || this.itpwgts[from] * (to_weight + vwgt) < this.itpwgts[to] * from_weight)) {
                j2 = true;
            }
            if (!j2) {
                return;
            }
            if (!GaloisRuntime.getRuntime().useSerial()) {
                n.map(new LambdaVoid<GNode<MetisNode>>(){

                    @Override
                    public void call(GNode<MetisNode> arg0) {
                    }
                }, (byte)1);
            }
            metisGraph.incMinCut(-(nodeData.partEd[k] - nodeData.getIdegree()));
            nodeData.setPartition(to);
            metisGraph.incPartWeight(to, vwgt);
            metisGraph.incPartWeight(from, -vwgt);
            nodeData.setEdegree(nodeData.getEdegree() + nodeData.getIdegree() - nodeData.partEd[k]);
            int temp = nodeData.getIdegree();
            nodeData.setIdegree(nodeData.partEd[k]);
            nodeData.partEd[k] = temp;
            if (nodeData.partEd[k] == 0) {
                nodeData.setNDegrees(nodeData.getNDegrees() - 1);
                nodeData.partEd[k] = nodeData.partEd[nodeData.getNDegrees()];
                nodeData.partIndex[k] = nodeData.partIndex[nodeData.getNDegrees()];
            } else {
                nodeData.partIndex[k] = from;
            }
            if (nodeData.getEdegree() - nodeData.getIdegree() < 0) {
                metisGraph.unsetBoundaryNode(n);
            }
            final int fromConst = from;
            final int toConst = to;
            n.map(new Lambda2Void<GNode<MetisNode>, GNode<MetisNode>>(){

                @Override
                public void call(GNode<MetisNode> neighbor, GNode<MetisNode> node) {
                    int i;
                    MetisNode neighborData = neighbor.getData((byte)0, (byte)0);
                    if (neighborData.partEd == null) {
                        int numEdges = neighborData.getNumEdges();
                        int ndegree = neighborData.getNDegrees();
                        if (ndegree + 1 <= numEdges) {
                            neighborData.partIndex = new int[numEdges];
                            neighborData.partEd = new int[numEdges];
                        } else {
                            neighborData.partIndex = new int[ndegree + 1];
                            neighborData.partEd = new int[ndegree + 1];
                        }
                    }
                    int edgeWeight = graph.getEdgeData(node, neighbor, (byte)0);
                    if (neighborData.getPartition() == fromConst) {
                        neighborData.setEdegree(neighborData.getEdegree() + edgeWeight);
                        neighborData.setIdegree(neighborData.getIdegree() - edgeWeight);
                        if (neighborData.getEdegree() - neighborData.getIdegree() >= 0 && !neighborData.isBoundary()) {
                            metisGraph.setBoundaryNode(neighbor);
                        }
                    } else if (neighborData.getPartition() == toConst) {
                        neighborData.setEdegree(neighborData.getEdegree() - edgeWeight);
                        neighborData.setIdegree(neighborData.getIdegree() + edgeWeight);
                        if (neighborData.getEdegree() - neighborData.getIdegree() < 0 && neighborData.isBoundary()) {
                            metisGraph.unsetBoundaryNode(neighbor);
                        }
                    }
                    if (neighborData.getPartition() != fromConst) {
                        i = 0;
                        while (i < neighborData.getNDegrees()) {
                            if (neighborData.partIndex[i] == fromConst) {
                                if (neighborData.partEd[i] == edgeWeight) {
                                    neighborData.setNDegrees(neighborData.getNDegrees() - 1);
                                    neighborData.partEd[i] = neighborData.partEd[neighborData.getNDegrees()];
                                    neighborData.partIndex[i] = neighborData.partIndex[neighborData.getNDegrees()];
                                    break;
                                }
                                int n = i;
                                neighborData.partEd[n] = neighborData.partEd[n] - edgeWeight;
                                break;
                            }
                            ++i;
                        }
                    }
                    if (neighborData.getPartition() != toConst) {
                        i = 0;
                        while (i < neighborData.getNDegrees()) {
                            if (neighborData.partIndex[i] == toConst) {
                                int n = i;
                                neighborData.partEd[n] = neighborData.partEd[n] + edgeWeight;
                                break;
                            }
                            ++i;
                        }
                        if (i == neighborData.getNDegrees()) {
                            int nd = neighborData.getNDegrees();
                            if (nd >= neighborData.partIndex.length) {
                                neighborData.partIndex = Arrays.copyOf(neighborData.partIndex, nd + 1);
                                neighborData.partEd = Arrays.copyOf(neighborData.partEd, nd + 1);
                            }
                            neighborData.partIndex[nd] = toConst;
                            neighborData.partEd[nd++] = edgeWeight;
                            neighborData.setNDegrees(nd);
                        }
                    }
                }
            }, n, (byte)0);
        }
    }
}

