/*
 * Decompiled with CFR 0.152.
 */
package evacSim.partition;

import evacSim.partition.MetisNode;
import galois.objects.graph.GNode;
import galois.objects.graph.IntGraph;
import util.fn.Lambda2Void;
import util.fn.LambdaVoid;

public class RMMatchingStrategy
implements LambdaVoid<GNode<MetisNode>> {
    private int maxVertexWeight;
    IntGraph<MetisNode> graph;
    IntGraph<MetisNode> coarseGraph;

    public RMMatchingStrategy(IntGraph<MetisNode> graph, IntGraph<MetisNode> coarseGraph, int maxVertexWeight) {
        this.coarseGraph = coarseGraph;
        this.graph = graph;
        this.maxVertexWeight = maxVertexWeight;
    }

    @Override
    public void call(GNode<MetisNode> node) {
        MetisNode nodeData = node.getData((byte)1, (byte)0);
        if (nodeData.isMatched()) {
            return;
        }
        FindMatchNodeClosure closure = new FindMatchNodeClosure(node);
        node.map(closure, node, (byte)1);
        GNode<MetisNode> matchNode = closure.match;
        MetisNode maxNodeData = matchNode.getData((byte)0, (byte)0);
        nodeData.setMatch(matchNode);
        maxNodeData.setMatch(node);
        int weight = nodeData.getWeight();
        if (node != matchNode) {
            weight += maxNodeData.getWeight();
        }
        MetisNode newNodeData = new MetisNode(weight);
        GNode<MetisNode> newNode = this.coarseGraph.createNode(newNodeData);
        this.coarseGraph.add(newNode);
        nodeData.setMapTo(newNode);
        maxNodeData.setMapTo(newNode);
    }

    private class FindMatchNodeClosure
    implements Lambda2Void<GNode<MetisNode>, GNode<MetisNode>> {
        GNode<MetisNode> match;

        public FindMatchNodeClosure(GNode<MetisNode> node) {
            this.match = node;
        }

        @Override
        public void call(GNode<MetisNode> neighbor, GNode<MetisNode> src) {
            MetisNode neighMNode = neighbor.getData((byte)0, (byte)0);
            if (!neighMNode.isMatched() && src.getData((byte)0, (byte)0).getWeight() + neighMNode.getWeight() <= RMMatchingStrategy.this.maxVertexWeight && this.match == src) {
                this.match = neighbor;
            }
        }
    }
}

