/*
 * Decompiled with CFR 0.152.
 */
package evacSim.partition;

import evacSim.ContextCreator;
import evacSim.GlobalVariables;
import evacSim.citycontext.Road;
import evacSim.partition.Coarsener;
import evacSim.partition.GaliosGraphConverter;
import evacSim.partition.KWayRefiner;
import evacSim.partition.MetisGraph;
import evacSim.partition.MetisNode;
import evacSim.partition.PMetis;
import galois.objects.graph.IntGraph;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import util.Launcher;

public class MetisPartition {
    private int npartition;
    private ArrayList<ArrayList<Road>> PartitionedInRoads;
    private ArrayList<Road> PartitionedBwRoads;
    private int partition_duration;

    public MetisPartition(int nparts) {
        this.npartition = nparts;
        this.PartitionedInRoads = new ArrayList();
        this.PartitionedBwRoads = new ArrayList();
        new ArrayList();
        this.partition_duration = 0;
    }

    public ArrayList<ArrayList<Road>> getPartitionedInRoads() {
        return this.PartitionedInRoads;
    }

    public ArrayList<Road> getPartitionedBwRoads() {
        return this.PartitionedBwRoads;
    }

    public void first_run() throws NumberFormatException, ExecutionException {
        GaliosGraphConverter graphConverter = new GaliosGraphConverter();
        MetisGraph metisGraph = graphConverter.RepastToGaliosGraph(true);
        System.out.println("Metis Running...");
        if (Launcher.getLauncher().isFirstRun()) {
            System.err.println("Configuration");
            System.err.println("-------------");
            System.err.println(" Num of partitions: " + this.npartition);
            System.err.println("Graph size: " + metisGraph.getGraph().size() + " nodes and " + metisGraph.getNumEdges() + " edges");
            System.err.println();
        }
        System.gc();
        long time = System.nanoTime();
        Launcher.getLauncher().startTiming();
        IntGraph<MetisNode> resultGraph = this.partition(metisGraph, this.npartition);
        Launcher.getLauncher().stopTiming();
        time = (System.nanoTime() - time) / 1000000L;
        System.err.println("runtime: " + time + " ms");
        graphConverter.GaliosToRepastGraph(resultGraph, this.npartition);
        this.PartitionedInRoads = graphConverter.getPartitionedInRoads();
        this.PartitionedBwRoads = graphConverter.getPartitionedBwRoads();
        graphConverter.getPartitionWeights();
    }

    public void check_run() throws NumberFormatException, ExecutionException {
        int TotVehNum = 0;
        for (Road road : ContextCreator.getRoadGeography().getAllObjects()) {
            TotVehNum += road.getVehicleNum();
        }
        if (TotVehNum >= GlobalVariables.THRESHOLD_VEHICLE_NUMBER) {
            try {
                this.run();
            }
            catch (Exception e) {
                System.out.println("Partition failed...");
                this.partition_duration += GlobalVariables.SIMULATION_PARTITION_REFRESH_INTERVAL;
            }
        } else {
            this.partition_duration += GlobalVariables.SIMULATION_PARTITION_REFRESH_INTERVAL;
        }
    }

    public void run() throws NumberFormatException, ExecutionException, NullPointerException {
        GaliosGraphConverter graphConverter = new GaliosGraphConverter();
        MetisGraph metisGraph = graphConverter.RepastToGaliosGraph(false);
        try {
            ContextCreator.bw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.gc();
        long time = System.nanoTime();
        Launcher.getLauncher().startTiming();
        IntGraph<MetisNode> resultGraph = this.partition(metisGraph, this.npartition);
        Launcher.getLauncher().stopTiming();
        time = (System.nanoTime() - time) / 1000000L;
        graphConverter.GaliosToRepastGraph(resultGraph, this.npartition);
        this.PartitionedInRoads = graphConverter.getPartitionedInRoads();
        this.PartitionedBwRoads = graphConverter.getPartitionedBwRoads();
        graphConverter.getPartitionWeights();
    }

    public IntGraph<MetisNode> partition(MetisGraph metisGraph, int nparts) throws ExecutionException, ArrayIndexOutOfBoundsException {
        IntGraph<MetisNode> graph = metisGraph.getGraph();
        int coarsenTo = (int)Math.max((double)graph.size() / (40.0 * Math.log(nparts)), (double)(20 * nparts));
        int maxVertexWeight = (int)(1.5 * ((double)graph.size() / (double)coarsenTo));
        Coarsener coarsener = new Coarsener(false, coarsenTo, maxVertexWeight);
        long time = System.nanoTime();
        MetisGraph mcg = coarsener.coarsen(metisGraph);
        time = (System.nanoTime() - time) / 1000000L;
        MetisGraph.nparts = 2;
        float[] totalPartitionWeights = new float[nparts];
        Arrays.fill(totalPartitionWeights, 1.0f / (float)nparts);
        time = System.nanoTime();
        maxVertexWeight = (int)(1.5 * ((double)mcg.getGraph().size() / 0.9));
        PMetis pmetis = new PMetis(20, maxVertexWeight);
        pmetis.mlevelRecursiveBisection(mcg, nparts, totalPartitionWeights, 0, 0);
        time = (System.nanoTime() - time) / 1000000L;
        MetisGraph.nparts = nparts;
        time = System.nanoTime();
        Arrays.fill(totalPartitionWeights, 1.0f / (float)nparts);
        KWayRefiner refiner = new KWayRefiner();
        refiner.refineKWay(mcg, metisGraph, totalPartitionWeights, 1.03f, nparts);
        time = (System.nanoTime() - time) / 1000000L;
        return metisGraph.getGraph();
    }

    public void verify(MetisGraph metisGraph) {
        if (!metisGraph.verify()) {
            System.err.println("KMetis verify not passed!");
        }
        System.err.println("KMetis okay");
        System.err.println();
    }
}

