/*
 * Decompiled with CFR 0.152.
 */
package evacSim.partition;

import evacSim.partition.MetisNode;
import galois.objects.Accumulator;
import galois.objects.AccumulatorBuilder;
import galois.objects.GMutableInteger;
import galois.objects.GMutableIntegerBuilder;
import galois.objects.GSet;
import galois.objects.GSetBuilder;
import galois.objects.graph.GNode;
import galois.objects.graph.IntGraph;
import java.util.Set;
import util.fn.Lambda2Void;
import util.fn.LambdaVoid;

public class MetisGraph {
    private GMutableInteger[] partWeights;
    private Accumulator mincut;
    private Accumulator numEdges;
    private MetisGraph finerGraph;
    private IntGraph<MetisNode> graph;
    private GSet<GNode<MetisNode>> boundaryNodes;
    static int nparts;

    public MetisGraph() {
        AccumulatorBuilder accuBuilder = new AccumulatorBuilder();
        this.mincut = accuBuilder.create();
        this.numEdges = accuBuilder.create();
        this.boundaryNodes = new GSetBuilder().create();
    }

    public void incPartWeight(int index, int weight) {
        int oldWeight = this.partWeights[index].get((byte)0);
        this.partWeights[index].set(oldWeight + weight, (byte)0);
    }

    public void initPartWeight() {
        if (this.partWeights == null) {
            this.partWeights = new GMutableInteger[nparts];
            GMutableIntegerBuilder intBuilder = new GMutableIntegerBuilder();
            int i = 0;
            while (i < this.partWeights.length) {
                this.partWeights[i] = intBuilder.create();
                ++i;
            }
        }
    }

    public void setPartWeight(int index, int weight) {
        this.partWeights[index].set(weight, (byte)0);
    }

    public int getPartWeight(int part, byte flags) {
        return this.partWeights[part].get(flags);
    }

    public int getPartWeight(int part) {
        return this.partWeights[part].get();
    }

    public void incNumEdges() {
        this.numEdges.add(1, (byte)0);
    }

    public int getNumEdges() {
        return this.numEdges.get();
    }

    public void setNumEdges(int num) {
        this.numEdges.set(num);
    }

    public void computeTwoWayPartitionParams() {
        this.partWeights = new GMutableInteger[2];
        GMutableIntegerBuilder builder = new GMutableIntegerBuilder();
        int i = 0;
        while (i < this.partWeights.length) {
            this.partWeights[i] = builder.create((byte)0);
            ++i;
        }
        this.unsetAllBoundaryNodes();
        ComputeTwoWayPartitionParamsClosure closure = new ComputeTwoWayPartitionParamsClosure();
        this.graph.map(closure, (byte)0);
        this.mincut.set(closure.getMinCut() / 2);
    }

    public int getMaxAdjSum() {
        MaxAdjSumClosure closure = new MaxAdjSumClosure();
        this.graph.map(closure, (byte)0);
        return closure.getMaxAdjSum();
    }

    public void computeKWayPartitionParams(int nparts) {
        this.unsetAllBoundaryNodes();
        GMutableIntegerBuilder intBuilder = new GMutableIntegerBuilder();
        this.partWeights = new GMutableInteger[nparts];
        int i = 0;
        while (i < this.partWeights.length) {
            this.partWeights[i] = intBuilder.create();
            ++i;
        }
        ComputeKWayPartitionParamsClosure closure = new ComputeKWayPartitionParamsClosure();
        this.graph.map(closure, (byte)0);
        this.setMinCut(closure.getMinCut() / 2);
    }

    public void updateNodeEdAndId(GNode<MetisNode> n) {
        ComputeEdAndIdClosure closure = new ComputeEdAndIdClosure();
        n.map(closure, n, (byte)0);
        MetisNode nodeData = n.getData((byte)0);
        nodeData.setEdegree(closure.getEd());
        nodeData.setIdegree(closure.getId());
    }

    public IntGraph<MetisNode> getGraph() {
        return this.graph;
    }

    public void setGraph(IntGraph<MetisNode> graph) {
        this.graph = graph;
    }

    public MetisGraph getFinerGraph() {
        return this.finerGraph;
    }

    public void setFinerGraph(MetisGraph finer) {
        this.finerGraph = finer;
    }

    public int getMinCut() {
        int retval = 0;
        retval = this.mincut.get();
        return retval;
    }

    public void setMinCut(int cut) {
        this.mincut.set(cut);
    }

    public void incMinCut(int cut) {
        this.mincut.add(cut, (byte)0);
    }

    public int getNumOfBoundaryNodes() {
        return this.boundaryNodes.size();
    }

    public void setBoundaryNode(GNode<MetisNode> node) {
        node.getData((byte)0).setBoundary(true);
        this.boundaryNodes.add(node, (byte)0);
    }

    public void unsetBoundaryNode(GNode<MetisNode> node) {
        node.getData((byte)0).setBoundary(false);
        this.boundaryNodes.remove(node, (byte)0);
    }

    public void unsetAllBoundaryNodes() {
        for (GNode<MetisNode> node : this.boundaryNodes) {
            node.getData((byte)0).setBoundary(false);
        }
        this.boundaryNodes.clear((byte)0);
    }

    public Set<GNode<MetisNode>> getBoundaryNodes() {
        return this.boundaryNodes;
    }

    public void computeAdjWgtSums() {
        this.graph.map(new LambdaVoid<GNode<MetisNode>>(){

            @Override
            public void call(GNode<MetisNode> node) {
                node.getData((byte)0).setAdjWgtSum(MetisGraph.this.computeAdjWgtSum(node));
            }
        }, (byte)0);
    }

    public int computeCut() {
        ComputeCutClosure closure = new ComputeCutClosure();
        this.graph.map(closure, (byte)0);
        return closure.getCut();
    }

    public int computeEdges() {
        ComputeEdgesClosure closure = new ComputeEdgesClosure();
        this.graph.map(closure, (byte)0);
        return closure.getNum() / 2;
    }

    public int computeAdjWgtSum(GNode<MetisNode> n) {
        ComputeAdjWgtSumClosure closure = new ComputeAdjWgtSumClosure();
        n.map(closure, n, (byte)0);
        return closure.getNum();
    }

    public boolean verify() {
        if (this.mincut.get() == this.computeCut()) {
            return true;
        }
        System.err.println("mincut is computed wrongly:" + this.mincut.get() + " is not equal " + this.computeCut());
        return false;
    }

    public boolean isBalanced(float[] tpwgts, float ubfactor) {
        int sum = 0;
        int i = 0;
        while (i < nparts) {
            sum += this.partWeights[i].get((byte)0);
            ++i;
        }
        i = 0;
        while (i < nparts) {
            if ((double)this.partWeights[i].get((byte)0) > (double)(tpwgts[i] * (float)sum) * ((double)ubfactor + 0.005)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void computeKWayBalanceBoundary() {
        this.unsetAllBoundaryNodes();
        this.graph.map(new LambdaVoid<GNode<MetisNode>>(){

            @Override
            public void call(GNode<MetisNode> node) {
                if (node.getData().getEdegree() > 0) {
                    MetisGraph.this.setBoundaryNode(node);
                }
            }
        });
    }

    public void computeKWayBoundary() {
        this.unsetAllBoundaryNodes();
        this.graph.map(new LambdaVoid<GNode<MetisNode>>(){

            @Override
            public void call(GNode<MetisNode> node) {
                MetisNode nodeData = node.getData();
                if (nodeData.getEdegree() - nodeData.getIdegree() >= 0) {
                    MetisGraph.this.setBoundaryNode(node);
                }
            }
        });
    }

    class ComputeAdjWgtSumClosure
    implements Lambda2Void<GNode<MetisNode>, GNode<MetisNode>> {
        int num;

        ComputeAdjWgtSumClosure() {
        }

        @Override
        public void call(GNode<MetisNode> neighbor, GNode<MetisNode> node) {
            int weight = MetisGraph.this.graph.getEdgeData(node, neighbor, (byte)0);
            this.num += weight;
        }

        public int getNum() {
            return this.num;
        }
    }

    class ComputeCutClosure
    implements LambdaVoid<GNode<MetisNode>> {
        int cut = 0;

        ComputeCutClosure() {
        }

        @Override
        public void call(GNode<MetisNode> node) {
            node.map(new Lambda2Void<GNode<MetisNode>, GNode<MetisNode>>(){

                @Override
                public void call(GNode<MetisNode> neighbor, GNode<MetisNode> node) {
                    if (neighbor.getData((byte)0).getPartition() != node.getData((byte)0).getPartition()) {
                        int edgeWeight = MetisGraph.this.graph.getEdgeData(node, neighbor, (byte)0);
                        ComputeCutClosure.this.cut += edgeWeight;
                    }
                }
            }, node, (byte)0);
        }

        public int getCut() {
            return this.cut / 2;
        }
    }

    class ComputeEdAndIdClosure
    implements Lambda2Void<GNode<MetisNode>, GNode<MetisNode>> {
        int ed;
        int id;

        ComputeEdAndIdClosure() {
        }

        @Override
        public void call(GNode<MetisNode> neighbor, GNode<MetisNode> node) {
            int weight = MetisGraph.this.graph.getEdgeData(node, neighbor, (byte)0);
            if (node.getData((byte)0).getPartition() != neighbor.getData((byte)0).getPartition()) {
                this.ed += weight;
            } else {
                this.id += weight;
            }
        }

        public int getEd() {
            return this.ed;
        }

        public int getId() {
            return this.id;
        }
    }

    class ComputeEdgesClosure
    implements LambdaVoid<GNode<MetisNode>> {
        int num;

        ComputeEdgesClosure() {
        }

        @Override
        public void call(GNode<MetisNode> node) {
            this.num += MetisGraph.this.graph.outNeighborsSize(node, (byte)0);
        }

        public int getNum() {
            return this.num;
        }
    }

    class ComputeKWayPartitionParamsClosure
    implements LambdaVoid<GNode<MetisNode>> {
        int mincut;

        ComputeKWayPartitionParamsClosure() {
        }

        @Override
        public void call(GNode<MetisNode> node) {
            final MetisNode nodeData = node.getData((byte)0);
            final int me = nodeData.getPartition();
            MetisGraph.this.partWeights[me].set(MetisGraph.this.partWeights[me].get() + nodeData.getWeight(), (byte)0);
            MetisGraph.this.updateNodeEdAndId(node);
            if (nodeData.getEdegree() > 0) {
                this.mincut += nodeData.getEdegree();
                int numEdges = MetisGraph.this.graph.outNeighborsSize(node, (byte)0);
                nodeData.partIndex = new int[numEdges];
                nodeData.partEd = new int[numEdges];
                node.map(new Lambda2Void<GNode<MetisNode>, GNode<MetisNode>>(){

                    @Override
                    public void call(GNode<MetisNode> neighbor, GNode<MetisNode> node) {
                        MetisNode neighborData = neighbor.getData((byte)0);
                        if (me != neighborData.getPartition()) {
                            int edgeWeight = MetisGraph.this.graph.getEdgeData(node, neighbor, (byte)0);
                            int k = 0;
                            while (k < nodeData.getNDegrees()) {
                                if (nodeData.partIndex[k] == neighborData.getPartition()) {
                                    int n = k;
                                    nodeData.partEd[n] = nodeData.partEd[n] + edgeWeight;
                                    break;
                                }
                                ++k;
                            }
                            if (k == nodeData.getNDegrees()) {
                                nodeData.partIndex[nodeData.getNDegrees()] = neighborData.getPartition();
                                nodeData.partEd[nodeData.getNDegrees()] = edgeWeight;
                                nodeData.setNDegrees(nodeData.getNDegrees() + 1);
                            }
                        }
                    }
                }, node, (byte)0);
            }
            if (nodeData.getEdegree() - nodeData.getIdegree() > 0) {
                MetisGraph.this.setBoundaryNode(node);
            }
        }

        public int getMinCut() {
            return this.mincut;
        }
    }

    class ComputeTwoWayPartitionParamsClosure
    implements LambdaVoid<GNode<MetisNode>> {
        int mincut = 0;

        @Override
        public void call(GNode<MetisNode> node) {
            MetisNode nodeData = node.getData((byte)0);
            int me = nodeData.getPartition();
            MetisGraph.this.partWeights[me].set(MetisGraph.this.partWeights[me].get() + nodeData.getWeight(), (byte)0);
            MetisGraph.this.updateNodeEdAndId(node);
            if (nodeData.getEdegree() > 0 || MetisGraph.this.graph.outNeighborsSize(node, (byte)0) == 0) {
                this.mincut += nodeData.getEdegree();
                MetisGraph.this.setBoundaryNode(node);
            }
        }

        public int getMinCut() {
            return this.mincut;
        }
    }

    class MaxAdjSumClosure
    implements LambdaVoid<GNode<MetisNode>> {
        int maxAdjSum = -1;

        @Override
        public void call(GNode<MetisNode> node) {
            int adjwgtsum = node.getData((byte)0).getAdjWgtSum();
            if (this.maxAdjSum < adjwgtsum) {
                this.maxAdjSum = adjwgtsum;
            }
        }

        public int getMaxAdjSum() {
            return this.maxAdjSum;
        }
    }
}

