/*
 * Decompiled with CFR 0.152.
 */
package evacSim.partition;

import evacSim.partition.Balancer;
import evacSim.partition.MetisGraph;
import evacSim.partition.MetisNode;
import evacSim.partition.RandomKwayEdgeRefiner;
import evacSim.partition.Utility;
import galois.objects.graph.GNode;
import galois.objects.graph.IntGraph;
import galois.runtime.ForeachContext;
import galois.runtime.GaloisRuntime;
import galois.runtime.wl.Priority;
import galois.runtime.wl.RandomPermutation;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import util.fn.Lambda2Void;
import util.fn.LambdaVoid;

public class KWayRefiner {
    public void refineKWay(MetisGraph metisGraph, MetisGraph orgGraph, float[] tpwgts, float ubfactor, int nparts) throws ExecutionException {
        metisGraph.computeKWayPartitionParams(nparts);
        int nlevels = 0;
        MetisGraph metisGraphTemp = metisGraph;
        while (!metisGraphTemp.equals(orgGraph)) {
            metisGraphTemp = metisGraphTemp.getFinerGraph();
            ++nlevels;
        }
        int i = 0;
        RandomKwayEdgeRefiner rkRefiner = new RandomKwayEdgeRefiner(tpwgts, nparts, ubfactor, 10, 1);
        while (!metisGraph.equals(orgGraph)) {
            if (2 * i >= nlevels && !metisGraph.isBalanced(tpwgts, 1.04f * ubfactor)) {
                metisGraph.computeKWayBalanceBoundary();
                Balancer.greedyKWayEdgeBalance(metisGraph, nparts, tpwgts, ubfactor, 8);
                metisGraph.computeKWayBoundary();
            }
            rkRefiner.refine(metisGraph);
            this.projectKWayPartition(metisGraph, nparts);
            metisGraph = metisGraph.getFinerGraph();
            ++i;
        }
        if (2 * i >= nlevels && !metisGraph.isBalanced(tpwgts, 1.04f * ubfactor)) {
            metisGraph.computeKWayBalanceBoundary();
            Balancer.greedyKWayEdgeBalance(metisGraph, nparts, tpwgts, ubfactor, 8);
            metisGraph.computeKWayBoundary();
        }
        rkRefiner.refine(metisGraph);
        if (!metisGraph.isBalanced(tpwgts, ubfactor)) {
            metisGraph.computeKWayBalanceBoundary();
            Balancer.greedyKWayEdgeBalance(metisGraph, nparts, tpwgts, ubfactor, 8);
            rkRefiner.refine(metisGraph);
        }
    }

    public void projectKWayPartition(MetisGraph metisGraph, int nparts) throws ExecutionException {
        MetisGraph finer = metisGraph.getFinerGraph();
        IntGraph<MetisNode> coarseGraph = metisGraph.getGraph();
        IntGraph<MetisNode> graph = finer.getGraph();
        graph.map(new LambdaVoid<GNode<MetisNode>>(){

            @Override
            public void call(GNode<MetisNode> node) {
                MetisNode nodeData = node.getData();
                nodeData.setPartition(nodeData.getMapTo().getData().getPartition());
            }
        });
        KWayRefiner.computeKWayPartInfo(nparts, finer, coarseGraph, graph);
        finer.initPartWeight();
        int i = 0;
        while (i < nparts) {
            finer.setPartWeight(i, metisGraph.getPartWeight(i));
            ++i;
        }
        finer.setMinCut(metisGraph.getMinCut());
    }

    private static void computeKWayPartInfo(final int nparts, final MetisGraph finer, IntGraph<MetisNode> coarseGraph, final IntGraph<MetisNode> graph) throws ExecutionException {
        GaloisRuntime.foreach(Utility.getAllNodes(graph), new Lambda2Void<GNode<MetisNode>, ForeachContext<GNode<MetisNode>>>(){

            @Override
            public void call(GNode<MetisNode> node, ForeachContext<GNode<MetisNode>> ctx) {
                MetisNode nodeData = node.getData((byte)0, (byte)0);
                int numEdges = graph.outNeighborsSize(node, (byte)0);
                nodeData.partIndex = new int[numEdges];
                nodeData.partEd = new int[numEdges];
                nodeData.setIdegree(nodeData.getAdjWgtSum());
                if (nodeData.getMapTo().getData((byte)0, (byte)0).getEdegree() > 0) {
                    int[] map = new int[nparts];
                    ProjectNeighborInKWayPartitionClosure closure = new ProjectNeighborInKWayPartitionClosure(graph, map, nodeData);
                    node.map(closure, node, (byte)0);
                    nodeData.setEdegree(closure.ed);
                    nodeData.setIdegree(nodeData.getIdegree() - nodeData.getEdegree());
                    if (nodeData.getEdegree() - nodeData.getIdegree() >= 0) {
                        finer.setBoundaryNode(node);
                    }
                    nodeData.setNDegrees(closure.ndegrees);
                }
            }
        }, Priority.first(RandomPermutation.class, new Object[0]));
    }

    static class ProjectNeighborInKWayPartitionClosure
    implements Lambda2Void<GNode<MetisNode>, GNode<MetisNode>> {
        MetisNode nodeData;
        int ed;
        int[] map;
        int ndegrees;
        IntGraph<MetisNode> graph;

        public ProjectNeighborInKWayPartitionClosure(IntGraph<MetisNode> graph, int[] map, MetisNode nodeData) {
            this.graph = graph;
            this.map = map;
            this.nodeData = nodeData;
            Arrays.fill(map, -1);
        }

        @Override
        public void call(GNode<MetisNode> neighbor, GNode<MetisNode> node) {
            MetisNode neighborData = neighbor.getData((byte)0);
            if (this.nodeData.getPartition() != neighborData.getPartition()) {
                int edgeWeight = this.graph.getEdgeData(node, neighbor, (byte)0);
                this.ed += edgeWeight;
                int index = this.map[neighborData.getPartition()];
                if (index == -1) {
                    this.map[neighborData.getPartition()] = this.ndegrees;
                    this.nodeData.partIndex[this.ndegrees] = neighborData.getPartition();
                    int n = this.ndegrees++;
                    this.nodeData.partEd[n] = this.nodeData.partEd[n] + edgeWeight;
                } else {
                    int n = index;
                    this.nodeData.partEd[n] = this.nodeData.partEd[n] + edgeWeight;
                }
            }
        }
    }
}

