/*
 * Decompiled with CFR 0.152.
 */
package evacSim.partition;

import evacSim.partition.Balancer;
import evacSim.partition.FMTwoWayRefiner;
import evacSim.partition.MetisGraph;
import evacSim.partition.MetisNode;
import evacSim.partition.PMetis;
import galois.objects.graph.GNode;
import galois.objects.graph.IntGraph;
import java.util.Arrays;
import java.util.Random;
import util.Launcher;
import util.fn.Lambda2Void;
import util.fn.LambdaVoid;

public class GrowBisection {
    public static final int SMALL_NUM_ITER_PARTITION = 3;
    public static final int LARGE_NUM_ITER_PARTITION = 8;
    private static Random random = Launcher.getLauncher().getRandom(0);

    public static void bisection(MetisGraph metisGraph, int[] tpwgts, int coarsenTo) {
        IntGraph<MetisNode> graph = metisGraph.getGraph();
        int numNodes = graph.size();
        GNode[] nodes = new GNode[numNodes];
        graph.map(new SaveNodesToArray(nodes));
        int nbfs = numNodes <= coarsenTo ? 3 : 8;
        int maxWgtPart1 = (int)PMetis.UB_FACTOR * tpwgts[1];
        int minWgtPart1 = (int)(1.0 / PMetis.UB_FACTOR) * tpwgts[1];
        int bestMinCut = Integer.MAX_VALUE;
        int[] bestWhere = new int[numNodes];
        while (nbfs > 0) {
            int[] pwgts = new int[2];
            pwgts[1] = tpwgts[0] + tpwgts[1];
            pwgts[0] = 0;
            int i = 0;
            while (i < numNodes) {
                ((MetisNode)nodes[i].getData()).setPartition(1);
                ++i;
            }
            GrowBisection.bisection(graph, nodes, minWgtPart1, maxWgtPart1, pwgts);
            if (pwgts[1] == 0) {
                if (numNodes <= 0) {
                    return;
                }
                i = random.nextInt(numNodes);
                MetisNode nodeData = (MetisNode)nodes[i].getData();
                nodeData.setPartition(1);
                pwgts[0] = pwgts[0] + nodeData.getWeight();
                pwgts[1] = pwgts[1] - nodeData.getWeight();
            }
            metisGraph.computeTwoWayPartitionParams();
            Balancer.balanceTwoWay(metisGraph, tpwgts);
            FMTwoWayRefiner.fmTwoWayEdgeRefine(metisGraph, tpwgts, 4);
            if (bestMinCut > metisGraph.getMinCut()) {
                bestMinCut = metisGraph.getMinCut();
                i = 0;
                while (i < bestWhere.length) {
                    bestWhere[i] = ((MetisNode)nodes[i].getData()).getPartition();
                    ++i;
                }
            }
            --nbfs;
        }
        int i = 0;
        while (i < numNodes) {
            ((MetisNode)nodes[i].getData()).setPartition(bestWhere[i]);
            ++i;
        }
        metisGraph.setMinCut(bestMinCut);
    }

    private static void bisection(IntGraph<MetisNode> graph, GNode<MetisNode>[] nodes, int minWgtPart1, int maxWgtPart1, int[] pwgts) {
        int numNodes = nodes.length;
        int[] visited = new int[numNodes];
        int[] queue = new int[numNodes];
        Arrays.fill(visited, 0);
        if (numNodes <= 0) {
            return;
        }
        queue[0] = random.nextInt(numNodes);
        visited[queue[0]] = 1;
        int first = 0;
        int last = 1;
        int nleft = numNodes - 1;
        boolean drain = false;
        while (true) {
            if (first == last) {
                if (nleft == 0 || drain) break;
                int k = random.nextInt(nleft);
                int i = 0;
                while (i < numNodes) {
                    if (visited[i] == 0) {
                        if (k == 0) break;
                        --k;
                    }
                    ++i;
                }
                queue[0] = i;
                visited[i] = 1;
                first = 0;
                last = 1;
                --nleft;
            }
            int i = queue[first++];
            int nodeWeight = nodes[i].getData().getWeight();
            if (pwgts[0] > 0 && pwgts[1] - nodeWeight < minWgtPart1) {
                drain = true;
                continue;
            }
            nodes[i].getData().setPartition(0);
            pwgts[0] = pwgts[0] + nodeWeight;
            pwgts[1] = pwgts[1] - nodeWeight;
            if (pwgts[1] <= maxWgtPart1) break;
            drain = false;
            AccessNeighborClosure closure = new AccessNeighborClosure(last, nleft, visited, queue);
            nodes[i].map(closure, nodes[i]);
            last = closure.last;
            nleft = closure.nleft;
        }
    }

    static class AccessNeighborClosure
    implements Lambda2Void<GNode<MetisNode>, GNode<MetisNode>> {
        int last;
        int nleft;
        int[] visited;
        int[] queue;

        public AccessNeighborClosure(int last, int nleft, int[] visited, int[] queue) {
            this.last = last;
            this.nleft = nleft;
            this.visited = visited;
            this.queue = queue;
        }

        @Override
        public void call(GNode<MetisNode> neighbor, GNode<MetisNode> src) {
            int k = neighbor.getData().getNodeId();
            if (this.visited[k] == 0) {
                this.queue[this.last++] = k;
                this.visited[k] = 1;
                --this.nleft;
            }
        }
    }

    static class SaveNodesToArray
    implements LambdaVoid<GNode<MetisNode>> {
        GNode<MetisNode>[] nodes;

        public SaveNodesToArray(GNode<MetisNode>[] nodes) {
            this.nodes = nodes;
        }

        @Override
        public void call(GNode<MetisNode> node) {
            this.nodes[node.getData().getNodeId()] = node;
        }
    }
}

