/*
 * Decompiled with CFR 0.152.
 */
package evacSim.partition;

import com.vividsolutions.jts.geom.Coordinate;
import edu.uci.ics.jung.graph.Graph;
import evacSim.ContextCreator;
import evacSim.GlobalVariables;
import evacSim.citycontext.CityContext;
import evacSim.citycontext.Junction;
import evacSim.citycontext.Road;
import evacSim.citycontext.Zone;
import evacSim.partition.GrowBisection;
import evacSim.partition.MetisGraph;
import evacSim.partition.MetisNode;
import galois.objects.graph.GNode;
import galois.objects.graph.IntGraph;
import galois.objects.graph.MorphGraph;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import repast.simphony.context.space.graph.ContextJungNetwork;
import repast.simphony.space.gis.Geography;
import repast.simphony.space.graph.JungNetwork;
import repast.simphony.space.graph.Network;
import repast.simphony.space.graph.RepastEdge;
import repast.simphony.space.projection.ProjectionEvent;
import repast.simphony.space.projection.ProjectionListener;

public class GaliosGraphConverter<T>
implements ProjectionListener<T> {
    private Logger logger = ContextCreator.logger;
    public Graph<T, RepastEdge<T>> RepastGraph;
    public static Network<Junction> roadNetwork;
    public IntGraph<MetisNode> GaliosGraph;
    private Geography<Zone> zoneGeography;
    public MetisGraph metisGraph;
    public static CityContext cityContext;
    private HashMap<T, Integer> Node2GaliosID;
    private HashMap<Integer, T> GaliosID2Node;
    public ArrayList<ArrayList<Road>> PartitionedInRoads;
    public ArrayList<Road> PartitionedBwRoads;
    public ArrayList<ArrayList<Integer>> BwRoadMembership;
    public ArrayList<GNode<MetisNode>> nodes;
    public ArrayList<Integer> PartitionWeights;
    public ArrayList<Road> ResolvedRoads;
    public ArrayList<Road> LeftOverRoads;
    private int nodeNum;
    private int edgeNum;
    private int alpha;
    private int beta;
    private int gamma;

    public GaliosGraphConverter() {
        cityContext = ContextCreator.getCityContext();
        this.RepastGraph = null;
        this.GaliosGraph = new MorphGraph.IntGraphBuilder().backedByVector(true).directed(true).create();
        this.metisGraph = new MetisGraph();
        assert (this.GaliosGraph != null);
        this.Node2GaliosID = new HashMap();
        this.GaliosID2Node = new HashMap();
        this.nodeNum = 0;
        this.edgeNum = 0;
        this.zoneGeography = ContextCreator.getZoneGeography();
        this.ResolvedRoads = new ArrayList();
        this.LeftOverRoads = new ArrayList();
        this.alpha = GlobalVariables.PART_ALPHA;
        this.beta = GlobalVariables.PART_BETA;
        this.gamma = GlobalVariables.PART_GAMMA;
    }

    public MetisGraph RepastToGaliosGraph(boolean mode) {
        int i = 0;
        try {
            roadNetwork = ContextCreator.getRoadNetwork();
            this.RepastGraph = null;
            if (roadNetwork instanceof JungNetwork) {
                this.RepastGraph = ((JungNetwork)roadNetwork).getGraph();
            } else if (roadNetwork instanceof ContextJungNetwork) {
                this.RepastGraph = ((ContextJungNetwork)roadNetwork).getGraph();
            }
            this.nodes = new ArrayList();
            this.nodeNum = this.RepastGraph.getVertexCount();
            int nodeWeight = 1;
            for (Object vertex : this.RepastGraph.getVertices()) {
                this.Node2GaliosID.put(vertex, i);
                this.GaliosID2Node.put(i, vertex);
                if (mode) {
                    Junction j = (Junction)vertex;
                    for (Zone zone : this.zoneGeography.getAllObjects()) {
                        Coordinate coord = zone.getCoord();
                        if (!j.getCoordinate().equals((Object)coord)) continue;
                        nodeWeight = zone.getEvacuatingDemand() * this.alpha + 1;
                    }
                }
                GNode<MetisNode> n = this.GaliosGraph.createNode(new MetisNode(i, nodeWeight));
                this.nodes.add(n);
                this.GaliosGraph.add(n);
                ++i;
            }
            for (RepastEdge edge : this.RepastGraph.getEdges()) {
                Object source = this.RepastGraph.getSource((Object)edge);
                Object dest = this.RepastGraph.getDest((Object)edge);
                Junction j1 = (Junction)source;
                Junction j2 = (Junction)dest;
                Road road = cityContext.findRoadBetweenJunctionIDs(j1.getJunctionID(), j2.getJunctionID());
                this.ResolvedRoads.add(road);
                int edgeWeight = 1 + road.getVehicleNum() * this.alpha + road.getShadowVehicleNum() * this.beta + road.getFutureRoutingVehNum() * this.gamma;
                GNode<MetisNode> n1 = this.nodes.get(this.Node2GaliosID.get(source));
                GNode<MetisNode> n2 = this.nodes.get(this.Node2GaliosID.get(dest));
                this.GaliosGraph.addEdge(n1, n2, edgeWeight);
                this.GaliosGraph.addEdge(n2, n1, edgeWeight);
                n1.getData().addEdgeWeight(edgeWeight);
                n1.getData().incNumEdges();
                n2.getData().addEdgeWeight(edgeWeight);
                n2.getData().incNumEdges();
                if (edgeWeight > 1) {
                    n2.getData().setWeight(n2.getData().getWeight() - 1 + edgeWeight);
                }
                ++this.edgeNum;
            }
            this.metisGraph.setNumEdges(this.edgeNum);
            this.metisGraph.setGraph(this.GaliosGraph);
            this.computeLeftOverRoads();
            this.logger.info((Object)("Finished reading Repast graph " + this.GaliosGraph.size() + " " + this.metisGraph.getNumEdges() + " # Leftover roads: " + this.LeftOverRoads.size()));
            return this.metisGraph;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void GaliosToRepastGraph(IntGraph<MetisNode> resultGraph, int nparts) {
        try {
            GNode[] nodes = new GNode[resultGraph.size()];
            resultGraph.map(new GrowBisection.SaveNodesToArray(nodes));
            this.PartitionWeights = new ArrayList();
            this.PartitionedInRoads = new ArrayList(nparts);
            int i = 0;
            while (i < nparts) {
                this.PartitionedInRoads.add(new ArrayList());
                this.PartitionWeights.add(0);
                ++i;
            }
            this.PartitionedBwRoads = new ArrayList();
            this.BwRoadMembership = new ArrayList();
            i = 0;
            for (RepastEdge edge : this.RepastGraph.getEdges()) {
                Object source = this.RepastGraph.getSource((Object)edge);
                Object dest = this.RepastGraph.getDest((Object)edge);
                Junction j1 = (Junction)source;
                Junction j2 = (Junction)dest;
                Road road = cityContext.findRoadBetweenJunctionIDs(j1.getJunctionID(), j2.getJunctionID());
                GNode n1 = nodes[this.Node2GaliosID.get(source)];
                GNode n2 = nodes[this.Node2GaliosID.get(dest)];
                int edgeWeight = 1 + road.getVehicleNum() * this.alpha + road.getShadowVehicleNum() * this.beta + road.getFutureRoutingVehNum() * this.gamma;
                if (((MetisNode)n1.getData()).getPartition() == ((MetisNode)n2.getData()).getPartition()) {
                    this.PartitionedInRoads.get(((MetisNode)n1.getData()).getPartition()).add(road);
                    this.PartitionWeights.set(((MetisNode)n1.getData()).getPartition(), this.PartitionWeights.get(((MetisNode)n1.getData()).getPartition()) + edgeWeight);
                    continue;
                }
                this.PartitionedBwRoads.add(road);
                ArrayList<Integer> tempList = new ArrayList<Integer>();
                tempList.add(((MetisNode)n1.getData()).getPartition());
                tempList.add(((MetisNode)n2.getData()).getPartition());
                this.BwRoadMembership.add(tempList);
                if (this.PartitionWeights.get(((MetisNode)n1.getData()).getPartition()) < this.PartitionWeights.get(((MetisNode)n2.getData()).getPartition())) {
                    this.PartitionedInRoads.get(((MetisNode)n1.getData()).getPartition()).add(road);
                    this.PartitionWeights.set(((MetisNode)n1.getData()).getPartition(), this.PartitionWeights.get(((MetisNode)n1.getData()).getPartition()) + edgeWeight);
                    continue;
                }
                this.PartitionedInRoads.get(((MetisNode)n2.getData()).getPartition()).add(road);
                this.PartitionWeights.set(((MetisNode)n2.getData()).getPartition(), this.PartitionWeights.get(((MetisNode)n2.getData()).getPartition()) + edgeWeight);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void computeLeftOverRoads() {
        for (Road r : ContextCreator.getRoadContext().getObjects(Road.class)) {
            this.LeftOverRoads.add(r);
        }
        this.LeftOverRoads.removeAll(this.ResolvedRoads);
    }

    public ArrayList<ArrayList<Road>> getPartitionedInRoads() {
        int minWeight = Integer.MAX_VALUE;
        int index = 0;
        int i = 0;
        while (i < this.PartitionWeights.size()) {
            if (minWeight > this.PartitionWeights.get(i)) {
                minWeight = this.PartitionWeights.get(i);
                index = i;
            }
            ++i;
        }
        for (Road r : this.LeftOverRoads) {
            this.PartitionedInRoads.get(index).add(r);
        }
        return this.PartitionedInRoads;
    }

    public ArrayList<Road> getPartitionedBwRoads() {
        for (Road r : this.LeftOverRoads) {
            this.PartitionedBwRoads.add(r);
        }
        return this.PartitionedBwRoads;
    }

    public ArrayList<ArrayList<Integer>> getBwRoadMembership() {
        return this.BwRoadMembership;
    }

    public ArrayList<Integer> getPartitionWeights() {
        return this.PartitionWeights;
    }

    public void projectionEventOccurred(ProjectionEvent<T> evt) {
    }
}

