/*
 * Decompiled with CFR 0.152.
 */
package evacSim.partition;

import evacSim.partition.MetisGraph;
import evacSim.partition.MetisNode;
import evacSim.partition.PMetis;
import evacSim.partition.PQueue;
import galois.objects.graph.GNode;
import galois.objects.graph.IntGraph;
import java.util.Arrays;
import util.fn.Lambda2Void;
import util.fn.LambdaVoid;

public class Balancer {
    public static void balanceTwoWay(MetisGraph metisGraph, int[] tpwgts) {
        int pwgts0 = metisGraph.getPartWeight(0);
        int pwgts1 = metisGraph.getPartWeight(1);
        int mindiff = Math.abs(tpwgts[0] - pwgts0);
        if (mindiff < 3 * (pwgts0 + pwgts1) / metisGraph.getGraph().size()) {
            return;
        }
        if (pwgts0 > tpwgts[0] && pwgts0 < (int)(PMetis.UB_FACTOR * (double)tpwgts[0])) {
            return;
        }
        if (pwgts1 > tpwgts[1] && pwgts1 < (int)(PMetis.UB_FACTOR * (double)tpwgts[1])) {
            return;
        }
        if (metisGraph.getNumOfBoundaryNodes() > 0) {
            Balancer.boundaryTwoWayBalance(metisGraph, tpwgts);
        } else {
            Balancer.generalTwoWayBalance(metisGraph, tpwgts);
        }
    }

    private static void boundaryTwoWayBalance(final MetisGraph metisGraph, int[] tpwgts) {
        final IntGraph<MetisNode> graph = metisGraph.getGraph();
        int numNodes = graph.size();
        final int[] moved = new int[numNodes];
        Arrays.fill(moved, -1);
        final int mindiff = Math.abs(tpwgts[0] - metisGraph.getPartWeight(0));
        int from = 0;
        int to = 1;
        if (metisGraph.getPartWeight(0) < tpwgts[0]) {
            from = 1;
            to = 0;
        }
        final PQueue queue = new PQueue(numNodes, metisGraph.getMaxAdjSum());
        for (GNode<MetisNode> boundaryNode : metisGraph.getBoundaryNodes()) {
            MetisNode boundaryNodeData = boundaryNode.getData();
            boundaryNodeData.updateGain();
            if (boundaryNodeData.getPartition() != from || boundaryNodeData.getWeight() > mindiff) continue;
            queue.insert(boundaryNode, boundaryNodeData.getGain());
        }
        int mincut = metisGraph.getMinCut();
        int nswaps = 0;
        while (nswaps < numNodes) {
            final GNode<MetisNode> higain = queue.getMax();
            if (higain == null) break;
            MetisNode higainData = higain.getData();
            if (metisGraph.getPartWeight(to) + higainData.getWeight() > tpwgts[to]) break;
            mincut -= higainData.getEdegree() - higainData.getIdegree();
            metisGraph.incPartWeight(from, -higainData.getWeight());
            metisGraph.incPartWeight(to, higainData.getWeight());
            higainData.setPartition(to);
            moved[higainData.getNodeId()] = nswaps;
            higainData.swapEDAndID();
            higainData.updateGain();
            if (higainData.getEdegree() == 0 && graph.outNeighborsSize(higain) != 0) {
                metisGraph.unsetBoundaryNode(higain);
            }
            final int toConstant = to;
            final int fromConstant = from;
            higain.map(new Lambda2Void<GNode<MetisNode>, GNode<MetisNode>>(){

                @Override
                public void call(GNode<MetisNode> neighbor, GNode<MetisNode> node) {
                    MetisNode neighborData = neighbor.getData();
                    int oldgain = neighborData.getGain();
                    int edgeWeight = graph.getEdgeData(higain, neighbor);
                    int kwgt = toConstant == neighborData.getPartition() ? edgeWeight : -edgeWeight;
                    neighborData.setEdegree(neighborData.getEdegree() - kwgt);
                    neighborData.setIdegree(neighborData.getIdegree() + kwgt);
                    neighborData.updateGain();
                    if (neighborData.isBoundary()) {
                        if (neighborData.getEdegree() == 0) {
                            metisGraph.unsetBoundaryNode(neighbor);
                            if (moved[neighborData.getNodeId()] == -1 && neighborData.getPartition() == fromConstant && neighborData.getWeight() <= mindiff) {
                                queue.delete(neighbor, oldgain);
                            }
                        } else if (moved[neighborData.getNodeId()] == -1 && neighborData.getPartition() == fromConstant && neighborData.getWeight() <= mindiff) {
                            queue.update(neighbor, oldgain, neighborData.getGain());
                        }
                    } else if (neighborData.getEdegree() > 0) {
                        metisGraph.setBoundaryNode(neighbor);
                        if (moved[neighborData.getNodeId()] == -1 && neighborData.getPartition() == fromConstant && neighborData.getWeight() <= mindiff) {
                            queue.insert(neighbor, neighborData.getGain());
                        }
                    }
                }
            }, higain);
            ++nswaps;
        }
        metisGraph.setMinCut(mincut);
    }

    private static void generalTwoWayBalance(final MetisGraph metisGraph, int[] tpwgts) {
        final IntGraph<MetisNode> graph = metisGraph.getGraph();
        int numNodes = graph.size();
        final int[] moved = new int[numNodes];
        final int mindiff = Math.abs(tpwgts[0] - metisGraph.getPartWeight(0));
        int from = 0;
        int to = 1;
        if (metisGraph.getPartWeight(0) < tpwgts[0]) {
            from = 1;
            to = 0;
        }
        final PQueue queue = new PQueue(numNodes, metisGraph.getMaxAdjSum());
        Arrays.fill(moved, -1);
        final int fromConstant = from;
        graph.map(new LambdaVoid<GNode<MetisNode>>(){

            @Override
            public void call(GNode<MetisNode> node) {
                MetisNode nodeData = node.getData();
                int part = nodeData.getPartition();
                if (part == fromConstant && nodeData.getWeight() <= mindiff) {
                    queue.insert(node, nodeData.getGain());
                }
            }
        });
        int mincut = metisGraph.getMinCut();
        int nswaps = 0;
        while (nswaps < numNodes) {
            final GNode<MetisNode> higain = queue.getMax();
            if (higain == null) break;
            MetisNode higainData = higain.getData();
            if (metisGraph.getPartWeight(to) + higainData.getWeight() > tpwgts[to]) break;
            mincut -= higainData.getEdegree() - higainData.getIdegree();
            metisGraph.incPartWeight(from, -higainData.getWeight());
            metisGraph.incPartWeight(to, higainData.getWeight());
            higainData.setPartition(to);
            moved[higainData.getNodeId()] = nswaps;
            higainData.swapEDAndID();
            if (higainData.getEdegree() == 0 && higainData.isBoundary() && graph.outNeighborsSize(higain) != 0) {
                metisGraph.unsetBoundaryNode(higain);
            }
            if (higainData.getEdegree() > 0 && !higainData.isBoundary()) {
                metisGraph.setBoundaryNode(higain);
            }
            final int toConstant = to;
            higain.map(new Lambda2Void<GNode<MetisNode>, GNode<MetisNode>>(){

                @Override
                public void call(GNode<MetisNode> neighbor, GNode<MetisNode> node) {
                    MetisNode neighborData = neighbor.getData();
                    int oldgain = neighborData.getGain();
                    int edgeWeight = graph.getEdgeData(higain, neighbor);
                    int kwgt = toConstant == neighborData.getPartition() ? edgeWeight : -edgeWeight;
                    neighborData.setEdegree(neighborData.getEdegree() - kwgt);
                    neighborData.setIdegree(neighborData.getIdegree() + kwgt);
                    neighborData.updateGain();
                    if (moved[neighborData.getNodeId()] == -1 && neighborData.getPartition() == fromConstant && neighborData.getWeight() <= mindiff) {
                        queue.update(neighbor, oldgain, neighborData.getGain());
                    }
                    if (neighborData.getEdegree() == 0 && neighborData.isBoundary()) {
                        metisGraph.unsetBoundaryNode(neighbor);
                    } else if (neighborData.getEdegree() > 0 && !neighborData.isBoundary()) {
                        metisGraph.setBoundaryNode(neighbor);
                    }
                }
            }, higain);
            ++nswaps;
        }
        metisGraph.setMinCut(mincut);
    }

    public static void greedyKWayEdgeBalance(final MetisGraph metisGraph, int nparts, float[] tpwgts, float ubfactor, int npasses) {
        int[] minwgts = new int[nparts];
        int[] maxwgts = new int[nparts];
        int[] itpwgts = new int[nparts];
        int tvwgt = 0;
        int i = 0;
        while (i < nparts) {
            tvwgt += metisGraph.getPartWeight(i);
            ++i;
        }
        i = 0;
        while (i < nparts) {
            itpwgts[i] = (int)(tpwgts[i] * (float)tvwgt);
            maxwgts[i] = (int)(tpwgts[i] * (float)tvwgt * ubfactor);
            minwgts[i] = (int)((double)(tpwgts[i] * (float)tvwgt) * (1.0 / (double)ubfactor));
            ++i;
        }
        final IntGraph<MetisNode> graph = metisGraph.getGraph();
        final PQueue queue = new PQueue(graph.size(), metisGraph.getMaxAdjSum());
        int pass = 0;
        while (pass < npasses) {
            GNode<MetisNode> higain;
            int i2 = 0;
            while (i2 < nparts) {
                if (metisGraph.getPartWeight(i2) > maxwgts[i2]) break;
                ++i2;
            }
            if (i2 == nparts) break;
            queue.reset();
            final int[] moved = new int[graph.size()];
            Arrays.fill(moved, -1);
            for (GNode<MetisNode> boundaryNode : metisGraph.getBoundaryNodes()) {
                MetisNode boundaryNodeData = boundaryNode.getData();
                boundaryNodeData.updateGain();
                queue.insert(boundaryNode, boundaryNodeData.getGain());
                moved[boundaryNodeData.getNodeId()] = 2;
            }
            while ((higain = queue.getMax()) != null) {
                int to;
                MetisNode higainData = higain.getData();
                moved[higainData.getNodeId()] = 1;
                final int from = higainData.getPartition();
                if (metisGraph.getPartWeight(from) - higainData.getWeight() < minwgts[from]) continue;
                int k = 0;
                while (k < higainData.getNDegrees()) {
                    to = higainData.partIndex[k];
                    if (metisGraph.getPartWeight(to) + higainData.getWeight() <= maxwgts[to] || itpwgts[from] * (metisGraph.getPartWeight(to) + higainData.getWeight()) <= itpwgts[to] * metisGraph.getPartWeight(from)) break;
                    ++k;
                }
                if (k == higainData.getNDegrees()) continue;
                int j = k + 1;
                while (j < higainData.getNDegrees()) {
                    int to2 = higainData.partIndex[j];
                    if (itpwgts[higainData.partIndex[k]] * metisGraph.getPartWeight(to2) < itpwgts[to2] * metisGraph.getPartWeight(higainData.partIndex[k])) {
                        k = j;
                    }
                    ++j;
                }
                to = higainData.partIndex[k];
                if (metisGraph.getPartWeight(from) < maxwgts[from] && metisGraph.getPartWeight(to) > minwgts[to] && higainData.partEd[k] - higainData.getIdegree() < 0) continue;
                metisGraph.setMinCut(metisGraph.getMinCut() - (higainData.partEd[k] - higainData.getIdegree()));
                higainData.setPartition(to);
                metisGraph.incPartWeight(to, higainData.getWeight());
                metisGraph.incPartWeight(from, -higainData.getWeight());
                higainData.setEdegree(higainData.getEdegree() - higainData.partEd[k] + higainData.getIdegree());
                int temp = higainData.partEd[k];
                higainData.partEd[k] = higainData.getIdegree();
                higainData.setIdegree(temp);
                if (higainData.partEd[k] == 0) {
                    higainData.setNDegrees(higainData.getNDegrees() - 1);
                    higainData.partEd[k] = higainData.partEd[higainData.getNDegrees()];
                    higainData.partIndex[k] = higainData.partIndex[higainData.getNDegrees()];
                } else {
                    higainData.partIndex[k] = from;
                }
                if (higainData.getEdegree() == 0) {
                    metisGraph.unsetBoundaryNode(higain);
                }
                higain.map(new Lambda2Void<GNode<MetisNode>, GNode<MetisNode>>(){

                    @Override
                    public void call(GNode<MetisNode> neighbor, GNode<MetisNode> node) {
                        int k;
                        MetisNode neighborData = neighbor.getData();
                        int oldgain = neighborData.getGain();
                        if (neighborData.partEd == null) {
                            int numEdges = neighborData.getNumEdges();
                            int ndegree = neighborData.getNDegrees();
                            if (ndegree <= numEdges) {
                                neighborData.partIndex = new int[numEdges];
                                neighborData.partEd = new int[numEdges];
                            } else {
                                neighborData.partIndex = new int[ndegree];
                                neighborData.partEd = new int[ndegree];
                            }
                        }
                        int edgeWeight = graph.getEdgeData(higain, neighbor);
                        if (neighborData.getPartition() == from) {
                            neighborData.setEdegree(neighborData.getEdegree() + edgeWeight);
                            neighborData.setIdegree(neighborData.getIdegree() - edgeWeight);
                            if (neighborData.getEdegree() - neighborData.getIdegree() > 0 && !neighborData.isBoundary()) {
                                metisGraph.setBoundaryNode(neighbor);
                            }
                        } else if (neighborData.getPartition() == to) {
                            neighborData.setEdegree(neighborData.getEdegree() - edgeWeight);
                            neighborData.setIdegree(neighborData.getIdegree() + edgeWeight);
                            if (neighborData.getEdegree() - neighborData.getIdegree() == 0 && neighborData.isBoundary()) {
                                metisGraph.unsetBoundaryNode(neighbor);
                            }
                        }
                        if (neighborData.getPartition() != from) {
                            k = 0;
                            while (k < neighborData.getNDegrees()) {
                                if (neighborData.partIndex[k] == from) {
                                    if (neighborData.partEd[k] == edgeWeight) {
                                        neighborData.setNDegrees(neighborData.getNDegrees() - 1);
                                        neighborData.partEd[k] = neighborData.partEd[neighborData.getNDegrees()];
                                        neighborData.partIndex[k] = neighborData.partIndex[neighborData.getNDegrees()];
                                        break;
                                    }
                                    int n = k;
                                    neighborData.partEd[n] = neighborData.partEd[n] - edgeWeight;
                                    break;
                                }
                                ++k;
                            }
                        }
                        if (neighborData.getPartition() != to) {
                            k = 0;
                            while (k < neighborData.getNDegrees()) {
                                if (neighborData.partIndex[k] == to) {
                                    int n = k;
                                    neighborData.partEd[n] = neighborData.partEd[n] + edgeWeight;
                                    break;
                                }
                                ++k;
                            }
                            if (k == neighborData.getNDegrees()) {
                                int nd = neighborData.getNDegrees();
                                if (nd >= neighborData.partIndex.length) {
                                    neighborData.partIndex = Arrays.copyOf(neighborData.partIndex, nd + 1);
                                    neighborData.partEd = Arrays.copyOf(neighborData.partEd, nd + 1);
                                }
                                neighborData.partIndex[nd] = to;
                                neighborData.partEd[nd++] = edgeWeight;
                                neighborData.setNDegrees(nd);
                            }
                        }
                        if (neighborData.getPartition() == from || neighborData.getPartition() == to) {
                            neighborData.updateGain();
                            if (moved[neighborData.getNodeId()] == 2) {
                                if (neighborData.getEdegree() > 0) {
                                    queue.update(neighbor, oldgain, neighborData.getGain());
                                } else {
                                    queue.delete(neighbor, oldgain);
                                    moved[neighborData.getNodeId()] = -1;
                                }
                            } else if (moved[neighborData.getNodeId()] == -1 && neighborData.getEdegree() > 0) {
                                queue.insert(neighbor, neighborData.getGain());
                                moved[neighborData.getNodeId()] = 2;
                            }
                        }
                    }
                }, higain);
            }
            ++pass;
        }
    }
}

