/*
 * Decompiled with CFR 0.152.
 */
package evacSim.network;

import evacSim.ContextCreator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import org.apache.log4j.Logger;

class MessageSocket {
    public static final String DELIMITER = "~~~";
    private static final boolean RECV_LOG = true;
    private static final boolean SEND_LOG = true;
    private static final int RECV_WAIT = 10;
    private static final int HEARTBEAT = 5000;
    private String host;
    private int port;
    private Socket socket;
    private BufferedReader reader;
    private BufferedWriter writer;
    private Vector<String[]> receiveLog;
    private Vector<String[]> sendLog;
    private int readCounter;
    private int receivedCounter;
    private Thread receivingThread;
    private boolean done;
    private Thread keepAliveThread;
    private boolean keepAlive;
    private Logger logger = ContextCreator.logger;

    MessageSocket(String host, int port, boolean keepAlive) {
        if (host.trim().length() < 1) {
            host = null;
        }
        this.host = host;
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port number: " + port);
        }
        this.port = port;
        this.receiveLog = new Vector();
        this.sendLog = new Vector();
        this.receivedCounter = 0;
        this.readCounter = 0;
        try {
            this.connect();
        }
        catch (Throwable t) {
            String msg = "Could not connect to " + host + ":" + port;
            throw new IllegalArgumentException(msg, t);
        }
        Runnable receiveRunnable = new Runnable(){

            @Override
            public void run() {
                MessageSocket.this.receiveLoop();
            }
        };
        this.receivingThread = new Thread(receiveRunnable);
        this.receivingThread.start();
        this.keepAlive = keepAlive;
        if (keepAlive) {
            Runnable keepAliveRunnable = new Runnable(){

                @Override
                public void run() {
                    MessageSocket.this.keepAliveLoop();
                }
            };
            this.keepAliveThread = new Thread(keepAliveRunnable);
            this.keepAliveThread.start();
        }
    }

    MessageSocket(String host, int port) {
        this(host, port, false);
    }

    private void connect() throws IOException {
        this.socket = new Socket(this.host, this.port);
        InputStream is = this.socket.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        this.reader = new BufferedReader(isr);
        OutputStream os = this.socket.getOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter(os);
        this.writer = new BufferedWriter(osw);
    }

    public void disconnect() throws IOException {
        if (this.keepAliveThread != null && this.keepAliveThread.isAlive()) {
            try {
                this.keepAliveThread.interrupt();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.receivingThread != null && this.receivingThread.isAlive()) {
            try {
                this.receivingThread.interrupt();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.reader != null) {
            this.reader.close();
        }
        if (this.writer != null) {
            this.writer.close();
        }
        if (this.socket != null) {
            this.socket.close();
        }
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean isOpen() {
        if (this.socket != null) {
            if (this.socket.isConnected()) {
                return !this.socket.isClosed();
            }
            return false;
        }
        return false;
    }

    public String[] nextMessage() {
        if (this.receiveLog == null) {
            return null;
        }
        try {
            String[] message = this.receiveLog.get(this.readCounter);
            ++this.readCounter;
            if (message == null) {
                message = new String[]{};
            }
            return message;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            return null;
        }
    }

    public boolean hasNext() {
        if (this.receiveLog == null) {
            return false;
        }
        int size = this.receiveLog.size();
        return this.readCounter < size;
    }

    public int logSize() {
        if (this.receiveLog == null) {
            return -1;
        }
        return this.receiveLog.size();
    }

    public int sentLogSize() {
        if (this.sendLog == null) {
            return -1;
        }
        return this.sendLog.size();
    }

    public String[] getLog(int index) {
        if (this.receiveLog == null) {
            return null;
        }
        try {
            return this.receiveLog.get(index);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            return null;
        }
    }

    public String[] getSentLog(int index) {
        if (this.sendLog == null) {
            return null;
        }
        try {
            return this.sendLog.get(index);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            return null;
        }
    }

    public void send(String[] message) throws IOException {
        if (this.writer == null) {
            return;
        }
        if (message == null) {
            return;
        }
        int i = 0;
        while (i < message.length) {
            this.writer.write(String.valueOf(message[i]) + "\n");
            ++i;
        }
        this.writer.write("~~~\n");
        this.writer.flush();
        if (this.sendLog != null) {
            this.sendLog.add(message);
        }
    }

    /*
     * Exception decompiling
     */
    public void receiveLoop() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void keepAliveLoop() {
        int h = 0;
        do {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ie) {
                return;
            }
            String[] heartbeat = new String[3];
            heartbeat[0] = "HEARTBEAT";
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd - HH:mm:ss");
            heartbeat[1] = df.format(new Date());
            heartbeat[2] = "# " + h++;
            try {
                this.send(heartbeat);
            }
            catch (IOException ioe) {
                this.logger.error((Object)"HEARTBEAT SENDING ERROR", (Throwable)ioe);
                this.done = true;
            }
        } while (!this.done);
    }
}

