/*
 * Decompiled with CFR 0.152.
 */
package evacSim.demand;

import au.com.bytecode.opencsv.CSVReader;
import evacSim.ContextCreator;
import evacSim.GlobalVariables;
import evacSim.citycontext.House;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class DatasetOfHouseholdsPerZones {
    private Logger logger = ContextCreator.logger;
    private TreeMap<Integer, HashMap<Integer, ArrayList<House>>> housesbyhour;

    public DatasetOfHouseholdsPerZones(String filepath) {
        if (GlobalVariables.SET_DEMAND_FROM_ACTIVITY_MODELS) {
            this.readActivityPlans(filepath);
        }
    }

    public void readActivityPlans(String filepath) {
        CSVReader csvreader = null;
        this.housesbyhour = new TreeMap();
        try {
            String[] nextLine;
            csvreader = new CSVReader((Reader)new FileReader(filepath));
            boolean readingheader = true;
            boolean firsthouse = true;
            int ID = 0;
            int zoneID = 0;
            int departureTime = 0;
            int prevID = 0;
            ArrayList<Integer> locations = new ArrayList<Integer>();
            ArrayList<Integer> durations = new ArrayList<Integer>();
            while ((nextLine = csvreader.readNext()) != null) {
                if (readingheader) {
                    readingheader = false;
                    continue;
                }
                int length = nextLine.length;
                int j = 0;
                while (j < length) {
                    if (j == 0) {
                        ID = Integer.parseInt(nextLine[j]);
                        if (firsthouse) {
                            prevID = ID;
                            firsthouse = false;
                        }
                    }
                    if (ID != prevID) {
                        zoneID = (Integer)locations.get(0);
                        departureTime = (int)Math.floor((Integer)durations.get(0) / 60);
                        House h = new House(prevID, zoneID);
                        h.setActivityPlan(locations, durations);
                        ++GlobalVariables.NUM_HOUSES;
                        if (!this.housesbyhour.containsKey(departureTime)) {
                            HashMap housebyzone = new HashMap();
                            this.housesbyhour.put(departureTime, housebyzone);
                        }
                        if (!this.housesbyhour.get(departureTime).containsKey(zoneID)) {
                            ArrayList<House> arraylistwithfirsthouse = new ArrayList<House>();
                            arraylistwithfirsthouse.add(h);
                            this.housesbyhour.get(departureTime).put(zoneID, arraylistwithfirsthouse);
                        } else {
                            this.housesbyhour.get(departureTime).get(zoneID).add(h);
                        }
                        locations.clear();
                        durations.clear();
                    }
                    prevID = ID;
                    if (j == 1) {
                        locations.add(Integer.parseInt(nextLine[j]));
                    }
                    if (j == 2) {
                        durations.add(Integer.parseInt(nextLine[j]));
                    }
                    ++j;
                }
            }
            this.logger.info((Object)("Total houses generated: " + GlobalVariables.NUM_HOUSES));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public TreeMap<Integer, HashMap<Integer, ArrayList<House>>> getHousesByHour() {
        return this.housesbyhour;
    }
}

