/*
 * Decompiled with CFR 0.152.
 */
package evacSim.data;

import com.vividsolutions.jts.geom.Coordinate;
import evacSim.ContextCreator;
import evacSim.NetworkEventObject;
import evacSim.citycontext.Plan;
import evacSim.citycontext.Road;
import evacSim.citycontext.Zone;
import evacSim.vehiclecontext.Vehicle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jdk.nashorn.internal.runtime.regexp.joni.exception.ValueException;
import org.apache.log4j.Logger;

public class TickSnapshot {
    private Logger logger = ContextCreator.logger;
    private final int tickNumber;
    private List<VehicleSnapshot> vehicles;
    private List<RoadSnapshot> roads;
    private List<ShelterSnapshot> shelters;
    private List<NewVehSnapshot> newVehs;
    private List<ArrVehSnapshot> arrVehs;
    private List<ArrayList<NetworkEventObject>> events;

    public TickSnapshot(double tickNumber) {
        if (tickNumber < 0.0) {
            throw new IllegalArgumentException("Invalid tick number");
        }
        this.tickNumber = (int)tickNumber;
        this.vehicles = Collections.synchronizedList(new ArrayList());
        this.roads = Collections.synchronizedList(new ArrayList());
        this.shelters = Collections.synchronizedList(new ArrayList());
        this.newVehs = Collections.synchronizedList(new ArrayList());
        this.arrVehs = Collections.synchronizedList(new ArrayList());
        this.events = Collections.synchronizedList(new ArrayList(3));
        int i = 0;
        while (i < 3) {
            this.events.add(new ArrayList());
            ++i;
        }
    }

    public void recordVehicleSnapshot(Vehicle veh, Coordinate coord) {
        new VehicleSnapshot(veh, coord);
    }

    public void recordRoadSnapshot(Road road) {
        new RoadSnapshot(road);
    }

    public void recordShelterSnapshot(Zone shelter) {
        new ShelterSnapshot(shelter);
    }

    public void recordNewVehSnapshot(Vehicle veh) {
        new NewVehSnapshot(veh);
    }

    public void recordArrVehSnapshot(Vehicle veh) {
        new ArrVehSnapshot(veh);
    }

    public int getTickNumber() {
        return this.tickNumber;
    }

    public boolean isEmpty() {
        return this.vehicles.isEmpty() && this.roads.isEmpty() && this.shelters.isEmpty() && this.newVehs.isEmpty() && this.arrVehs.isEmpty();
    }

    public ArrayList<String> createJSONTickLines(String objectType) {
        ArrayList<String> lines = new ArrayList<String>();
        if (objectType == "vehicle") {
            for (VehicleSnapshot vehicleSnapshot : this.vehicles) {
                if (vehicleSnapshot == null) continue;
                lines.add(vehicleSnapshot.getJSONLine());
            }
        }
        if (objectType == "road") {
            for (RoadSnapshot roadSnapshot : this.roads) {
                if (roadSnapshot == null) continue;
                lines.add(roadSnapshot.getJSONLine());
            }
        }
        if (objectType == "shelter") {
            for (ShelterSnapshot shelterSnapshot : this.shelters) {
                if (shelterSnapshot == null) continue;
                lines.add(shelterSnapshot.getJSONLine());
            }
        }
        if (objectType == "newVeh") {
            for (NewVehSnapshot newVehSnapshot : this.newVehs) {
                if (newVehSnapshot == null) continue;
                lines.add(newVehSnapshot.getJSONLine());
            }
        }
        if (objectType == "arrVeh") {
            for (ArrVehSnapshot arrVehSnapshot : this.arrVehs) {
                if (arrVehSnapshot == null) continue;
                lines.add(arrVehSnapshot.getJSONLine());
            }
        }
        return lines;
    }

    public ArrayList<String> createCSVTickLines() {
        ArrayList<String> lines = new ArrayList<String>();
        for (VehicleSnapshot veh : this.vehicles) {
            if (veh == null) continue;
            lines.add(veh.getCSVLine());
        }
        return lines;
    }

    public void logEvent(NetworkEventObject event, int type) throws Throwable {
        if (event == null) {
            throw new IllegalArgumentException("No event given.");
        }
        if (type == 1) {
            this.events.get(0).add(event);
        } else if (type == 2) {
            this.events.get(1).add(event);
        } else {
            this.events.get(2).add(event);
        }
    }

    public List<VehicleSnapshot> getVehicleList() {
        if (this.vehicles == null || this.vehicles.isEmpty()) {
            return null;
        }
        ArrayList<Integer> vID = new ArrayList<Integer>();
        for (VehicleSnapshot v : this.vehicles) {
            vID.add(v.id);
        }
        return this.vehicles;
    }

    public List<ArrayList<NetworkEventObject>> getEventList() {
        if (this.events == null || this.events.isEmpty()) {
            return null;
        }
        return this.events;
    }

    public VehicleSnapshot getVehicleSnapshot(int id) {
        if (this.vehicles == null || this.vehicles.isEmpty()) {
            return null;
        }
        VehicleSnapshot snapshot = this.vehicles.get(id);
        return snapshot;
    }

    private class ArrVehSnapshot {
        final int id;

        ArrVehSnapshot(Vehicle veh) {
            this.id = veh.getVehicleID();
            TickSnapshot.this.arrVehs.add(this);
        }

        String getJSONLine() {
            return String.format("%d", this.id);
        }
    }

    private class NewVehSnapshot {
        final int id;
        final int origID;
        final int destID;

        NewVehSnapshot(Vehicle veh) {
            this.id = veh.getVehicleID();
            ArrayList<Plan> plans = veh.getHouse().getActivityPlan();
            this.origID = plans.get(0).getLocation();
            this.destID = plans.get(1).getLocation();
            TickSnapshot.this.newVehs.add(this);
        }

        String getJSONLine() {
            return String.format("%d,%d,%d", this.id, this.origID, this.destID);
        }
    }

    private class RoadSnapshot {
        final int id;
        final double speed;
        final int nVehicles;

        RoadSnapshot(Road road) {
            this.id = road.getLinkid();
            this.speed = road.calcSpeed();
            this.nVehicles = road.getVehicleNum();
            if (this.id < 0) {
                throw new ValueException("Road ID negative for " + this.id);
            }
            if (this.speed < 0.0) {
                throw new ValueException("Speed is negative for " + this.id);
            }
            if (this.nVehicles < 0) {
                throw new ValueException("No. of vehicles on road is negative for " + this.id);
            }
            if (Double.isNaN(this.speed) || Double.isInfinite(this.speed)) {
                throw new NumberFormatException("Speed is NaN for " + this.id);
            }
            TickSnapshot.this.roads.add(this);
        }

        String getJSONLine() {
            return String.format("%d,%d,%.3f", this.id, this.nVehicles, this.speed);
        }
    }

    private class ShelterSnapshot {
        final int id;
        final int occupancy;

        ShelterSnapshot(Zone shelter) {
            if (shelter.getType() != 1) {
                throw new ValueException("Shelter's zone type must be 1. Error in " + shelter);
            }
            this.id = shelter.getIntegerId();
            this.occupancy = shelter.getOccupancy();
            int capacity = shelter.getCapacity();
            if (this.occupancy < 0) {
                throw new ValueException("Shelter availability is negative for " + shelter);
            }
            if (this.occupancy > capacity) {
                throw new ValueException("Shelter availability is greater than capacity " + capacity + " for " + shelter);
            }
            TickSnapshot.this.shelters.add(this);
        }

        String getJSONLine() {
            return String.format("%d,%d", this.id, this.occupancy);
        }
    }

    private class VehicleSnapshot {
        int id;
        double prevX;
        double prevY;
        double curX;
        double curY;
        float speed;
        double bearing;
        int roadID;

        VehicleSnapshot(Vehicle veh, Coordinate coord) {
            this.id = veh.getVehicleID();
            this.prevX = veh.getPreviousEpochCoord().x;
            this.prevY = veh.getPreviousEpochCoord().y;
            this.curX = coord.x;
            this.curY = coord.y;
            this.speed = veh.currentSpeed();
            this.bearing = veh.getBearing();
            this.roadID = veh.getRoad().getID();
            if (this.id < 0) {
                throw new ValueException("Vehicle ID cannot be negative.");
            }
            if (this.roadID < 0) {
                throw new ValueException("Road ID cannot be negative.");
            }
            if (Double.isNaN(this.curX) || Double.isInfinite(this.curX) || Double.isNaN(this.curY) || Double.isInfinite(this.curY)) {
                throw new ValueException("Current coordinate invalid for " + veh);
            }
            if (Float.isNaN(this.speed) || Float.isInfinite(this.speed)) {
                throw new ValueException("Speed invalid for " + veh);
            }
            if (Double.isNaN(this.bearing) || Double.isInfinite(this.bearing)) {
                throw new ValueException("Bearing invalid for " + veh);
            }
            TickSnapshot.this.vehicles.add(this);
        }

        String getJSONLine() {
            String output = String.format("%d,%.5f,%.5f,%.2f,%.2f", this.id, this.curX, this.curY, Float.valueOf(this.speed), this.bearing);
            if (output == null || output.isEmpty()) {
                TickSnapshot.this.logger.error((Object)("empty/null string for " + this.id));
            }
            return output;
        }

        String getCSVLine() {
            return String.format("%d, %.6f,%.6f,%.3f", this.id, this.curX, this.curY, Float.valueOf(this.speed));
        }
    }
}

